/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel;

import dev.djefrey.colorwheel.ClrwlConfig;
import dev.djefrey.colorwheel.ClrwlXplat;
import dev.djefrey.colorwheel.accessors.ProgramSetAccessor;
import dev.djefrey.colorwheel.engine.ClrwlEngine;
import dev.djefrey.colorwheel.util.AccumulateTimer;
import dev.engine_room.flywheel.api.backend.Backend;
import dev.engine_room.flywheel.backend.gl.GlCompat;
import dev.engine_room.flywheel.lib.backend.SimpleBackend;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Optional;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.shaderpack.ShaderPack;
import net.irisshaders.iris.shaderpack.programs.ProgramSet;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Colorwheel {
    public static final String MOD_ID = "colorwheel";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"colorwheel");
    public static final Backend IRIS_INSTANCING = SimpleBackend.builder().engineFactory(level -> new ClrwlEngine((LevelAccessor)level, 256)).priority(500).supported(() -> GlCompat.SUPPORTS_INSTANCING && Colorwheel.isUsingCompatibleShaderPack()).register(Colorwheel.rl("instancing"));
    public static ClrwlConfig CONFIG = null;
    public static String FORMATTED_VERSION = ClrwlXplat.INSTANCE.getFormattedVersion();
    private static final AccumulateTimer ACCUMULATE_INCOMPATIBLE = new AccumulateTimer(0.5f);

    public static void init() {
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static boolean isUsingCompatibleShaderPack() {
        Optional pack = Iris.getCurrentPack();
        if (pack.isEmpty()) {
            return false;
        }
        if (!CONFIG.isFallbackModeEnabled()) {
            String name = Iris.getCurrentPackName();
            ProgramSet programSet = ((ShaderPack)pack.get()).getProgramSet(Iris.getCurrentDimension());
            boolean isFallback = ((ProgramSetAccessor)programSet).colorwheel$isFallbackMode();
            if (isFallback) {
                if (CONFIG.shouldAlertIncompatiblePack()) {
                    ACCUMULATE_INCOMPATIBLE.request(() -> {
                        Optional<String> patch = Colorwheel.findPatchedShaderpack(name);
                        Colorwheel.sendEmptyMessage();
                        MutableComponent packComp = Component.m_237113_((String)name).m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true)));
                        Colorwheel.sendErrorMessage((Component)Component.m_237110_((String)"colorwheel.alert.incompatible_pack", (Object[])new Object[]{packComp}), true);
                        if (patch.isPresent()) {
                            MutableComponent patchComp = Component.m_237113_((String)patch.get()).m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true)));
                            Colorwheel.sendErrorMessage((Component)Component.m_237110_((String)"colorwheel.alert.incompatible_pack.patch_available", (Object[])new Object[]{patchComp}), false);
                        } else {
                            MutableComponent fallbackComp = Component.m_237115_((String)"colorwheel.fallback_mode").m_130948_(Style.f_131099_.m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/colorwheel enableFallbackMode on")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"colorwheel.fallback_mode.enable"))));
                            Colorwheel.sendErrorMessage((Component)Component.m_237110_((String)"colorwheel.alert.incompatible_pack.ask_fallback_mode", (Object[])new Object[]{fallbackComp}), false);
                        }
                        MutableComponent disableComp = Component.m_237115_((String)"colorwheel.alert.ask_disable").m_130948_(Style.f_131099_.m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/colorwheel alertIncompatiblePack off")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"colorwheel.alert.incompatible_pack.disable"))));
                        Colorwheel.sendEmptyMessage();
                        Colorwheel.sendErrorMessage((Component)disableComp, false);
                        Colorwheel.sendEmptyMessage();
                    });
                }
                return false;
            }
        }
        WorldRenderingPipeline worldPipeline = Iris.getPipelineManager().getPipelineNullable();
        return worldPipeline instanceof IrisRenderingPipeline;
    }

    public static Optional<String> findPatchedShaderpack(String shaderpack) {
        Path shaderpackFolder = Iris.getShaderpacksDirectory();
        try {
            Optional maybePatch;
            Class<?> clazz = Class.forName("dev.djefrey.colorwheel_patcher.ClrwlPatcher");
            Method method = clazz.getMethod("findPatchedShaderpackInFolder", String.class, Path.class);
            Object res = method.invoke(null, shaderpack, shaderpackFolder);
            if (res instanceof Optional && (maybePatch = (Optional)res).isPresent() && maybePatch.get() instanceof String) {
                return Optional.of((String)maybePatch.get());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static void sendWarnMessage(MutableComponent component, boolean prefix) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        MutableComponent comp = prefix ? Component.m_237113_((String)"[Colorwheel] ") : Component.m_237119_();
        comp.m_7220_((Component)component);
        comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.YELLOW)));
        player.m_213846_((Component)comp);
    }

    public static void sendErrorMessage(Component component, boolean prefix) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        MutableComponent comp = prefix ? Component.m_237113_((String)"[Colorwheel] ") : Component.m_237119_();
        comp.m_7220_(component);
        comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)));
        player.m_213846_((Component)comp);
    }

    public static void sendEmptyMessage() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        player.m_213846_((Component)Component.m_237119_());
    }
}

