/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.module;

import com.hrznstudio.titanium.annotation.config.ConfigFile;
import com.hrznstudio.titanium.annotation.plugin.FeaturePlugin;
import com.hrznstudio.titanium.api.ISpecialCreativeTabItem;
import com.hrznstudio.titanium.config.AnnotationConfigManager;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.module.DeferredRegistryHelper;
import com.hrznstudio.titanium.plugin.PluginManager;
import com.hrznstudio.titanium.plugin.PluginPhase;
import com.hrznstudio.titanium.tab.TitaniumTab;
import com.hrznstudio.titanium.util.AnnotationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.RegistryObject;

public abstract class ModuleController {
    private final String modid;
    private final AnnotationConfigManager configManager = new AnnotationConfigManager();
    private final PluginManager modPluginManager;
    private final DeferredRegistryHelper deferredRegistryHelper;
    private final List<TitaniumTab> titaniumTabs;

    public ModuleController() {
        this.modid = ModLoadingContext.get().getActiveContainer().getModId();
        this.modPluginManager = new PluginManager(this.modid, FeaturePlugin.FeaturePluginType.MOD, featurePlugin -> ModList.get().isLoaded(featurePlugin.value()), true);
        this.modPluginManager.execute(PluginPhase.CONSTRUCTION);
        this.deferredRegistryHelper = new DeferredRegistryHelper(this.modid);
        this.titaniumTabs = new ArrayList<TitaniumTab>();
        this.onPreInit();
        this.onInit();
        this.onPostInit();
    }

    private void addConfig(AnnotationConfigManager.Type type) {
        for (Class configClass : type.getConfigClass()) {
            if (!this.configManager.isClassManaged(configClass)) continue;
            return;
        }
        this.configManager.add(type);
    }

    public RegistryObject<CreativeModeTab> addCreativeTab(String name, Supplier<ItemStack> icon, String title, TitaniumTab tab) {
        this.titaniumTabs.add(tab);
        return this.getRegistries().registerGeneric(Registries.f_279569_, name, () -> CreativeModeTab.builder().m_257737_(icon).withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256731_}).m_257941_((Component)Component.m_237115_((String)("itemGroup." + title))).m_257652_());
    }

    public void onPreInit() {
        this.modPluginManager.execute(PluginPhase.PRE_INIT);
    }

    public void onInit() {
        this.initModules();
        this.modPluginManager.execute(PluginPhase.INIT);
    }

    public void onPostInit() {
        AnnotationUtil.getFilteredAnnotatedClasses(ConfigFile.class, this.modid).forEach(aClass -> {
            ConfigFile annotation = aClass.getAnnotation(ConfigFile.class);
            this.addConfig(AnnotationConfigManager.Type.of(annotation.type(), aClass).setName(annotation.value()));
        });
        EventManager.mod(ModConfigEvent.Loading.class).process(ev -> {
            this.configManager.inject(ev.getConfig().getSpec());
            this.modPluginManager.execute(PluginPhase.CONFIG_LOAD);
        }).subscribe();
        EventManager.mod(ModConfigEvent.Reloading.class).process(ev -> {
            this.configManager.inject(ev.getConfig().getSpec());
            this.modPluginManager.execute(PluginPhase.CONFIG_RELOAD);
        }).subscribe();
        EventManager.mod(GatherDataEvent.class).process(this::addDataProvider).subscribe();
        EventManager.mod(FMLClientSetupEvent.class).process(fmlClientSetupEvent -> this.modPluginManager.execute(PluginPhase.CLIENT_SETUP)).subscribe();
        EventManager.mod(FMLCommonSetupEvent.class).process(fmlClientSetupEvent -> this.modPluginManager.execute(PluginPhase.COMMON_SETUP)).subscribe();
        EventManager.mod(BuildCreativeModeTabContentsEvent.class).process(buildCreativeModeTabContentsEvent -> {
            for (TitaniumTab titaniumTab : this.titaniumTabs) {
                if (!titaniumTab.getResourceLocation().equals((Object)buildCreativeModeTabContentsEvent.getTabKey().m_135782_())) continue;
                for (Item item : titaniumTab.getTabList()) {
                    if (item instanceof ISpecialCreativeTabItem) {
                        ISpecialCreativeTabItem specialCreativeTabItem = (ISpecialCreativeTabItem)item;
                        specialCreativeTabItem.addToTab((BuildCreativeModeTabContentsEvent)buildCreativeModeTabContentsEvent);
                        continue;
                    }
                    buildCreativeModeTabContentsEvent.m_246326_((ItemLike)item);
                }
            }
        }).subscribe();
        this.modPluginManager.execute(PluginPhase.POST_INIT);
    }

    protected abstract void initModules();

    public void addDataProvider(GatherDataEvent event) {
    }

    public DeferredRegistryHelper getRegistries() {
        return this.deferredRegistryHelper;
    }
}

