/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public record FluidIngredient(Value[] values) {
    public static final FluidIngredient WATER = new FluidIngredient(new Value[]{new TagValue((TagKey<Fluid>)FluidTags.f_13131_)});
    public static final Codec<FluidIngredient> CODEC = Codec.unit((Object)WATER);

    public boolean test(FluidState state) {
        for (Value value : this.values) {
            if (!value.is(state)) continue;
            return true;
        }
        return false;
    }

    public Fluid[] getFluids() {
        return (Fluid[])Arrays.stream(this.values).flatMap(value -> value.getFluids().stream()).distinct().toArray(Fluid[]::new);
    }

    public static FluidIngredient fromJson(@Nullable JsonElement json, boolean canBeEmpty) {
        if (json != null && !json.isJsonNull()) {
            if (json.isJsonObject()) {
                return FluidIngredient.fromValues(Stream.of(FluidIngredient.valueFromJson(json.getAsJsonObject())));
            }
            if (json.isJsonArray()) {
                JsonArray jsonarray = json.getAsJsonArray();
                if (jsonarray.isEmpty() && !canBeEmpty) {
                    throw new JsonSyntaxException("Fluid array cannot be empty, at least one fluid must be defined");
                }
                return FluidIngredient.fromValues(StreamSupport.stream(jsonarray.spliterator(), false).map(it -> FluidIngredient.valueFromJson(GsonHelper.m_13918_((JsonElement)it, (String)"fluid"))));
            }
            throw new JsonSyntaxException("Expected fluid to be object or array of objects");
        }
        throw new JsonSyntaxException("Fluid cannot be null");
    }

    private static FluidIngredient fromValues(Stream<? extends Value> stream) {
        return new FluidIngredient((Value[])stream.toArray(Value[]::new));
    }

    private static Value valueFromJson(JsonObject json) {
        if (json.has("fluid") && json.has("tag")) {
            throw new JsonParseException("A fluid ingredient entry is either a tag or a fluid, not both");
        }
        if (json.has("fluid")) {
            Fluid fluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluid")));
            return new FluidValue(fluid);
        }
        if (json.has("tag")) {
            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag")));
            return new TagValue((TagKey<Fluid>)tag);
        }
        throw new JsonParseException("A fluid ingredient entry needs either a tag or a fluid");
    }

    public static FluidIngredient fromNetwork(FriendlyByteBuf buffer) {
        return FluidIngredient.fromValues(buffer.m_236845_(FriendlyByteBuf::m_130281_).stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257020_).m_7745_(arg_0)).map(FluidValue::new));
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_236828_(Arrays.asList(this.getFluids()), (buf, fluid) -> buf.m_130085_(BuiltInRegistries.f_257020_.m_7981_(fluid)));
    }

    public static interface Value {
        public boolean is(FluidState var1);

        public Collection<Fluid> getFluids();
    }

    public record FluidValue(Fluid fluid) implements Value
    {
        @Override
        public boolean is(FluidState state) {
            return state.m_192917_(this.fluid);
        }

        @Override
        public Collection<Fluid> getFluids() {
            return List.of(this.fluid);
        }
    }

    public record TagValue(TagKey<Fluid> tag) implements Value
    {
        @Override
        public boolean is(FluidState state) {
            return state.m_205070_(this.tag);
        }

        @Override
        public Collection<Fluid> getFluids() {
            ArrayList<Fluid> result = new ArrayList<Fluid>();
            for (Holder holder : BuiltInRegistries.f_257020_.m_206058_(this.tag)) {
                result.add((Fluid)holder.m_203334_());
            }
            return result;
        }
    }
}

