/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.rosemods.windswept.core.registry.WindsweptBlocks;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;

public class FallenLogFeature
extends Feature<SimpleBlockConfiguration> {
    public FallenLogFeature() {
        super(SimpleBlockConfiguration.f_68068_);
    }

    public boolean m_142674_(FeaturePlaceContext<SimpleBlockConfiguration> context) {
        BlockState state;
        BlockPos pos;
        BlockPos origin = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        RandomSource rand = context.m_225041_();
        Direction.Axis axis = rand.m_188499_() ? Direction.Axis.X : Direction.Axis.Z;
        for (int x = -1; x < 1; ++x) {
            block1: for (int z = -1; z < 1; ++z) {
                for (int y = 3; y > -3; --y) {
                    pos = origin.m_7918_(x, y, z);
                    if (!FallenLogFeature.canPlaceOn(level.m_8055_(pos))) continue;
                    origin = pos.m_7494_();
                    continue block1;
                }
            }
        }
        ArrayList logs = Lists.newArrayList();
        int length = rand.m_216339_(5, 8);
        for (int i = 0; i < length && ((state = level.m_8055_(pos = origin.m_5487_(axis, i))).m_247087_() || state.m_60713_((Block)WindsweptBlocks.DRY_MOSS_CARPET.get())) && pos.m_123342_() < level.m_151558_() && FallenLogFeature.canPlaceOn(level.m_8055_(pos.m_7495_())); ++i) {
            logs.add(pos);
        }
        BlockState log = (BlockState)((SimpleBlockConfiguration)context.m_159778_()).f_68069_().m_213972_(rand, origin).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis);
        BlockState carpet = ((Block)WindsweptBlocks.DRY_MOSS_CARPET.get()).m_49966_();
        BlockState sprouts = ((Block)WindsweptBlocks.DRY_MOSSY_SPROUTS.get()).m_49966_();
        BlockState campion = ((Block)WindsweptBlocks.MOSS_CAMPION.get()).m_49966_();
        if (logs.size() >= 4) {
            for (BlockPos pos2 : logs) {
                BlockState below;
                level.m_7731_(pos2, log, 2);
                if (rand.m_188499_() && level.m_8055_(pos2.m_7494_()).m_60795_()) {
                    level.m_7731_(pos2.m_7494_(), rand.m_188503_(5) == 0 ? campion : (rand.m_188503_(2) == 0 ? sprouts : carpet), 2);
                }
                if (!(below = level.m_8055_(pos2.m_7495_())).m_60713_((Block)WindsweptBlocks.GELISOL.get()) && !below.m_60713_(Blocks.f_50440_)) continue;
                level.m_7731_(pos2.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
            }
            return true;
        }
        return false;
    }

    private static boolean canPlaceOn(BlockState state) {
        return state.m_204336_(BlockTags.f_144274_) || state.m_60713_(Blocks.f_50127_);
    }
}

