/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.common.capability.wrappers;

import com.rosemods.windswept.common.item.WoodenBucketItem;
import com.rosemods.windswept.common.item.WoodenMilkBucketItem;
import com.rosemods.windswept.core.other.WindsweptConstants;
import com.rosemods.windswept.core.registry.WindsweptItems;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class WoodenBucketWrapper
implements IFluidHandlerItem,
ICapabilityProvider {
    private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
    private ItemStack container;

    public WoodenBucketWrapper(ItemStack container) {
        this.container = container;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    private FluidStack getFluid() {
        WoodenBucketItem bucket;
        Item item = this.container.m_41720_();
        if (item instanceof WoodenBucketItem && !(bucket = (WoodenBucketItem)item).isEmpty()) {
            return new FluidStack(bucket.getFluid(), 1000);
        }
        if (item instanceof WoodenMilkBucketItem && ForgeMod.MILK.isPresent()) {
            return new FluidStack((Fluid)ForgeMod.MILK.get(), 1000);
        }
        return FluidStack.EMPTY;
    }

    private void setFluid(FluidStack stack) {
        if (stack.isEmpty()) {
            this.container = WoodenBucketItem.getEmpty(this.container, null, null);
        } else {
            Item item = WoodenBucketWrapper.getBucketFromFluid(stack.getFluid());
            if (item != null) {
                this.container = WoodenBucketItem.getFilled(this.container, (ItemLike)item, null);
            }
        }
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return 1000;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
        if (!this.getFluid().isEmpty() || stack.getAmount() < 1000 || !WoodenBucketWrapper.canFillFromFluid(stack.getFluid())) {
            return 0;
        }
        if (action.execute()) {
            this.setFluid(stack);
        }
        return 1000;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.container.m_41613_() != 1 || maxDrain < 1000) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty()) {
            if (action.execute()) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(FluidStack stack, IFluidHandler.FluidAction action) {
        if (this.container.m_41613_() != 1 || stack.getAmount() < 1000) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty() && fluidStack.isFluidEqual(stack)) {
            if (action.execute()) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
        return ForgeCapabilities.FLUID_HANDLER_ITEM.orEmpty(capability, this.holder);
    }

    private static Item getBucketFromFluid(Fluid fluid) {
        if (fluid == Fluids.f_76193_) {
            return (Item)WindsweptItems.WOODEN_WATER_BUCKET.get();
        }
        if (ForgeMod.MILK.isPresent() && fluid == ForgeMod.MILK.get()) {
            return (Item)WindsweptItems.WOODEN_MILK_BUCKET.get();
        }
        if (ModList.get().isLoaded("create")) {
            ResourceLocation location = ForgeRegistries.FLUIDS.getKey((Object)fluid);
            if (location.equals((Object)WindsweptConstants.HONEY)) {
                return (Item)WindsweptItems.WOODEN_HONEY_BUCKET.get();
            }
            if (location.equals((Object)WindsweptConstants.CHOCOLATE)) {
                return (Item)WindsweptItems.WOODEN_CHOCOLATE_BUCKET.get();
            }
        }
        return null;
    }

    private static boolean canFillFromFluid(Fluid fluid) {
        ResourceLocation location;
        if (ModList.get().isLoaded("create") && ((location = ForgeRegistries.FLUIDS.getKey((Object)fluid)).equals((Object)WindsweptConstants.HONEY) || location.equals((Object)WindsweptConstants.CHOCOLATE))) {
            return true;
        }
        return fluid == Fluids.f_76193_ || ForgeMod.MILK.isPresent() && fluid == ForgeMod.MILK.get();
    }
}

