/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.common.block;

import com.rosemods.windswept.core.other.WindsweptConstants;
import com.rosemods.windswept.core.other.tags.WindsweptItemTags;
import com.rosemods.windswept.core.registry.WindsweptEffects;
import com.rosemods.windswept.core.registry.WindsweptItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.ModList;

public class ChristmasPuddingBlock
extends Block {
    public static final EnumProperty<PuddingStates> STATE = EnumProperty.m_61587_((String)"state", PuddingStates.class);
    private static final VoxelShape[] SHAPE_BY_BITES = new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)8.0, (double)8.0, (double)8.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)8.0, (double)8.0, (double)14.0), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)8.0, (double)8.0, (double)14.0), (VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)14.0, (double)8.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0)};

    public ChristmasPuddingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(STATE, (Comparable)((Object)PuddingStates.FOUR)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_BITES[((PuddingStates)((Object)state.m_61143_(STATE))).getIndex()];
    }

    private void takeOneSlice(BlockState state, Player player, Level level, BlockPos pos) {
        switch ((PuddingStates)((Object)state.m_61143_(STATE))) {
            case FOUR: {
                level.m_7731_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)PuddingStates.THREE)), 3);
                break;
            }
            case THREE: {
                level.m_7731_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)PuddingStates.TWO)), 3);
                break;
            }
            case TWO: {
                level.m_7731_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)PuddingStates.ONE)), 3);
                break;
            }
            case ONE: {
                level.m_7471_(pos, false);
                level.m_142346_((Entity)player, GameEvent.f_157794_, pos);
                ChristmasPuddingBlock.m_152435_((Level)level, (BlockPos)pos, (Direction)Direction.UP, (ItemStack)((Item)WindsweptItems.HOLLY_BERRIES.get()).m_7968_());
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack stack = player.m_21120_(hand);
        PuddingStates puddingState = (PuddingStates)((Object)state.m_61143_(STATE));
        if (stack.m_150930_(Items.f_42409_) && puddingState == PuddingStates.FOUR) {
            level.m_7731_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)PuddingStates.FIRE)), 3);
            level.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
            if (!level.f_46443_ && !player.m_150110_().f_35937_) {
                stack.m_220157_(1, level.m_213780_(), (ServerPlayer)player);
            }
            return InteractionResult.SUCCESS;
        }
        if (puddingState != PuddingStates.FIRE && stack.m_204117_(WindsweptItemTags.KNIVES) && ModList.get().isLoaded("windswept_delights")) {
            this.takeOneSlice(state, player, level, pos);
            level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
            ChristmasPuddingBlock.m_152435_((Level)level, (BlockPos)pos, (Direction)Direction.UP, (ItemStack)WindsweptConstants.getItem("windswept_delights", "christmas_pudding_slice").m_7968_());
            return InteractionResult.SUCCESS;
        }
        if (puddingState != PuddingStates.FIRE && player.m_36391_(false)) {
            player.m_36220_(Stats.f_12942_);
            player.m_36324_().m_38707_(2, 0.1f);
            player.m_7292_(new MobEffectInstance((MobEffect)WindsweptEffects.THORNS.get(), 400, 0));
            level.m_142346_((Entity)player, GameEvent.f_157806_, pos);
            this.takeOneSlice(state, player, level, pos);
            return InteractionResult.SUCCESS;
        }
        if (puddingState == PuddingStates.FIRE && stack.m_41619_()) {
            level.m_7731_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)PuddingStates.FOUR)), 3);
            level.m_5594_(player, pos, SoundEvents.f_144098_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return this.m_7898_(state, (LevelReader)level, currentPos) ? state : Blocks.f_50016_.m_49966_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STATE});
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static enum PuddingStates implements StringRepresentable
    {
        FIRE("fire"),
        FOUR("4"),
        THREE("3"),
        TWO("2"),
        ONE("1");

        private final String name;

        private PuddingStates(String name) {
            this.name = name;
        }

        public int getIndex() {
            return this == FIRE ? 3 : Integer.parseInt(this.m_7912_()) - 1;
        }

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

