/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.block;

import io.github.foundationgames.automobility.block.SlopeBlock;
import io.github.foundationgames.automobility.item.SlopePlacementContext;
import io.github.foundationgames.automobility.util.AUtils;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SteepSlopeBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final VoxelShape NORTH_SHAPE;
    public static final VoxelShape SOUTH_SHAPE;
    public static final VoxelShape EAST_SHAPE;
    public static final VoxelShape WEST_SHAPE;
    public static final VoxelShape OLD_NORTH_SHAPE;
    public static final VoxelShape OLD_SOUTH_SHAPE;
    public static final VoxelShape OLD_EAST_SHAPE;
    public static final VoxelShape OLD_WEST_SHAPE;
    public static final BooleanProperty WATERLOGGED;
    protected final boolean old;

    public SteepSlopeBlock(BlockBehaviour.Properties settings, boolean old) {
        super(settings.m_60955_());
        this.old = old;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState;
        if (ctx instanceof SlopePlacementContext) {
            SlopePlacementContext slopeCtx = (SlopePlacementContext)ctx;
            blockState = (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)f_54117_, (Comparable)slopeCtx.getSlopeFacing())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_8055_(ctx.m_8083_()).m_60713_(Blocks.f_49990_)));
        } else {
            blockState = (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_8055_(ctx.m_8083_()).m_60713_(Blocks.f_49990_)));
        }
        return blockState;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (this.old) {
            return switch ((Direction)state.m_61143_((Property)f_54117_)) {
                case Direction.NORTH -> OLD_NORTH_SHAPE;
                case Direction.SOUTH -> OLD_SOUTH_SHAPE;
                case Direction.WEST -> OLD_WEST_SHAPE;
                case Direction.EAST -> OLD_EAST_SHAPE;
                default -> Shapes.m_83040_();
            };
        }
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            default -> Shapes.m_83040_();
        };
    }

    static {
        double oz;
        double ox;
        WATERLOGGED = BlockStateProperties.f_61362_;
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        for (Direction dir : AUtils.HORIZONTAL_DIRS) {
            ox = switch (dir) {
                case Direction.WEST -> 0.5;
                case Direction.EAST -> -0.5;
                default -> 0.0;
            };
            oz = switch (dir) {
                case Direction.NORTH -> 0.5;
                case Direction.SOUTH -> -0.5;
                default -> 0.0;
            };
            VoxelShape finalShape = Shapes.m_83040_();
            for (int j = 1; j < 32; ++j) {
                finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)SlopeBlock.slopeStep(dir, (double)j * 0.5).m_83216_(ox * (double)j / 16.0, 0.0, oz * (double)j / 16.0));
            }
            shapes.add(finalShape);
        }
        NORTH_SHAPE = (VoxelShape)shapes.get(0);
        SOUTH_SHAPE = (VoxelShape)shapes.get(1);
        EAST_SHAPE = (VoxelShape)shapes.get(2);
        WEST_SHAPE = (VoxelShape)shapes.get(3);
        shapes.clear();
        for (Direction dir : AUtils.HORIZONTAL_DIRS) {
            VoxelShape shape;
            ox = switch (dir) {
                case Direction.WEST -> 0.5;
                case Direction.EAST -> -0.5;
                default -> 0.0;
            };
            oz = switch (dir) {
                case Direction.NORTH -> 0.5;
                case Direction.SOUTH -> -0.5;
                default -> 0.0;
            };
            VoxelShape finalShape = shape = (switch (dir) {
                case Direction.NORTH -> Block.m_49796_((double)0.0, (double)-1.5, (double)0.0, (double)16.0, (double)0.5, (double)0.5);
                case Direction.SOUTH -> Block.m_49796_((double)0.0, (double)-1.5, (double)15.5, (double)16.0, (double)0.5, (double)16.0);
                case Direction.EAST -> Block.m_49796_((double)15.5, (double)-1.5, (double)0.0, (double)16.0, (double)0.5, (double)16.0);
                case Direction.WEST -> Block.m_49796_((double)0.0, (double)-1.5, (double)0.0, (double)0.5, (double)0.5, (double)16.0);
                default -> Shapes.m_83040_();
            });
            for (int i = 1; i < 32; ++i) {
                finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)shape.m_83216_(ox * (double)i / 16.0, 0.5 * (double)i / 16.0, oz * (double)i / 16.0));
            }
            shapes.add(finalShape);
        }
        OLD_NORTH_SHAPE = (VoxelShape)shapes.get(0);
        OLD_SOUTH_SHAPE = (VoxelShape)shapes.get(1);
        OLD_EAST_SHAPE = (VoxelShape)shapes.get(2);
        OLD_WEST_SHAPE = (VoxelShape)shapes.get(3);
    }
}

