/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.blocks;

import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.level.entities.happyghast.HappyGhast;
import com.blackgear.vanillabackport.common.registries.ModBlockStateProperties;
import com.blackgear.vanillabackport.common.registries.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DriedGhastBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final int MAX_HYDRATION_LEVEL = 3;
    public static final IntegerProperty HYDRATION_LEVEL = ModBlockStateProperties.HYDRATION_LEVEL;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final int HYDRATION_TICK_DELAY = 5000;
    private static final VoxelShape SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);

    public DriedGhastBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)HYDRATION_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, HYDRATION_LEVEL, WATERLOGGED});
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public int getHydrationLevel(BlockState state) {
        return (Integer)state.m_61143_((Property)HYDRATION_LEVEL);
    }

    private boolean isReadyToSpawn(BlockState state) {
        return this.getHydrationLevel(state) == 3;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            this.tickWaterlogged(state, level, pos, random);
        } else {
            int hydrationLevel = this.getHydrationLevel(state);
            if (hydrationLevel > 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)HYDRATION_LEVEL, (Comparable)Integer.valueOf(hydrationLevel - 1)), 2);
                level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)state));
            }
        }
    }

    private void tickWaterlogged(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.isReadyToSpawn(state)) {
            level.m_5594_(null, pos, ModSoundEvents.DRIED_GHAST_TRANSITION.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)HYDRATION_LEVEL, (Comparable)Integer.valueOf(this.getHydrationLevel(state) + 1)), 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)state));
        } else {
            this.spawnGhastling(level, pos, state);
        }
    }

    private void spawnGhastling(ServerLevel level, BlockPos pos, BlockState state) {
        level.m_7471_(pos, false);
        HappyGhast ghast = (HappyGhast)ModEntities.HAPPY_GHAST.get().m_20615_((Level)level);
        if (ghast != null) {
            Vec3 center = Vec3.m_82539_((Vec3i)pos);
            ghast.m_6863_(true);
            float yRot = DriedGhastBlock.getYRot((Direction)state.m_61143_((Property)f_54117_));
            ghast.m_5616_(yRot);
            ghast.m_20343_(center.m_7096_(), center.m_7098_(), center.m_7094_());
            ghast.m_146922_(yRot);
            ghast.m_146926_(0.0f);
            ghast.m_146867_();
            ghast.m_6034_(ghast.m_20182_().m_7096_(), ghast.m_20182_().m_7098_(), ghast.m_20182_().m_7094_());
            level.m_7967_((Entity)ghast);
            level.m_6269_(null, (Entity)ghast, ModSoundEvents.GHASTLING_SPAWN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static float getYRot(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> 180.0f;
            case Direction.SOUTH -> 0.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> -90.0f;
            default -> throw new IllegalStateException("No y-Rot for vertical axis: " + String.valueOf(direction));
        };
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5;
        if (!((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            if (random.m_188503_(40) == 0) {
                level.m_7785_(x, y, z, ModSoundEvents.DRIED_GHAST_AMBIENT.get(), SoundSource.AMBIENT, 1.0f, 1.0f, false);
            }
            if (random.m_188503_(6) == 0) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.02, 0.0);
            }
        } else {
            if (random.m_188503_(40) == 0) {
                level.m_7785_(x, y, z, ModSoundEvents.DRIED_GHAST_AMBIENT_WATER.get(), SoundSource.AMBIENT, 1.0f, 1.0f, false);
            }
            if (random.m_188503_(6) == 0) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123748_, x + (double)((random.m_188501_() * 2.0f - 1.0f) / 3.0f), y + 0.4, z + (double)((random.m_188501_() * 2.0f - 1.0f) / 3.0f), 0.0, (double)random.m_188501_(), 0.0);
            }
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if ((((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() || (Integer)state.m_61143_((Property)HYDRATION_LEVEL) > 0) && !level.m_183326_().m_183582_(pos, (Object)this)) {
            level.m_186460_(pos, (Block)this, 5000);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState state = context.m_43725_().m_6425_(context.m_8083_());
        boolean isWaterlogged = state.m_205070_(FluidTags.f_13131_) && state.m_76186_() == 8;
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged))).m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() || fluidState.m_76152_() != Fluids.f_76193_) {
            return false;
        }
        if (!level.m_5776_()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)), 3);
            level.m_186469_(pos, fluidState.m_76152_(), fluidState.m_76152_().m_6718_((LevelReader)level));
            level.m_5594_(null, pos, ModSoundEvents.DRIED_GHAST_PLACE_IN_WATER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        level.m_5594_(null, pos, (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? ModSoundEvents.DRIED_GHAST_PLACE_IN_WATER.get() : ModSoundEvents.DRIED_GHAST_PLACE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

