/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.actions;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.customization.action.ActionRegistry;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildActionScreen
extends Screen {
    protected final ActionInstance instance;
    protected Consumer<ActionInstance> callback;
    protected Action originalAction = null;
    protected String originalActionValue = null;
    protected ScrollArea actionsListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ScrollArea actionDescriptionScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedEditBox searchBar;

    public BuildActionScreen(@Nullable ActionInstance instanceToEdit, @NotNull Consumer<ActionInstance> callback) {
        super((Component)(instanceToEdit != null ? Component.m_237115_((String)"fancymenu.editor.action.screens.edit_action") : Component.m_237115_((String)"fancymenu.editor.action.screens.add_action")));
        if (instanceToEdit != null) {
            this.originalAction = instanceToEdit.action;
            this.originalActionValue = instanceToEdit.value;
        }
        this.instance = instanceToEdit != null ? instanceToEdit : new ActionInstance(Action.EMPTY, null);
        this.callback = callback;
    }

    protected void m_7856_() {
        String oldSearchValue = this.searchBar != null ? this.searchBar.m_94155_() : "";
        this.searchBar = new ExtendedEditBox(Minecraft.m_91087_().f_91062_, 21, 66, this.f_96543_ / 2 - 40 - 2, 18, (Component)Component.m_237119_()){

            @Override
            public void m_87963_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
                super.m_87963_(graphics, mouseX, mouseY, partial);
                if (this.m_94155_().isBlank() && !this.m_93696_()) {
                    MutableComponent mutableComponent = Component.m_237115_((String)"fancymenu.actions.build_action.screen.search_action");
                    int n = this.m_252754_() + 4;
                    int n2 = this.m_252907_() + this.m_93694_() / 2;
                    Objects.requireNonNull(this.font);
                    graphics.m_280614_(this.font, (Component)mutableComponent, n, n2 - 9 / 2, UIBase.getUIColorTheme().edit_box_text_color_uneditable.getColorInt(), false);
                }
            }
        };
        this.searchBar.m_94144_(oldSearchValue);
        this.searchBar.m_94151_(s -> this.updateActionsList());
        this.m_142416_((GuiEventListener)this.searchBar);
        UIBase.applyDefaultWidgetSkinTo(this.searchBar);
        this.actionsListScrollArea.setWidth(this.f_96543_ / 2 - 40, true);
        this.actionsListScrollArea.setHeight(this.f_96544_ - 85 - 25, true);
        this.actionsListScrollArea.setX(20, true);
        this.actionsListScrollArea.setY(90, true);
        this.actionDescriptionScrollArea.setWidth(this.f_96543_ / 2 - 40, true);
        this.actionDescriptionScrollArea.setHeight(Math.max(40, this.f_96544_ / 2 - 50 - 25), true);
        this.actionDescriptionScrollArea.setX(this.f_96543_ - 20 - this.actionDescriptionScrollArea.getWidthWithBorder(), true);
        this.actionDescriptionScrollArea.setY(65, true);
        int editValueButtonX = this.f_96543_ - 20 - 150;
        int editValueButtonY = this.f_96544_ - 20 - 20 - 5 - 20 - 15 - 20;
        int cancelButtonX = this.f_96543_ - 20 - 150;
        int cancelButtonY = this.f_96544_ - 20 - 20 - 5 - 20;
        int doneButtonX = this.f_96543_ - 20 - 150;
        int doneButtonY = this.f_96544_ - 20 - 20;
        ExtendedButton editValueButton = new ExtendedButton(editValueButtonX, editValueButtonY, 150, 20, (Component)Component.m_237115_((String)"fancymenu.editor.action.screens.build_screen.edit_value"), button -> {
            if (this.instance.action == Action.EMPTY) {
                return;
            }
            this.originalAction = null;
            this.originalActionValue = null;
            this.instance.action.editValue(this, this.instance);
        }).setIsActiveSupplier(consumes -> this.instance.action != Action.EMPTY && this.instance.action.hasValue()).setTooltipSupplier(consumes -> {
            if (this.instance.action != Action.EMPTY && !this.instance.action.hasValue()) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.action.screens.build_screen.edit_value.desc.no_value", new String[0]));
            }
            return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.action.screens.build_screen.edit_value.desc.normal", new String[0]));
        });
        this.m_142416_((GuiEventListener)editValueButton);
        UIBase.applyDefaultWidgetSkinTo(editValueButton);
        ExtendedButton doneButton = new ExtendedButton(doneButtonX, doneButtonY, 150, 20, (Component)Component.m_237115_((String)"fancymenu.guicomponents.done"), button -> this.callback.accept(this.instance.action != Action.EMPTY ? this.instance : null)).setIsActiveSupplier(consumes -> {
            if (this.instance.action == Action.EMPTY) {
                return false;
            }
            return this.instance.value != null || !this.instance.action.hasValue();
        }).setTooltipSupplier(consumes -> {
            if (this.instance.action == Action.EMPTY) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.action.screens.finish.no_action_selected", new String[0]));
            }
            if (this.instance.value == null && this.instance.action.hasValue()) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.action.screens.build_screen.finish.no_value_set", new String[0]));
            }
            return null;
        });
        this.m_142416_((GuiEventListener)doneButton);
        UIBase.applyDefaultWidgetSkinTo(doneButton);
        ExtendedButton cancelButton = new ExtendedButton(cancelButtonX, cancelButtonY, 150, 20, (Component)Component.m_237115_((String)"fancymenu.guicomponents.cancel"), button -> this.callback.accept(null));
        this.m_142416_((GuiEventListener)cancelButton);
        UIBase.applyDefaultWidgetSkinTo(cancelButton);
        this.updateActionsList();
        this.setDescription(this.instance.action);
    }

    public void m_7379_() {
        this.callback.accept(null);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        MutableComponent titleComp = this.f_96539_.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        graphics.m_280614_(this.f_96547_, (Component)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"fancymenu.editor.action.screens.build_screen.available_actions"), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        MutableComponent descLabel = Component.m_237115_((String)"fancymenu.editor.action.screens.build_screen.action_description");
        int descLabelWidth = this.f_96547_.m_92852_((FormattedText)descLabel);
        graphics.m_280614_(this.f_96547_, (Component)descLabel, this.f_96543_ - 20 - descLabelWidth, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.actionsListScrollArea.render(graphics, mouseX, mouseY, partial);
        this.actionDescriptionScrollArea.render(graphics, mouseX, mouseY, partial);
        super.m_88315_(graphics, mouseX, mouseY, partial);
    }

    protected void setDescription(@Nullable Action action) {
        this.actionDescriptionScrollArea.clearEntries();
        if (action != null && action.getActionDescription() != null) {
            for (Component c : action.getActionDescription()) {
                TextScrollAreaEntry e = new TextScrollAreaEntry(this.actionDescriptionScrollArea, c, entry -> {});
                e.setSelectable(false);
                e.setBackgroundColorHover(e.getBackgroundColorIdle());
                e.setPlayClickSound(false);
                this.actionDescriptionScrollArea.addEntry(e);
            }
        }
    }

    protected boolean actionFitsSearchValue(@NotNull Action action, @Nullable String s) {
        if (s == null || s.isBlank()) {
            return true;
        }
        s = s.toLowerCase();
        if (action.getActionDisplayName().getString().toLowerCase().contains(s)) {
            return true;
        }
        return this.actionDescriptionContains(action, s);
    }

    protected boolean actionDescriptionContains(@NotNull Action action, @NotNull String s) {
        Component[] desc;
        for (Component c : desc = Objects.requireNonNullElse(action.getActionDescription(), new Component[0])) {
            if (!c.getString().toLowerCase().contains(s)) continue;
            return true;
        }
        return false;
    }

    protected void setContentOfActionsList() {
        String searchValue;
        String string = searchValue = this.searchBar != null ? this.searchBar.m_94155_() : "";
        if (searchValue.isBlank()) {
            searchValue = null;
        }
        this.actionsListScrollArea.clearEntries();
        for (Action action : ActionRegistry.getActions()) {
            if (LayoutEditorScreen.getCurrentInstance() != null && !action.shouldShowUpInEditorActionMenu(LayoutEditorScreen.getCurrentInstance()) || !this.actionFitsSearchValue(action, searchValue)) continue;
            ActionScrollEntry e = new ActionScrollEntry(this.actionsListScrollArea, action, entry -> {
                this.instance.action = action;
                this.instance.value = this.originalAction == action ? this.originalActionValue : null;
                this.setDescription(action);
            });
            this.actionsListScrollArea.addEntry(e);
        }
    }

    protected void updateActionsList() {
        this.setContentOfActionsList();
        if (this.instance.action != Action.EMPTY) {
            for (ScrollAreaEntry e : this.actionsListScrollArea.getEntries()) {
                if (!(e instanceof ActionScrollEntry) || ((ActionScrollEntry)e).action != this.instance.action) continue;
                e.setSelected(true);
                break;
            }
        }
    }

    public static class ActionScrollEntry
    extends TextListScrollAreaEntry {
        public Action action;

        public ActionScrollEntry(ScrollArea parent, @NotNull Action action, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, ActionScrollEntry.buildLabel(action), UIBase.getUIColorTheme().listing_dot_color_1.getColor(), onClick);
            this.action = action;
        }

        @NotNull
        private static Component buildLabel(@NotNull Action action) {
            MutableComponent c = action.getActionDisplayName().m_6881_().m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
            if (action.isDeprecated()) {
                c = c.m_130948_(Style.f_131099_.m_178522_(Boolean.valueOf(true)));
                c = c.m_7220_((Component)Component.m_237113_((String)" ").m_6270_(Style.f_131099_.m_178522_(Boolean.valueOf(false))));
                c = c.m_7220_((Component)Component.m_237115_((String)"fancymenu.editor.actions.deprecated").m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().error_text_color.getColorInt()).m_178522_(Boolean.valueOf(false))));
            }
            return c;
        }
    }
}

