/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.anim;

import java.util.Random;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.client.anim.SwingAnimation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class SwayingAnimation
extends SwingAnimation {
    protected float maxSwingAngle = 45.0f;
    protected float minSwingAngle = 2.5f;
    protected float maxPeriod = 25.0f;
    protected float angleDamping = 150.0f;
    protected float periodDamping = 100.0f;
    private int animationCounter = 800 + new Random().nextInt(80);
    private boolean inv = false;

    public SwayingAnimation(Supplier<Vector3f> getRotationAxis) {
        super(getRotationAxis);
    }

    @Override
    public void tick(boolean inWater) {
        ++this.animationCounter;
        double timer = this.animationCounter;
        if (inWater) {
            timer /= 2.0;
        }
        this.prevAngle = this.angle;
        float a = this.minSwingAngle;
        float k = 0.01f;
        if (timer < 800.0) {
            a = (float)Math.max((double)this.maxSwingAngle * Math.exp(-(timer / (double)this.angleDamping)), (double)this.minSwingAngle);
            k = (float)Math.max(Math.PI * 2 * (double)((float)Math.exp(-(timer / (double)this.periodDamping))), (double)0.01f);
        }
        this.angle = a * Mth.m_14089_((float)((float)(timer / (double)this.maxPeriod - (double)k)));
        this.angle *= this.inv ? -1.0f : 1.0f;
    }

    @Override
    public void addImpulse(float vel) {
    }

    @Override
    public void addPositiveImpulse(float vel) {
    }

    @Override
    public float getAngle(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevAngle, (float)this.angle);
    }

    @Override
    public void reset() {
        this.animationCounter = 800;
    }

    @Override
    public boolean hit(Vec3 mot, double eMass) {
        if (mot.m_82553_() > 0.05) {
            Vec3 vec;
            Vec3 norm = new Vec3(mot.f_82479_, 0.0, mot.f_82481_).m_82541_();
            double dot = norm.m_82526_(vec = new Vec3((Vector3f)this.rotationAxis.get()));
            if (dot != 0.0) {
                boolean bl = this.inv = dot < 0.0;
            }
            if (Math.abs(dot) > 0.4) {
                if (this.animationCounter > 10) {
                    this.animationCounter = 0;
                    return true;
                }
                this.animationCounter = 0;
            }
        }
        return false;
    }

    @Override
    public boolean hitByEntity(Entity entity) {
        Vec3 mot = entity.m_20184_();
        return this.hit(mot, 1.0);
    }
}

