/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.items;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.GlazedTerracottaBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockstateCopyItem
extends Item {
    public static Map<Block, Set<Property<?>>> allowedProperties = new HashMap();

    public BlockstateCopyItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        HolderLookup holderLookup = world.m_246945_(Registries.f_256747_);
        if (!world.f_46443_) {
            Player entity = context.m_43723_();
            ItemStack tool = context.m_43722_();
            BlockPos pos = context.m_8083_();
            BlockState existing = world.m_8055_(pos);
            if (entity.m_6144_()) {
                if (this.copyBlockState(tool, existing)) {
                    return InteractionResult.SUCCESS;
                }
            } else {
                BlockState pasteResult = this.pasteTo((HolderLookup<Block>)holderLookup, existing, tool);
                if (pasteResult != null) {
                    world.m_7731_(pos, pasteResult, 18);
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    private BlockState pasteTo(HolderLookup<Block> holderLookup, BlockState state, ItemStack tool) {
        CompoundTag tag = tool.m_41737_("blockstate");
        if (tag != null) {
            BlockState clipboard = NbtUtils.m_247651_(holderLookup, (CompoundTag)tag);
            if (state.m_60734_() == clipboard.m_60734_()) {
                for (Property<?> property : allowedProperties.get(state.m_60734_())) {
                    state = (BlockState)state.m_61124_(property, clipboard.m_61143_(property));
                }
                return state;
            }
        }
        return null;
    }

    private boolean copyBlockState(ItemStack tool, BlockState state) {
        if (allowedProperties.containsKey(state.m_60734_())) {
            CompoundTag nbt = tool.m_41784_();
            nbt.m_128365_("blockstate", (Tag)NbtUtils.m_129202_((BlockState)state));
            tool.m_41751_(nbt);
            return true;
        }
        return false;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            CompoundTag tag = stack.m_41737_("blockstate");
            String blockstatename = "none";
            if (tag != null) {
                blockstatename = NbtUtils.m_247651_((HolderGetter)worldIn.m_246945_(Registries.f_256747_), (CompoundTag)tag).m_60734_().m_7705_();
            }
            tooltip.add((Component)Component.m_237115_((String)"wiki.decorative_blocks.copy1"));
            tooltip.add((Component)Component.m_237110_((String)"wiki.decorative_blocks.copy2", (Object[])new Object[]{blockstatename}));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public static void addProperties(Block block, Property<?> ... properties) {
        allowedProperties.put(block, (Set<Property<?>>)ImmutableSet.copyOf((Object[])properties));
    }

    static {
        BuiltInRegistries.f_256975_.forEach(block -> {
            if (block instanceof FenceBlock || block instanceof IronBarsBlock) {
                BlockstateCopyItem.addProperties(block, new Property[]{CrossCollisionBlock.f_52309_, CrossCollisionBlock.f_52310_, CrossCollisionBlock.f_52311_, CrossCollisionBlock.f_52312_});
            } else if (block instanceof WallBlock) {
                allowedProperties.put((Block)block, (Set<Property<?>>)ImmutableSet.of((Object)WallBlock.f_57949_, (Object)WallBlock.f_57950_, (Object)WallBlock.f_57951_, (Object)WallBlock.f_57952_, (Object)WallBlock.f_57953_));
            } else if (block instanceof StairBlock) {
                allowedProperties.put((Block)block, (Set<Property<?>>)ImmutableSet.of((Object)StairBlock.f_56843_, (Object)StairBlock.f_56841_, (Object)StairBlock.f_56842_));
            } else if (!(block instanceof SlabBlock)) {
                if (block instanceof ComparatorBlock) {
                    allowedProperties.put((Block)block, (Set<Property<?>>)ImmutableSet.of((Object)ComparatorBlock.f_51854_));
                } else if (block.m_49965_().m_61092_().contains(BlockStateProperties.f_61404_)) {
                    allowedProperties.put((Block)block, (Set<Property<?>>)ImmutableSet.of((Object)BlockStateProperties.f_61404_));
                } else if (block instanceof DispenserBlock) {
                    allowedProperties.put((Block)block, (Set<Property<?>>)ImmutableSet.of((Object)DispenserBlock.f_52659_));
                } else if (block instanceof GlazedTerracottaBlock || block instanceof RepeaterBlock) {
                    BlockstateCopyItem.addProperties(block, new Property[]{HorizontalDirectionalBlock.f_54117_});
                } else if (block instanceof HugeMushroomBlock) {
                    allowedProperties.put((Block)block, (Set<Property<?>>)ImmutableSet.of((Object)HugeMushroomBlock.f_54131_, (Object)HugeMushroomBlock.f_54128_, (Object)HugeMushroomBlock.f_54130_, (Object)HugeMushroomBlock.f_54132_, (Object)HugeMushroomBlock.f_54127_, (Object)HugeMushroomBlock.f_54129_, (Object[])new Property[0]));
                } else if (block instanceof ObserverBlock) {
                    allowedProperties.put((Block)block, (Set<Property<?>>)ImmutableSet.of((Object)DirectionalBlock.f_52588_));
                } else if (block.m_49965_().m_61092_().contains(BlockStateProperties.f_61403_)) {
                    BlockstateCopyItem.addProperties(block, new Property[]{BlockStateProperties.f_61403_});
                } else if (block instanceof TrapDoorBlock) {
                    BlockstateCopyItem.addProperties(block, new Property[]{BlockStateProperties.f_61374_, TrapDoorBlock.f_57515_, TrapDoorBlock.f_57514_});
                } else if (block instanceof RotatedPillarBlock) {
                    BlockstateCopyItem.addProperties(block, new Property[]{RotatedPillarBlock.f_55923_});
                } else if (block instanceof RedStoneWireBlock) {
                    BlockstateCopyItem.addProperties(block, new Property[]{RedStoneWireBlock.f_55497_, RedStoneWireBlock.f_55496_, RedStoneWireBlock.f_55498_, RedStoneWireBlock.f_55499_});
                }
            }
        });
    }
}

