/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.societytrading.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.chakyl.societytrading.data.Shop;
import io.github.chakyl.societytrading.network.PacketHandler;
import io.github.chakyl.societytrading.network.ServerBoundOpenShopMenuPacket;
import io.github.chakyl.societytrading.screen.SelectorMenu;
import io.github.chakyl.societytrading.util.ScreenUtils;
import java.util.Collection;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SelectorScreen
extends AbstractContainerScreen<SelectorMenu> {
    private static final ResourceLocation GUI_LOCATION = new ResourceLocation("society_trading", "textures/gui/selector.png");
    private static final int TEXTURE_WIDTH = 512;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int LABEL_Y = 6;
    private static final int NUMBER_OF_SHOP_BUTTONS = 8;
    private static final int SHOP_BUTTON_HEIGHT = 20;
    private static final int SHOP_BUTTON_WIDTH = 153;
    private static final int SCROLLER_HEIGHT = 27;
    private static final int SCROLLER_WIDTH = 6;
    private static final int SCROLL_BAR_HEIGHT = 160;
    private static final int SCROLL_BAR_TOP_POS_Y = 18;
    private static final int SCROLL_BAR_START_X = 162;
    private static final int INDICATOR_ICON_SIZE = 8;
    private static final int INDICATOR_ICONS_START_X = 208;
    private static final Component SHOP_LABEL = Component.m_237115_((String)"gui.society_trading.shop_selector.title");
    private int shopItem;
    private final ShopSelectorButton[] shopSelectorButtons = new ShopSelectorButton[8];
    int scrollOff;
    private boolean isDragging;

    public SelectorScreen(SelectorMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 176;
        this.f_97727_ = 186;
    }

    private void postButtonClick() {
        Collection<Shop> shops = ((SelectorMenu)this.f_97732_).getShops();
        int searchIndex = 0;
        for (Shop shop : shops) {
            if (searchIndex == this.shopItem) {
                PacketHandler.sendToServer(new ServerBoundOpenShopMenuPacket(shop.shopID()));
            }
            ++searchIndex;
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        int k = j + 18;
        for (int l = 0; l < 8; ++l) {
            this.shopSelectorButtons[l] = (ShopSelectorButton)this.m_142416_((GuiEventListener)new ShopSelectorButton(i + 8, k, l, button -> {
                if (button instanceof ShopSelectorButton) {
                    this.shopItem = ((ShopSelectorButton)button).getIndex() + this.scrollOff;
                    this.postButtonClick();
                }
            }));
            k += 20;
        }
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        int centralX = 5 - this.f_96547_.m_92852_((FormattedText)SHOP_LABEL) / 2 + 18;
        pGuiGraphics.m_280614_(this.f_96547_, SHOP_LABEL, centralX, 6, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int k;
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        pGuiGraphics.m_280398_(GUI_LOCATION, i, j, 0, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 256);
        Collection<Shop> shops = ((SelectorMenu)this.f_97732_).getShops();
        if (!(shops == null || shops.isEmpty() || (k = this.shopItem) >= 0 && k < shops.size())) {
            return;
        }
    }

    private void renderScroller(GuiGraphics pGuiGraphics, int pPosX, int pPosY, Collection<Shop> pShops) {
        int i = pShops.size() + 1 - 8;
        if (i > 1) {
            int j = 160 - (27 + (i - 1) * 160 / i);
            int k = j / i + 160 / i;
            int l = 133;
            int i1 = Math.min(l, this.scrollOff * k);
            if (this.scrollOff == i - 1) {
                i1 = l;
            }
            pGuiGraphics.m_280398_(GUI_LOCATION, pPosX + 162, pPosY + 18 + i1, 0, 176.0f, 0.0f, 6, 27, 512, 256);
        } else {
            pGuiGraphics.m_280398_(GUI_LOCATION, pPosX + 162, pPosY + 18, 0, 199.0f, 0.0f, 6, 27, 512, 256);
        }
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        Collection<Shop> shops = ((SelectorMenu)this.f_97732_).getShops();
        if (shops != null && !shops.isEmpty()) {
            int i = (this.f_96543_ - this.f_97726_) / 2;
            int j = (this.f_96544_ - this.f_97727_) / 2;
            int k = j + 4 + 1;
            int l = i + 16;
            this.renderScroller(pGuiGraphics, i, j, shops);
            int i1 = 0;
            for (Shop shop : shops) {
                if (!this.canScroll(shops.size()) || i1 >= this.scrollOff && i1 < 8 + this.scrollOff) {
                    pGuiGraphics.m_280168_().m_85836_();
                    pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
                    int j1 = k + 14;
                    pGuiGraphics.m_280614_(this.f_96547_, (Component)shop.name(), l, j1 + 5, 0xFFFFFF, true);
                    if (!shop.seasonsRequired().isEmpty()) {
                        pGuiGraphics.m_280398_(GUI_LOCATION, l + 153 - 24, j1 + 5, 0, (float)(208 + 8 * ScreenUtils.getSeasonOrder(((SelectorMenu)this.f_97732_).getLevel())), 0.0f, 8, 8, 512, 256);
                    }
                    if (!shop.stageRequired().isEmpty() || !shop.stageOverride().isEmpty()) {
                        pGuiGraphics.m_280398_(GUI_LOCATION, l + 153 - 24, j1 + 5, 0, 240.0f, 0.0f, 8, 8, 512, 256);
                    }
                    pGuiGraphics.m_280168_().m_85849_();
                    k += 20;
                    ++i1;
                    continue;
                }
                ++i1;
            }
            for (ShopSelectorButton button : this.shopSelectorButtons) {
                if (button == null) continue;
                button.f_93624_ = button.index < ((SelectorMenu)this.f_97732_).getShops().size();
            }
            RenderSystem.enableDepthTest();
        }
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
    }

    private boolean canScroll(int pNumOffers) {
        return pNumOffers > 8;
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        int i = ((SelectorMenu)this.f_97732_).getShops().size();
        if (this.canScroll(i)) {
            int j = i - 8;
            this.scrollOff = Mth.m_14045_((int)((int)((double)this.scrollOff - pDelta)), (int)0, (int)j);
        }
        return true;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        int i = ((SelectorMenu)this.f_97732_).getShops().size();
        if (this.isDragging) {
            int j = this.f_97736_ + 18;
            int k = j + 160;
            int l = i - 8;
            float f = ((float)pMouseY - (float)j - 13.5f) / ((float)(k - j) - 27.0f);
            f = f * (float)l + 0.5f;
            this.scrollOff = Mth.m_14045_((int)((int)f), (int)0, (int)l);
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        this.isDragging = false;
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        if (this.canScroll(((SelectorMenu)this.f_97732_).getShops().size()) && pMouseX > (double)(i + 162) && pMouseX < (double)(i + 162 + 6) && pMouseY > (double)(j + 18) && pMouseY <= (double)(j + 18 + 160 + 1)) {
            this.isDragging = true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    @OnlyIn(value=Dist.CLIENT)
    class ShopSelectorButton
    extends Button {
        final int index;

        public ShopSelectorButton(int pX, int pY, int pIndex, Button.OnPress pOnPress) {
            super(pX, pY, 153, 20, CommonComponents.f_237098_, pOnPress, f_252438_);
            this.index = pIndex;
            this.f_93624_ = false;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

