/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.dragonLibLegacy.lang;

import java.util.Locale;
import net.createmod.catnip.lang.LangNumberFormat;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import plus.dragons.createenchantmentindustry.dragonLibLegacy.lang.LangBuilder;

public class Lang {
    private final String modid;

    public Lang(String modid) {
        this.modid = modid;
    }

    public String asId(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    public String enumId(Enum<?> anEnum) {
        return anEnum.name().toLowerCase(Locale.ROOT).replace('$', '/');
    }

    public String nonPluralId(String name) {
        String asId = this.asId(name);
        return asId.endsWith("s") ? asId.substring(0, asId.length() - 1) : asId;
    }

    public LangBuilder builder() {
        return new LangBuilder(this.modid);
    }

    public LangBuilder blockName(BlockState state) {
        return this.builder().add(state.m_60734_().m_49954_());
    }

    public LangBuilder itemName(ItemStack stack) {
        return this.builder().add(stack.m_41786_().m_6881_());
    }

    public LangBuilder fluidName(FluidStack stack) {
        return this.builder().add(stack.getDisplayName().m_6881_());
    }

    public LangBuilder tooltip(Item item, String suffix, Object ... args) {
        return this.builder().add(Component.m_237110_((String)(item.m_5524_() + ".tooltip." + suffix), (Object[])args));
    }

    public LangBuilder tooltip(Block block, String suffix, Object ... args) {
        return this.builder().add(Component.m_237110_((String)(block.m_7705_() + ".tooltip." + suffix), (Object[])args));
    }

    public LangBuilder fromRL(String category, ResourceLocation loc, Object ... args) {
        return this.builder().add(Component.m_237110_((String)Util.m_137492_((String)category, (ResourceLocation)loc), (Object[])args));
    }

    public LangBuilder number(double d) {
        return this.builder().text(LangNumberFormat.format((double)d));
    }

    public LangBuilder translate(String langKey, Object ... args) {
        return this.builder().translate(langKey, args);
    }

    public LangBuilder text(String text) {
        return this.builder().text(text);
    }
}

