/*
 * Decompiled with CFR 0.152.
 */
package org.mesdag.geckojs.item.armor;

import net.minecraft.world.entity.EquipmentSlot;
import org.jetbrains.annotations.Nullable;
import org.mesdag.geckojs.ExtendedGeoModel;
import org.mesdag.geckojs.item.armor.AnimatableArmorBuilder;
import org.mesdag.geckojs.item.armor.AnimatableArmorItem;
import org.mesdag.geckojs.item.armor.IAnimatableArmorRenderer;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class AnimatableArmorRenderer
extends GeoArmorRenderer<AnimatableArmorItem>
implements IAnimatableArmorRenderer {
    private final AnimatableArmorBuilder.BoneVisibilityCallback boneVisibilityCallback;

    public AnimatableArmorRenderer(ExtendedGeoModel<AnimatableArmorItem> model, AnimatableArmorBuilder.BoneVisibilityCallback boneVisibilityCallback) {
        super(model);
        this.scaleWidth = model.builder.scaleWidth;
        this.scaleHeight = model.builder.scaleHeight;
        this.boneVisibilityCallback = boneVisibilityCallback;
        if (model.builder.autoGlowing) {
            this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)this));
        }
    }

    protected void applyBoneVisibilityBySlot(EquipmentSlot currentSlot) {
        if (this.boneVisibilityCallback == null) {
            super.applyBoneVisibilityBySlot(currentSlot);
        } else {
            this.boneVisibilityCallback.apply(this, currentSlot);
        }
    }

    @Override
    public void setBoneVisible(@Nullable GeoBone bone, boolean visible) {
        super.setBoneVisible(bone, visible);
    }
}

