/*
 * Decompiled with CFR 0.152.
 */
package andrews.online_detector.network.server;

import andrews.online_detector.block_entities.AdvancedOnlineDetectorBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageServerSetPlayerHead {
    private final BlockPos pos;
    private final ItemStack stack;

    public MessageServerSetPlayerHead(BlockPos pos, ItemStack stack) {
        this.pos = pos;
        this.stack = stack;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeItemStack(this.stack, false);
    }

    public static MessageServerSetPlayerHead deserialize(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        ItemStack stack = buf.m_130267_();
        return new MessageServerSetPlayerHead(pos, stack);
    }

    public static void handle(MessageServerSetPlayerHead message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        BlockPos blockEntityPos = message.pos;
        ItemStack stack = message.stack;
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> MessageServerSetPlayerHead.lambda$handle$0((Player)player, blockEntityPos, stack, message));
            context.setPacketHandled(true);
        }
    }

    private static /* synthetic */ void lambda$handle$0(Player player, BlockPos blockEntityPos, ItemStack stack, MessageServerSetPlayerHead message) {
        Level level;
        BlockEntity blockEntity;
        if (player != null && (blockEntity = (level = player.m_9236_()).m_7702_(blockEntityPos)) instanceof AdvancedOnlineDetectorBlockEntity) {
            AdvancedOnlineDetectorBlockEntity advancedOnlineDetectorBlockEntity = (AdvancedOnlineDetectorBlockEntity)blockEntity;
            advancedOnlineDetectorBlockEntity.setOwnerHead(stack);
            level.m_7260_(message.pos, level.m_8055_(blockEntityPos), level.m_8055_(blockEntityPos), 2);
        }
    }
}

