/*
 * Decompiled with CFR 0.152.
 */
package andrews.online_detector.block_entities;

import andrews.online_detector.config.ODConfigs;
import andrews.online_detector.objects.blocks.OnlineDetectorBlock;
import andrews.online_detector.registry.ODBlockEntities;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class OnlineDetectorBlockEntity
extends BlockEntity {
    protected UUID ownerID;
    protected String ownerName;
    protected static int updateFrequency;
    protected ItemStack ownerHead = new ItemStack((ItemLike)Items.f_41852_);

    public OnlineDetectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ODBlockEntities.ONLINE_DETECTOR.get(), pos, state);
        updateFrequency = ODConfigs.ODCommonConfig.onlineCheckFrequency.get();
    }

    public OnlineDetectorBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        updateFrequency = ODConfigs.ODCommonConfig.onlineCheckFrequency.get();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, OnlineDetectorBlockEntity blockEntity) {
        if (level.m_46467_() % (long)updateFrequency == 0L && !level.f_46443_) {
            ArrayList<UUID> playerIDs = new ArrayList<UUID>();
            for (Player player : level.m_7654_().m_6846_().m_11314_()) {
                playerIDs.add(player.m_20148_());
            }
            if (playerIDs.contains(blockEntity.getOwnerUUID())) {
                if (!((Boolean)level.m_8055_(pos).m_61143_((Property)OnlineDetectorBlock.IS_ACTIVE)).booleanValue()) {
                    level.m_46597_(pos, (BlockState)level.m_8055_(pos).m_61124_((Property)OnlineDetectorBlock.IS_ACTIVE, (Comparable)Boolean.valueOf(true)));
                }
            } else if (((Boolean)level.m_8055_(pos).m_61143_((Property)OnlineDetectorBlock.IS_ACTIVE)).booleanValue()) {
                level.m_46597_(pos, (BlockState)level.m_8055_(pos).m_61124_((Property)OnlineDetectorBlock.IS_ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag compound = new CompoundTag();
        this.saveToNBT(compound);
        return compound;
    }

    public void handleUpdateTag(CompoundTag compound) {
        this.loadFromNBT(compound);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.loadFromNBT(pkt.m_131708_());
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.saveToNBT(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.loadFromNBT(compound);
    }

    private void saveToNBT(CompoundTag compound) {
        CompoundTag onlineDetectorNBT = new CompoundTag();
        if (this.ownerID != null) {
            onlineDetectorNBT.m_128362_("OwnerID", this.ownerID);
        }
        if (this.ownerName != null) {
            onlineDetectorNBT.m_128359_("OwnerName", this.ownerName);
        }
        if (this.ownerHead != null) {
            onlineDetectorNBT.m_128365_("OwnerHead", (Tag)this.ownerHead.m_41739_(new CompoundTag()));
        }
        compound.m_128365_("OnlineDetectorValues", (Tag)onlineDetectorNBT);
    }

    private void loadFromNBT(CompoundTag compound) {
        CompoundTag onlineDetectorNBT = compound.m_128469_("OnlineDetectorValues");
        if (onlineDetectorNBT.m_128441_("OwnerID")) {
            this.ownerID = onlineDetectorNBT.m_128342_("OwnerID");
        }
        if (onlineDetectorNBT.m_128425_("OwnerName", 8)) {
            this.ownerName = onlineDetectorNBT.m_128461_("OwnerName");
        }
        if (onlineDetectorNBT.m_128441_("OwnerHead")) {
            this.ownerHead = ItemStack.m_41712_((CompoundTag)onlineDetectorNBT.m_128469_("OwnerHead"));
        }
    }

    public UUID getOwnerUUID() {
        return this.ownerID;
    }

    public void setOwnerUUID(UUID uuid) {
        this.ownerID = uuid;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String name) {
        this.ownerName = name;
    }

    public ItemStack getOwnerHead() {
        return this.ownerHead;
    }

    public void setOwnerHead(ItemStack stack) {
        this.ownerHead = stack;
    }
}

