/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.network;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.affix.IAffix;
import top.theillusivec4.champions.api.data.AffixSetting;

public record SPacketSyncAffixSetting(Map<ResourceLocation, AffixSetting> map) {
    private static final Codec<Map<ResourceLocation, AffixSetting>> MAPPER = Codec.unboundedMap((Codec)ResourceLocation.f_135803_, AffixSetting.CODEC);

    public static SPacketSyncAffixSetting decode(FriendlyByteBuf buf) {
        return new SPacketSyncAffixSetting(MAPPER.parse((DynamicOps)NbtOps.f_128958_, (Object)buf.m_130260_()).result().orElse(new HashMap()));
    }

    public static void handelSettingMainThread() {
        Champions.API.getAffixDataLoader().getLoadedData().forEach((resourceLocation, affixSetting) -> Champions.API.getAffix(affixSetting.type()).ifPresent(affix -> {
            affix.applySetting((AffixSetting)affixSetting);
            Champions.API.addCategory(affix.getCategory(), (IAffix)affix);
        }));
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130079_(MAPPER.encodeStart((DynamicOps)NbtOps.f_128958_, this.map).result().orElse(new CompoundTag()));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> Champions.API.getAffixDataLoader().cache(this.map));
        }
        ctx.get().enqueueWork(SPacketSyncAffixSetting::handelSettingMainThread);
        ctx.get().setPacketHandled(true);
    }
}

