/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.affix.IAffix;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.loot.AffixesPredicate;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.registry.ModLootItemConditions;

public record LootItemChampionPropertyCondition(LootContext.EntityTarget target, MinMaxBounds.Ints tier, AffixesPredicate affixes) implements LootItemCondition
{
    @Nonnull
    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)this.target.m_79003_());
    }

    public boolean test(LootContext context) {
        Entity entity = (Entity)context.m_78953_(this.target.m_79003_());
        return entity != null && this.isChampionAndMatches(entity);
    }

    public boolean isChampionAndMatches(Entity entity) {
        return ChampionCapability.getCapability(entity).map(champion -> {
            IChampion.Server server = champion.getServer();
            int tier = server.getRank().map(Rank::getTier).orElse(0);
            if (tier <= 0 || !this.tier.m_55390_(tier)) {
                return false;
            }
            List<IAffix> affixes = server.getAffixes();
            return this.affixes.matches(affixes);
        }).orElse(false);
    }

    @Nonnull
    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)ModLootItemConditions.CHAMPION_PROPERTIES.get();
    }

    public static class ChampionConditionSerializer
    implements Serializer<LootItemChampionPropertyCondition> {
        public void serialize(JsonObject json, LootItemChampionPropertyCondition value, JsonSerializationContext context) {
            json.add("tier", value.tier.m_55328_());
            json.add("affixes", value.affixes.serializeToJson());
            json.add("entity", context.serialize((Object)value.target));
        }

        @Nonnull
        public LootItemChampionPropertyCondition deserialize(JsonObject json, @Nonnull JsonDeserializationContext context) {
            MinMaxBounds.Ints tier = MinMaxBounds.Ints.m_55373_((JsonElement)json.get("tier"));
            AffixesPredicate affixes = AffixesPredicate.fromJson(json.get("affixes"));
            return new LootItemChampionPropertyCondition((LootContext.EntityTarget)GsonHelper.m_13836_((JsonObject)json, (String)"entity", (JsonDeserializationContext)context, LootContext.EntityTarget.class), tier, affixes);
        }
    }
}

