/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.integration.gamestages;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.common.config.ChampionsConfig;

public class GameStagesPlugin {
    private static final Map<String, StageInfo> ENTITY_STAGE_INFO = new HashMap<String, StageInfo>();
    private static final Map<Integer, StageInfo> TIER_STAGE_INFO = new HashMap<Integer, StageInfo>();

    public static void buildStages() {
        ENTITY_STAGE_INFO.clear();
        TIER_STAGE_INFO.clear();
        List<? extends String> entityStages = ChampionsConfig.entityStages;
        for (String string : entityStages) {
            String[] stringArray = string.split(";");
            if (stringArray.length < 2 || stringArray.length > 3) {
                Champions.LOGGER.error("Malformed entity stage {}, skipping...", (Object)string);
            }
            String stage = stringArray[0];
            String entity = stringArray[1];
            if (stringArray.length == 2) {
                GameStagesPlugin.addEntityStage(entity, stage);
                continue;
            }
            GameStagesPlugin.addEntityStage(entity, stage, stringArray[2]);
        }
        List<? extends String> tierStages = ChampionsConfig.tierStages;
        for (String string : tierStages) {
            String[] split = string.split(";");
            if (split.length < 2 || split.length > 3) {
                Champions.LOGGER.error("Malformed tier stage {}, skipping...", (Object)string);
            }
            String stage = split[0];
            int tier = 0;
            try {
                tier = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException e) {
                Champions.LOGGER.error("{} is not a valid tier, needs to be an integer", (Object)split[1]);
            }
            if (tier <= 0) continue;
            if (split.length == 2) {
                GameStagesPlugin.addTierStage(tier, stage);
                continue;
            }
            GameStagesPlugin.addTierStage(tier, stage, split[2]);
        }
    }

    public static void addEntityStage(String entity, String stage) {
        ENTITY_STAGE_INFO.merge(entity, new StageInfo(stage), (k, v) -> {
            v.addStage(stage);
            return v;
        });
    }

    public static void addEntityStage(String entity, String stage, String dimension) {
        ENTITY_STAGE_INFO.merge(entity, new StageInfo(stage, dimension), (k, v) -> {
            v.addStage(stage, dimension);
            return v;
        });
    }

    public static void addTierStage(int tier, String stage) {
        TIER_STAGE_INFO.merge(tier, new StageInfo(stage), (k, v) -> {
            v.addStage(stage);
            return v;
        });
    }

    public static void addTierStage(int tier, String stage, String dimension) {
        TIER_STAGE_INFO.merge(tier, new StageInfo(stage, dimension), (k, v) -> {
            v.addStage(stage);
            return v;
        });
    }

    private static Optional<StageInfo> getStageInfo(String entity) {
        return Optional.ofNullable(ENTITY_STAGE_INFO.get(entity));
    }

    private static Optional<StageInfo> getStageInfo(int tier) {
        return Optional.ofNullable(TIER_STAGE_INFO.get(tier));
    }

    public static boolean hasEntityStage(LivingEntity living) {
        ResourceLocation rl = ForgeRegistries.ENTITY_TYPES.getKey((Object)living.m_6095_());
        if (rl != null) {
            String id = rl.toString();
            return GameStagesPlugin.getStageInfo(id).map(info -> GameStagesPlugin.hasRequiredStages(info, living)).orElse(true);
        }
        return true;
    }

    public static boolean hasTierStage(int tier, LivingEntity livingEntity) {
        return GameStagesPlugin.getStageInfo(tier).map(info -> GameStagesPlugin.hasRequiredStages(info, livingEntity)).orElse(true);
    }

    private static boolean hasRequiredStages(@Nonnull StageInfo info, @Nonnull LivingEntity living) {
        String dimension = living.m_9236_().m_46472_().m_135782_().toString();
        Set<String> stages = info.dimensionalStages.containsKey(dimension) ? info.dimensionalStages.get(dimension) : info.globalStages;
        if (stages.isEmpty()) {
            return true;
        }
        Level level = living.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return !serverLevel.m_8795_(player -> GameStageHelper.hasAllOf((Player)player, (Collection)stages) && player.m_20270_((Entity)living) <= 256.0f).isEmpty();
        }
        return false;
    }

    public static class StageInfo {
        Map<String, Set<String>> dimensionalStages = new HashMap<String, Set<String>>();
        Set<String> globalStages = new HashSet<String>();

        StageInfo(String stage) {
            this.addStage(stage);
        }

        StageInfo(String stage, String dimension) {
            this.addStage(stage, dimension);
        }

        void addStage(String stage) {
            this.globalStages.add(stage);
        }

        void addStage(String stage, String dimension) {
            this.dimensionalStages.merge(dimension, new HashSet<String>(Collections.singleton(stage)), (k, v) -> {
                v.add(stage);
                return v;
            });
        }
    }
}

