/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog.network.packet.server;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.data.ExposureLook;
import io.github.mortuusars.exposure.data.ExposureSize;
import io.github.mortuusars.exposure_catalog.ExposureCatalog;
import io.github.mortuusars.exposure_catalog.network.PacketDirection;
import io.github.mortuusars.exposure_catalog.network.Packets;
import io.github.mortuusars.exposure_catalog.network.handler.ServerPacketsHandler;
import io.github.mortuusars.exposure_catalog.network.packet.IPacket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public record ExportExposuresC2SP(List<String> exposureIds, int partIndex, boolean isLastPart, ExposureSize size, ExposureLook look) implements IPacket
{
    public static final ResourceLocation ID = ExposureCatalog.resource("export_exposures");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public FriendlyByteBuf toBuffer(FriendlyByteBuf buffer) {
        buffer.writeInt(this.exposureIds.size());
        for (String exposureId : this.exposureIds) {
            buffer.m_130070_(exposureId);
        }
        buffer.writeInt(this.partIndex);
        buffer.writeBoolean(this.isLastPart);
        buffer.m_130070_(this.size.m_7912_());
        buffer.m_130070_(this.look.m_7912_());
        return buffer;
    }

    public static ExportExposuresC2SP fromBuffer(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            list.add(buffer.m_130277_());
        }
        return new ExportExposuresC2SP(list, buffer.readInt(), buffer.readBoolean(), ExposureSize.byName((String)buffer.m_130277_()), ExposureLook.byName((String)buffer.m_130277_()));
    }

    public static void sendSplitted(List<String> exposureIds, ExposureSize size, ExposureLook look) {
        int bytes = 0;
        int partIndex = 0;
        ArrayList<String> part = new ArrayList<String>();
        for (String exposureId : exposureIds) {
            if (bytes >= 30000) {
                Packets.sendToServer(new ExportExposuresC2SP(part, partIndex, false, size, look));
                bytes = 0;
                ++partIndex;
                part = new ArrayList();
            }
            part.add(exposureId);
            bytes += exposureId.getBytes(StandardCharsets.UTF_8).length;
        }
        Packets.sendToServer(new ExportExposuresC2SP(part, partIndex, true, size, look));
    }

    @Override
    public boolean handle(PacketDirection direction, @Nullable Player player) {
        Preconditions.checkArgument((boolean)(player instanceof ServerPlayer), (Object)("Player is required for " + ID + " packet"));
        if (!player.m_20310_(3)) {
            return true;
        }
        ServerPacketsHandler.handleExport((ServerPlayer)player, this);
        return true;
    }
}

