/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog.gui.screen;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.data.ExposureLook;
import io.github.mortuusars.exposure.data.ExposureSize;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.render.image.ExposureDataImage;
import io.github.mortuusars.exposure.render.image.IImage;
import io.github.mortuusars.exposure.render.image.RenderedImageProvider;
import io.github.mortuusars.exposure.render.image.TextureImage;
import io.github.mortuusars.exposure.render.modifiers.ExposurePixelModifiers;
import io.github.mortuusars.exposure.util.ItemAndStack;
import io.github.mortuusars.exposure_catalog.ExposureCatalog;
import io.github.mortuusars.exposure_catalog.data.ExposureInfo;
import io.github.mortuusars.exposure_catalog.data.ThumbnailRenderedImageProvider;
import io.github.mortuusars.exposure_catalog.data.client.CatalogClient;
import io.github.mortuusars.exposure_catalog.gui.Mode;
import io.github.mortuusars.exposure_catalog.gui.Order;
import io.github.mortuusars.exposure_catalog.gui.Sorting;
import io.github.mortuusars.exposure_catalog.gui.screen.CatalogPhotographScreen;
import io.github.mortuusars.exposure_catalog.gui.screen.ConfirmScreen;
import io.github.mortuusars.exposure_catalog.gui.screen.SelectionHandler;
import io.github.mortuusars.exposure_catalog.gui.screen.tooltip.BelowOrAboveAreaTooltipPositioner;
import io.github.mortuusars.exposure_catalog.gui.screen.widget.EnumButton;
import io.github.mortuusars.exposure_catalog.network.Packets;
import io.github.mortuusars.exposure_catalog.network.packet.server.CatalogClosedC2SP;
import io.github.mortuusars.exposure_catalog.network.packet.server.DeleteExposureC2SP;
import io.github.mortuusars.exposure_catalog.network.packet.server.ExportExposuresC2SP;
import io.github.mortuusars.exposure_catalog.network.packet.server.QueryExposuresC2SP;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.searchtree.PlainTextSearchTree;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CatalogScreen
extends Screen {
    public static final ResourceLocation TEXTURE = ExposureCatalog.resource("textures/gui/catalog.png");
    public static final int TEX_SIZE = 512;
    public static final int ROWS = 4;
    public static final int COLS = 6;
    protected static final int SCROLL_THUMB_TOP_HEIGHT = 3;
    protected static final int SCROLL_THUMB_MID_HEIGHT = 4;
    protected static final int SCROLL_THUMB_BOT_HEIGHT = 2;
    public static final int REFRESH_COOLDOWN_MS = 500;
    public static final int RELOAD_COOLDOWN_MS = 5000;
    protected final File stateFile;
    protected int imageWidth;
    protected int imageHeight;
    protected int leftPos;
    protected int topPos;
    protected Rect2i windowArea;
    protected Rect2i scrollBarArea;
    protected Rect2i searchBarArea;
    protected Rect2i thumbnailsArea;
    protected EnumButton<Order> orderButton;
    protected EnumButton<Sorting> sortingButton;
    protected EditBox searchBox;
    protected EnumButton<Mode> modeButton;
    protected Rect2i scrollThumb;
    protected List<Thumbnail> thumbnails;
    protected Button refreshButton;
    protected Button exportButton;
    protected Button deleteButton;
    protected Mode mode;
    protected Order order;
    protected Sorting sorting;
    protected ExposureSize exportSize;
    protected ExposureLook exportLook;
    protected boolean isLoading;
    protected boolean haveExposures;
    protected List<String> exposures;
    protected List<String> textures;
    protected ArrayList<String> filteredItems;
    protected SelectionHandler selection;
    protected int totalRows;
    protected int topRowIndex;
    protected boolean isThumbnailsGridFocused;
    protected int focusedThumbnailIndex;
    protected boolean isDraggingScrollbar;
    protected int topRowIndexAtDragStart;
    protected double dragDelta;
    protected boolean initialized;
    protected long refreshCooldownExpireTime;
    protected long lastScrolledTime;

    public CatalogScreen() {
        super((Component)Component.m_237115_((String)"gui.exposure_catalog.catalog"));
        this.stateFile = new File(Minecraft.m_91087_().f_91069_, "exposure_catalog_state.json");
        this.windowArea = new Rect2i(0, 0, 361, 265);
        this.scrollBarArea = new Rect2i(343, 22, 10, 221);
        this.searchBarArea = new Rect2i(219, 7, 118, 10);
        this.thumbnailsArea = new Rect2i(8, 22, 329, 221);
        this.scrollThumb = new Rect2i(0, 0, 0, 0);
        this.thumbnails = Collections.synchronizedList(new ArrayList());
        this.mode = Mode.EXPOSURES;
        this.order = Order.ASCENDING;
        this.sorting = Sorting.DATE;
        this.exportSize = ExposureSize.X1;
        this.exportLook = ExposureLook.REGULAR;
        this.haveExposures = true;
        this.exposures = new ArrayList<String>();
        this.textures = Collections.emptyList();
        this.filteredItems = new ArrayList();
        this.selection = new SelectionHandler();
        this.totalRows = 0;
        this.topRowIndex = 0;
        this.isDraggingScrollbar = false;
        this.topRowIndexAtDragStart = 0;
        this.dragDelta = 0.0;
        this.refreshCooldownExpireTime = 0L;
        this.lastScrolledTime = 0L;
    }

    public void onExposuresReceived(Map<String, ExposureInfo> exposuresList) {
        this.isLoading = false;
        this.haveExposures = !exposuresList.isEmpty();
        this.exposures = new ArrayList<String>(exposuresList.keySet().stream().toList());
        this.orderAndSortExposuresList(this.order, this.sorting);
        if (this.mode == Mode.EXPOSURES) {
            this.topRowIndex = 0;
            this.refreshSearchResults();
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.imageWidth = this.windowArea.m_110090_();
        this.imageHeight = this.windowArea.m_110091_();
        this.leftPos = this.f_96543_ / 2 - this.imageWidth / 2;
        this.topPos = this.f_96544_ / 2 - this.imageHeight / 2;
        this.scrollBarArea = new Rect2i(this.leftPos + 343, this.topPos + 22, 10, 221);
        this.searchBarArea = new Rect2i(this.leftPos + 219, this.topPos + 7, 118, 10);
        this.thumbnailsArea = new Rect2i(this.leftPos + 8, this.topPos + 22, 329, 221);
        this.orderButton = new EnumButton<Order>(Order.class, this.leftPos + 188, this.topPos + 6, 12, 12, 425, 0, 12, 12, TEXTURE, 512, 512, (b, prev, current) -> this.changeOrder((Order)current), (Component)Component.m_237115_((String)"gui.exposure_catalog.catalog.order")){

            public void m_7435_(SoundManager handler) {
                CatalogScreen.this.playClickSound();
            }
        };
        this.orderButton.setTooltipFunc((Function<Order, Tooltip>)((Function)value -> {
            MutableComponent component = Component.m_237115_((String)"gui.exposure_catalog.catalog.order");
            for (Order v : Order.values()) {
                component.m_130946_("\n ");
                component.m_7220_((Component)Component.m_237115_((String)("gui.exposure_catalog.catalog.order." + v.m_7912_())).m_130948_(Style.f_131099_.m_178520_(value == v ? 0x6677FF : 0x444444)));
            }
            return Tooltip.m_257550_((Component)component);
        }));
        this.m_142416_((GuiEventListener)this.orderButton);
        this.sortingButton = new EnumButton<Sorting>(Sorting.class, this.leftPos + 203, this.topPos + 6, 12, 12, 425, 36, 12, 12, TEXTURE, 512, 512, (b, prev, current) -> this.changeSorting((Sorting)current), (Component)Component.m_237115_((String)"gui.exposure_catalog.catalog.sorting")){

            public void m_7435_(SoundManager handler) {
                CatalogScreen.this.playClickSound();
            }
        };
        this.sortingButton.setTooltipFunc((Function<Sorting, Tooltip>)((Function)value -> {
            MutableComponent component = Component.m_237115_((String)"gui.exposure_catalog.catalog.sorting");
            for (Sorting v : Sorting.values()) {
                component.m_130946_("\n ");
                component.m_7220_((Component)Component.m_237115_((String)("gui.exposure_catalog.catalog.sorting." + v.m_7912_())).m_130948_(Style.f_131099_.m_178520_(value == v ? 0x6677FF : 0x444444)));
            }
            return Tooltip.m_257550_((Component)component);
        }));
        this.m_142416_((GuiEventListener)this.sortingButton);
        int n = this.searchBarArea.m_110085_() + 1;
        int n2 = this.searchBarArea.m_110086_() + 1;
        int n3 = this.searchBarArea.m_110090_();
        Objects.requireNonNull(this.f_96547_);
        this.searchBox = new EditBox(this.f_96547_, n, n2, n3, 9, (Component)Component.m_237115_((String)"itemGroup.search"));
        this.searchBox.m_94199_(99);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94194_(true);
        this.searchBox.m_94202_(0xFFFFFF);
        this.m_142416_((GuiEventListener)this.searchBox);
        this.modeButton = new EnumButton<Mode>(Mode.class, this.leftPos + 342, this.topPos + 6, 12, 12, 449, 0, 12, 12, TEXTURE, 512, 512, (b, prev, current) -> this.changeMode((Mode)current), (Component)Component.m_237115_((String)"gui.exposure_catalog.catalog.mode")){

            public void m_7435_(SoundManager handler) {
                CatalogScreen.this.playClickSound();
            }
        };
        this.modeButton.setTooltipFunc((Function<Mode, Tooltip>)((Function)value -> {
            MutableComponent component = Component.m_237115_((String)"gui.exposure_catalog.catalog.mode").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"gui.exposure_catalog.catalog.mode.hotkey"));
            for (Mode v : Mode.values()) {
                component.m_130946_("\n ");
                component.m_7220_((Component)Component.m_237115_((String)("gui.exposure_catalog.catalog.mode." + v.m_7912_())).m_130948_(Style.f_131099_.m_178520_(value == v ? 0x6677FF : 0x444444)));
            }
            return Tooltip.m_257550_((Component)component);
        }));
        this.m_142416_((GuiEventListener)this.modeButton);
        this.refreshButton = new ImageButton(this.leftPos + 7, this.topPos + 247, 12, 12, 449, 36, 12, TEXTURE, 512, 512, b -> this.refresh());
        this.refreshButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.exposure_catalog.catalog.refresh").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"gui.exposure_catalog.catalog.refresh.hotkey")).m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"gui.exposure_catalog.catalog.refresh.tooltip"))));
        this.m_142416_((GuiEventListener)this.refreshButton);
        this.exportButton = new ImageButton(this.leftPos + 26, this.topPos + 247, 12, 12, 473, 36, 12, TEXTURE, 512, 512, b -> this.exportExposures()){

            public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                if (this.m_198029_()) {
                    this.m_257544_(Tooltip.m_257550_((Component)CatalogScreen.this.createExportButtonTooltip()));
                }
                super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (!(this.m_198029_() && this.f_93623_ && this.f_93624_)) {
                    return super.m_6375_(mouseX, mouseY, button);
                }
                if (Screen.m_96637_()) {
                    CatalogScreen.this.exportSize = ExposureSize.values()[(CatalogScreen.this.exportSize.ordinal() + 1) % ExposureSize.values().length];
                    CatalogScreen.this.playClickSound();
                    return true;
                }
                if (Screen.m_96638_()) {
                    CatalogScreen.this.exportLook = ExposureLook.values()[(CatalogScreen.this.exportLook.ordinal() + 1) % ExposureLook.values().length];
                    CatalogScreen.this.playClickSound();
                    return true;
                }
                return super.m_6375_(mouseX, mouseY, button);
            }

            public boolean m_6050_(double mouseX, double mouseY, double delta) {
                if (!(this.m_198029_() && this.f_93623_ && this.f_93624_)) {
                    return super.m_6050_(mouseX, mouseY, delta);
                }
                if (Screen.m_96637_()) {
                    int newValue = CatalogScreen.this.exportSize.ordinal() - (int)delta;
                    if (newValue < 0) {
                        newValue = ExposureSize.values().length - 1;
                    } else if (newValue >= ExposureSize.values().length) {
                        newValue = 0;
                    }
                    if (CatalogScreen.this.exportSize != ExposureSize.values()[newValue]) {
                        CatalogScreen.this.playClickSound();
                        CatalogScreen.this.exportSize = ExposureSize.values()[newValue];
                    }
                    return true;
                }
                if (Screen.m_96638_()) {
                    int newValue = CatalogScreen.this.exportLook.ordinal() - (int)delta;
                    if (newValue < 0) {
                        newValue = ExposureLook.values().length - 1;
                    } else if (newValue >= ExposureLook.values().length) {
                        newValue = 0;
                    }
                    if (CatalogScreen.this.exportLook != ExposureLook.values()[newValue]) {
                        CatalogScreen.this.playClickSound();
                        CatalogScreen.this.exportLook = ExposureLook.values()[newValue];
                    }
                    return true;
                }
                return super.m_6050_(mouseX, mouseY, delta);
            }

            public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
                if (!(this.m_198029_() && this.f_93623_ && this.f_93624_)) {
                    return super.m_7933_(keyCode, scanCode, modifiers);
                }
                if (CommonInputs.m_278691_((int)keyCode) && Screen.m_96637_()) {
                    CatalogScreen.this.exportSize = ExposureSize.values()[(CatalogScreen.this.exportSize.ordinal() + 1) % ExposureSize.values().length];
                    CatalogScreen.this.playClickSound();
                    return true;
                }
                if (CommonInputs.m_278691_((int)keyCode) && Screen.m_96638_()) {
                    CatalogScreen.this.exportLook = ExposureLook.values()[(CatalogScreen.this.exportLook.ordinal() + 1) % ExposureLook.values().length];
                    CatalogScreen.this.playClickSound();
                    return true;
                }
                return super.m_7933_(keyCode, scanCode, modifiers);
            }
        };
        this.exportButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.exposure_catalog.catalog.export")));
        this.m_142416_((GuiEventListener)this.exportButton);
        this.deleteButton = new ImageButton(this.leftPos + 342, this.topPos + 247, 12, 12, 473, 0, 12, TEXTURE, 512, 512, b -> this.deleteExposures());
        this.deleteButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.exposure_catalog.catalog.delete").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"gui.exposure_catalog.catalog.delete.hotkey")).m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"gui.exposure_catalog.catalog.delete.tooltip"))));
        this.m_142416_((GuiEventListener)this.deleteButton);
        if (!this.initialized) {
            this.loadState();
            ExposureClient.getExposureStorage().clear();
            Packets.sendToServer(new QueryExposuresC2SP(false));
            this.isLoading = true;
            if (this.mode == Mode.TEXTURES) {
                this.refresh();
            }
            this.initialized = true;
        }
        this.updateElements();
    }

    protected void playClickSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)Exposure.SoundEvents.CAMERA_DIAL_CLICK.get()), (float)1.0f, (float)0.8f));
    }

    protected Component createExportButtonTooltip() {
        MutableComponent tooltip = Component.m_237115_((String)("gui.exposure_catalog.catalog.export." + (this.selection.isEmpty() || this.selection.size() == this.exposures.size() ? "all" : "selected"))).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"gui.exposure_catalog.catalog.export.hotkey"));
        tooltip.m_130946_("\n");
        tooltip.m_7220_((Component)Component.m_237115_((String)"gui.exposure_catalog.catalog.export.location_info"));
        tooltip.m_130946_("\n").m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"gui.exposure_catalog.catalog.export.size"));
        for (ExposureSize exposureSize : ExposureSize.values()) {
            tooltip.m_130946_("\n");
            tooltip.m_7220_((Component)Component.m_237115_((String)("gui.exposure_catalog.catalog.export.size." + exposureSize.m_7912_())).m_130948_(Style.f_131099_.m_178520_(this.exportSize == exposureSize ? 0x6677FF : 0x444444)));
        }
        tooltip.m_130946_("\n").m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"gui.exposure_catalog.catalog.export.look"));
        for (ExposureSize exposureSize : ExposureLook.values()) {
            tooltip.m_130946_("\n").m_7220_((Component)Component.m_237115_((String)("gui.exposure_catalog.catalog.export.look." + exposureSize.m_7912_())).m_130948_(Style.f_131099_.m_178520_(this.exportLook == exposureSize ? 0x6677FF : 0x444444)));
        }
        tooltip.m_130946_("\n").m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"gui.exposure_catalog.catalog.export.control_info"));
        return tooltip;
    }

    protected boolean canRefresh() {
        if (this.mode == Mode.TEXTURES) {
            return true;
        }
        if (this.mode == Mode.EXPOSURES && this.isLoading) {
            return false;
        }
        return Util.m_137550_() >= this.refreshCooldownExpireTime;
    }

    protected void refresh() {
        if (!this.canRefresh()) {
            return;
        }
        if (this.mode == Mode.EXPOSURES) {
            ExposureClient.getExposureStorage().clear();
            boolean reload = Screen.m_96638_();
            Packets.sendToServer(new QueryExposuresC2SP(reload));
            if (reload) {
                this.isLoading = true;
                CatalogClient.clear();
            }
            this.refreshCooldownExpireTime = Util.m_137550_() + (long)(reload ? 5000 : 500);
        } else if (this.mode == Mode.TEXTURES) {
            Map resources = Minecraft.m_91087_().m_91098_().m_214159_("textures", rl -> true);
            this.textures = resources.keySet().stream().map(ResourceLocation::toString).collect(Collectors.toCollection(ArrayList::new));
            this.orderTexturesList(this.order);
            this.refreshSearchResults();
            this.updateElements();
        }
    }

    protected void exportExposures() {
        ArrayList<String> exposureIds;
        if (this.mode == Mode.TEXTURES) {
            return;
        }
        List<String> list = exposureIds = !this.selection.isEmpty() ? this.selection.get().stream().map(i -> this.filteredItems.get((int)i)).toList() : this.filteredItems;
        if (exposureIds.size() > 100) {
            MutableComponent message = Component.m_237110_((String)"gui.exposure_catalog.catalog.confirm.message.export_all", (Object[])new Object[]{exposureIds.size()});
            ConfirmScreen confirmScreen = new ConfirmScreen(this, (Component)message, CommonComponents.f_130657_, b -> this.exportExposures(exposureIds, this.exportSize, this.exportLook), CommonComponents.f_130658_, b -> {});
            Minecraft.m_91087_().m_91152_((Screen)confirmScreen);
        } else {
            this.exportExposures(exposureIds, this.exportSize, this.exportLook);
        }
    }

    protected void exportExposures(List<String> exposureIds, ExposureSize size, ExposureLook look) {
        ExportExposuresC2SP.sendSplitted(exposureIds, size, look);
    }

    protected void deleteExposures() {
        if (this.mode != Mode.EXPOSURES || this.selection.isEmpty() || this.filteredItems.isEmpty()) {
            return;
        }
        if (Screen.m_96638_()) {
            this.deleteExposuresNoConfirm();
        } else {
            MutableComponent message;
            if (this.selection.size() == 1) {
                String exposureId = this.filteredItems.get(this.selection.get().iterator().next());
                message = Component.m_237110_((String)"gui.exposure_catalog.catalog.confirm.message.delete_one", (Object[])new Object[]{exposureId});
            } else {
                message = Component.m_237110_((String)"gui.exposure_catalog.catalog.confirm.message.delete_many", (Object[])new Object[]{this.selection.size()});
            }
            ConfirmScreen confirmScreen = new ConfirmScreen(this, (Component)message, CommonComponents.f_130657_, b -> this.deleteExposuresNoConfirm(), CommonComponents.f_130658_, b -> {});
            Minecraft.m_91087_().m_91152_((Screen)confirmScreen);
        }
    }

    protected void deleteExposuresNoConfirm() {
        int globalIndex;
        if (this.mode != Mode.EXPOSURES || this.selection.isEmpty() || this.filteredItems.isEmpty()) {
            return;
        }
        ArrayList<String> removedIds = new ArrayList<String>();
        for (Integer index : this.selection.get()) {
            if (index < 0 || index >= this.filteredItems.size()) continue;
            String exposureId = this.filteredItems.get(index);
            Packets.sendToServer(new DeleteExposureC2SP(exposureId));
            removedIds.add(exposureId);
        }
        for (String id : removedIds) {
            this.exposures.remove(id);
            this.filteredItems.remove(id);
            CatalogClient.removeExposure(id);
            this.scrollTo(this.topRowIndex);
        }
        this.selection.clear();
        if (this.isThumbnailsGridFocused && (globalIndex = this.focusedThumbnailIndex + this.topRowIndex * 6) >= 0 && globalIndex < this.filteredItems.size() - 1) {
            this.selection.select(globalIndex);
        }
        this.updateElements();
    }

    protected void updateButtons() {
        this.orderButton.setState(this.order);
        this.sortingButton.setState(this.sorting);
        this.modeButton.setState(this.mode);
        this.sortingButton.f_93623_ = this.mode == Mode.EXPOSURES;
        this.exportButton.f_93623_ = this.mode == Mode.EXPOSURES;
        this.deleteButton.f_93623_ = this.mode == Mode.EXPOSURES && !this.selection.isEmpty();
        this.refreshButton.f_93623_ = this.canRefresh();
    }

    protected void changeMode(Mode mode) {
        this.mode = mode;
        if (mode == Mode.EXPOSURES && this.exposures.isEmpty() || mode == Mode.TEXTURES && this.textures.isEmpty()) {
            this.refresh();
        }
        this.updateButtons();
        this.refreshSearchResults();
    }

    protected void changeOrder(Order order) {
        this.order = order;
        if (this.mode == Mode.EXPOSURES) {
            this.orderAndSortExposuresList(this.order, this.sorting);
        } else {
            this.orderTexturesList(this.order);
        }
        this.updateButtons();
        this.refreshSearchResults();
    }

    protected void changeSorting(Sorting sorting) {
        this.sorting = sorting;
        if (this.mode == Mode.EXPOSURES) {
            this.orderAndSortExposuresList(this.order, this.sorting);
        }
        this.updateButtons();
        this.refreshSearchResults();
    }

    protected void orderAndSortExposuresList(Order order, Sorting sorting) {
        this.exposures.sort(Comparator.naturalOrder());
        if (sorting == Sorting.DATE) {
            Comparator<String> comparator = new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return Long.compare(this.getTimestamp(s1), this.getTimestamp(s2));
                }

                private long getTimestamp(String exposureId) {
                    @Nullable ExposureInfo exposureData = CatalogClient.getExposures().get(exposureId);
                    return exposureData != null ? exposureData.getTimestampUnixSeconds() : 0L;
                }
            };
            this.exposures.sort(comparator);
        }
        if (order == Order.DESCENDING) {
            Collections.reverse(this.exposures);
        }
    }

    protected void orderTexturesList(Order order) {
        this.textures.sort(order == Order.ASCENDING ? Comparator.naturalOrder() : Comparator.reverseOrder());
    }

    public void m_86600_() {
        this.searchBox.m_94120_();
    }

    protected void m_232761_() {
        String searchBoxValue = this.searchBox.m_94155_();
        super.m_232761_();
        this.searchBox.m_94144_(searchBoxValue);
    }

    protected void refreshSearchResults() {
        List<String> items = this.mode == Mode.EXPOSURES ? this.exposures : this.textures;
        String filter = this.searchBox != null ? this.searchBox.m_94155_().trim() : "";
        String[] queries = filter.split("\\s+");
        this.filterSearchResults(items, queries, this.mode);
        this.totalRows = (int)Math.ceil((float)this.filteredItems.size() / 6.0f);
        this.selection.clear();
        this.scroll(Integer.MIN_VALUE);
    }

    protected void filterSearchResults(Collection<String> items, String[] queries, Mode mode) {
        this.filteredItems.clear();
        if (queries.length == 0) {
            this.filteredItems.addAll(items);
            return;
        }
        ArrayList<String> filtered = new ArrayList<String>(items);
        for (String query : queries) {
            if (query.isEmpty()) continue;
            if (mode == Mode.EXPOSURES && (query.startsWith("=") || query.startsWith("!="))) {
                boolean negative = query.startsWith("!=");
                String filter = query.substring(negative ? 2 : 1);
                if (filter.isEmpty()) continue;
                if ("printed".startsWith(filter)) {
                    filtered.removeIf(id -> !CatalogClient.getExposures().get(id).wasPrinted() ^ negative);
                    continue;
                }
                if ("projected".startsWith(filter)) {
                    filtered.removeIf(id -> !CatalogClient.getExposures().get(id).isLoadedFromFile() ^ negative);
                    continue;
                }
                if ("color".startsWith(filter)) {
                    filtered.removeIf(id -> CatalogClient.getExposures().get(id).getType() != FilmType.COLOR ^ negative);
                    continue;
                }
                if (filter.startsWith("x") && filter.length() > 1 && filter.substring(1).matches("^[0-9]+$")) {
                    int size = Integer.parseInt(filter.substring(1));
                    filtered.removeIf(id -> CatalogClient.getExposures().get(id).getWidth() != size ^ negative);
                    continue;
                }
                filtered.clear();
                continue;
            }
            PlainTextSearchTree tree = PlainTextSearchTree.m_235197_(filtered, String::lines);
            filtered = new ArrayList(tree.m_235200_(query.toLowerCase(Locale.ROOT)));
        }
        this.filteredItems.addAll(filtered);
    }

    public void updateThumbnailsGrid() {
        this.thumbnails.clear();
        for (int row = 0; row < 4; ++row) {
            int gridIndex;
            int idIndex;
            for (int column = 0; column < 6 && (idIndex = (gridIndex = column + row * 6) + this.topRowIndex * 6) < this.filteredItems.size(); ++column) {
                int thumbnailX = column * 54;
                int thumbnailY = row * 54;
                String item = this.filteredItems.get(idIndex);
                Either idOrTexture = this.mode == Mode.EXPOSURES ? Either.left((Object)item) : Either.right((Object)new ResourceLocation(item));
                Rect2i area = new Rect2i(this.thumbnailsArea.m_110085_() + 5 + thumbnailX, this.thumbnailsArea.m_110086_() + 5 + thumbnailY, 48, 48);
                boolean isSelected = this.selection.get().contains(idIndex);
                Thumbnail thumbnail = new Thumbnail(idIndex, gridIndex, (Either<String, ResourceLocation>)idOrTexture, area, isSelected);
                this.thumbnails.add(thumbnail);
            }
        }
        this.focusedThumbnailIndex = Mth.m_14045_((int)this.focusedThumbnailIndex, (int)0, (int)(this.thumbnails.size() - 1));
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.refreshButton.f_93623_ = this.canRefresh();
        this.m_280273_(guiGraphics);
        guiGraphics.m_280411_(TEXTURE, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 512);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderScrollBar(guiGraphics, mouseX, mouseY, partialTick);
        this.renderThumbnailsGrid(guiGraphics, mouseX, mouseY, partialTick);
        this.renderLabels(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void renderThumbnailsGrid(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (Thumbnail thumbnail : this.thumbnails) {
            MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            RenderedImageProvider thumbnailImageProvider = this.getThumbnailImage(thumbnail);
            ExposureClient.getExposureRenderer().render(thumbnailImageProvider, ExposurePixelModifiers.EMPTY, guiGraphics.m_280168_(), (MultiBufferSource)bufferSource, (float)thumbnail.area().m_110085_(), (float)thumbnail.area().m_110086_(), (float)thumbnail.area().m_110090_(), (float)thumbnail.area().m_110091_(), 0xF000F0, 255, 255, 255, 255);
            bufferSource.m_109911_();
            int frameVOffset = thumbnail.selected() ? 108 : (thumbnail.isMouseOver(mouseX, mouseY) ? 54 : 0);
            RenderSystem.enableBlend();
            guiGraphics.m_280163_(TEXTURE, thumbnail.area().m_110085_() - 3, thumbnail.area().m_110086_() - 3, 371.0f, (float)frameVOffset, 54, 54, 512, 512);
            RenderSystem.disableBlend();
        }
    }

    protected RenderedImageProvider getThumbnailImage(Thumbnail thumbnail) {
        return (RenderedImageProvider)thumbnail.idOrTexture().map(exposureId -> {
            if (Minecraft.m_91087_().m_257720_()) {
                return ExposureClient.getExposureStorage().getOrQuery(exposureId).map(data -> new RenderedImageProvider((IImage)new ExposureDataImage(exposureId, data))).orElse(RenderedImageProvider.EMPTY);
            }
            return (Util.m_137550_() - this.lastScrolledTime < 250L ? CatalogClient.getThumbnail(exposureId) : CatalogClient.getOrQueryThumbnail(exposureId)).map(th -> new ThumbnailRenderedImageProvider((IImage)th)).orElse(RenderedImageProvider.EMPTY);
        }, texture -> {
            @Nullable TextureImage tex = TextureImage.getTexture((ResourceLocation)texture);
            return tex != null ? new RenderedImageProvider((IImage)tex) : RenderedImageProvider.EMPTY;
        });
    }

    protected void renderTooltip(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.searchBox.m_5953_((double)mouseX, (double)mouseY)) {
            ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
            lines.add(Component.m_237115_((String)"gui.exposure_catalog.searchbar").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"gui.exposure_catalog.searchbar.hotkey")));
            if (Screen.m_96638_()) {
                lines.add(Component.m_237115_((String)"gui.exposure_catalog.searchbar.tooltip.size"));
                lines.add(Component.m_237115_((String)"gui.exposure_catalog.searchbar.tooltip.color"));
                lines.add(Component.m_237115_((String)"gui.exposure_catalog.searchbar.tooltip.printed"));
                lines.add(Component.m_237115_((String)"gui.exposure_catalog.searchbar.tooltip.projected"));
                lines.add(Component.m_237119_());
                lines.add(Component.m_237115_((String)"gui.exposure_catalog.searchbar.tooltip.filters"));
                lines.add(Component.m_237115_((String)"gui.exposure_catalog.searchbar.tooltip.invert"));
            } else {
                lines.add(Component.m_237115_((String)"gui.exposure_catalog.searchbar.tooltip.control_info"));
            }
            guiGraphics.m_280677_(this.f_96547_, lines, Optional.empty(), mouseX, mouseY);
        }
        for (Thumbnail thumbnail : this.thumbnails) {
            if (thumbnail.isMouseOver(mouseX, mouseY)) {
                List<Component> lines = this.getThumbnailTooltipLines(thumbnail);
                guiGraphics.m_280677_(this.f_96547_, lines, Optional.empty(), mouseX, mouseY);
                break;
            }
            if (!this.isThumbnailsGridFocused || thumbnail.gridIndex() != this.focusedThumbnailIndex) continue;
            List<Component> lines = this.getThumbnailTooltipLines(thumbnail);
            guiGraphics.m_280547_(this.f_96547_, Lists.transform(lines, Component::m_7532_), (ClientTooltipPositioner)new BelowOrAboveAreaTooltipPositioner(thumbnail.area()), mouseX, mouseY);
            break;
        }
    }

    @NotNull
    private List<Component> getThumbnailTooltipLines(Thumbnail thumbnail) {
        String idOrTextureStr = (String)thumbnail.idOrTexture().map(s -> s, ResourceLocation::toString);
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)Component.m_237113_((String)idOrTextureStr));
        thumbnail.idOrTexture().ifLeft(exposureId -> {
            @Nullable ExposureInfo exposureInfo = CatalogClient.getExposures().get(exposureId);
            if (exposureInfo != null) {
                long timestampSeconds = exposureInfo.getTimestampUnixSeconds();
                if (timestampSeconds > 0L) {
                    Date date = new Date(timestampSeconds * 1000L);
                    String pattern = "yyyy-MM-dd HH:mm:ss";
                    SimpleDateFormat format = new SimpleDateFormat(pattern);
                    String format1 = format.format(date);
                    lines.add((Component)Component.m_237113_((String)format1).m_130940_(ChatFormatting.GRAY));
                }
                lines.add((Component)Component.m_237113_((String)(exposureInfo.getWidth() + "x" + exposureInfo.getHeight())).m_130940_(ChatFormatting.GRAY));
                if (exposureInfo.wasPrinted()) {
                    lines.add((Component)Component.m_237113_((String)"Printed").m_130940_(ChatFormatting.GRAY));
                }
                if (exposureInfo.isLoadedFromFile()) {
                    lines.add((Component)Component.m_237113_((String)"Projected").m_130940_(ChatFormatting.GRAY));
                }
            }
        });
        lines.add((Component)Component.m_237119_());
        if (Screen.m_96638_()) {
            lines.add((Component)Component.m_237115_((String)"gui.exposure_catalog.thumbnail.tooltip.view"));
            lines.add((Component)Component.m_237115_((String)"gui.exposure_catalog.thumbnail.tooltip.selection"));
            lines.add((Component)Component.m_237115_((String)"gui.exposure_catalog.thumbnail.tooltip.selection.shift"));
            lines.add((Component)Component.m_237115_((String)"gui.exposure_catalog.thumbnail.tooltip.selection.clear"));
        } else {
            lines.add((Component)Component.m_237115_((String)"gui.exposure_catalog.thumbnail.tooltip.control_info"));
        }
        return lines;
    }

    protected boolean isMouseOver(Rect2i rect, double mouseX, double mouseY) {
        return mouseX >= (double)rect.m_110085_() && mouseX < (double)(rect.m_110085_() + rect.m_110090_()) && mouseY >= (double)rect.m_110086_() && mouseY < (double)(rect.m_110086_() + rect.m_110091_());
    }

    protected void renderScrollBar(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int state = 0;
        if (!this.canScroll()) {
            state = 2;
        } else if (this.isDraggingScrollbar || this.isMouseOver(this.scrollThumb, mouseX, mouseY)) {
            state = 1;
        }
        int thumbStateOffset = 9;
        guiGraphics.m_280163_(TEXTURE, this.scrollThumb.m_110085_(), this.scrollThumb.m_110086_(), 361.0f, (float)(state * thumbStateOffset), this.scrollThumb.m_110090_(), 3, 512, 512);
        int middleParts = (this.scrollThumb.m_110091_() - 3 - 2) / 4;
        for (int i = 0; i < middleParts; ++i) {
            guiGraphics.m_280163_(TEXTURE, this.scrollThumb.m_110085_(), this.scrollThumb.m_110086_() + i * 4 + 3, 361.0f, (float)(3 + state * thumbStateOffset), this.scrollThumb.m_110090_(), 4, 512, 512);
        }
        guiGraphics.m_280163_(TEXTURE, this.scrollThumb.m_110085_(), this.scrollThumb.m_110086_() + middleParts * 4 + 3, 361.0f, (float)(7 + state * thumbStateOffset), this.scrollThumb.m_110090_(), 2, 512, 512);
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        MutableComponent title = this.mode == Mode.EXPOSURES ? Component.m_237115_((String)"gui.exposure_catalog.catalog.exposures") : Component.m_237115_((String)"gui.exposure_catalog.catalog.textures");
        guiGraphics.m_280614_(this.f_96547_, (Component)title, this.leftPos + 8, this.topPos + 8, -12500671, false);
        if (this.mode == Mode.EXPOSURES && !this.isLoading && !this.haveExposures) {
            MutableComponent component = Component.m_237115_((String)"gui.exposure_catalog.catalog.no_exposures");
            int x = this.thumbnailsArea.m_110085_() + this.thumbnailsArea.m_110090_() / 2 - this.f_96547_.m_92852_((FormattedText)component) / 2;
            int y = this.thumbnailsArea.m_110086_() + this.thumbnailsArea.m_110091_() / 2 - 5;
            guiGraphics.m_280614_(this.f_96547_, (Component)component, x, y, -12500671, false);
        }
        if (this.isLoading && this.mode == Mode.EXPOSURES) {
            int dotAnimation = (int)(Util.m_137550_() / 750L % 3L) + 1;
            MutableComponent component = Component.m_237115_((String)("gui.exposure_catalog.catalog.loading" + dotAnimation)).m_130948_(Style.f_131099_.m_178520_(-12500671));
            guiGraphics.m_280614_(this.f_96547_, (Component)component, this.leftPos + this.imageWidth / 2 - this.f_96547_.m_92852_((FormattedText)component) / 2, this.topPos + 249, -12500671, false);
        } else if (!this.filteredItems.isEmpty()) {
            String filteredCountStr = Integer.toString(this.filteredItems.size());
            MutableComponent countComponent = Component.m_237113_((String)filteredCountStr).m_130948_(Style.f_131099_.m_178520_(-12500671));
            if (!this.selection.isEmpty()) {
                String selectedCountStr = Integer.toString(this.selection.size());
                countComponent = Component.m_237113_((String)selectedCountStr).m_130948_(Style.f_131099_.m_178520_(-13084453)).m_7220_((Component)Component.m_237113_((String)"/").m_130948_(Style.f_131099_.m_178520_(-12500671))).m_7220_((Component)countComponent);
            }
            guiGraphics.m_280614_(this.f_96547_, (Component)countComponent, this.leftPos + this.imageWidth / 2 - this.f_96547_.m_92852_((FormattedText)countComponent) / 2, this.topPos + 249, -12500671, false);
        }
        if (this.searchBox.m_94213_() && !this.searchBox.m_93696_() && this.searchBox.m_94155_().isEmpty()) {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.exposure_catalog.catalog.search_bar_placeholder_text"), this.searchBarArea.m_110085_() + 2, this.searchBarArea.m_110086_() + 1, -4276546, false);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.m_7522_(null);
        this.isThumbnailsGridFocused = false;
        if (button == 1 && this.searchBox.m_5953_(mouseX, mouseY)) {
            String value = this.searchBox.m_94155_();
            this.searchBox.m_94144_("");
            if (!value.equals(this.searchBox.m_94155_())) {
                this.refreshSearchResults();
            }
            this.m_7522_((GuiEventListener)this.searchBox);
            return true;
        }
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 2) {
            return false;
        }
        if (this.isMouseOver(this.thumbnailsArea, mouseX, mouseY)) {
            for (Thumbnail thumbnail : this.thumbnails) {
                if (!thumbnail.isMouseOver(mouseX, mouseY)) continue;
                if (Screen.m_96637_() || button == 1) {
                    if (Screen.m_96638_()) {
                        int start = Math.min(thumbnail.index(), this.selection.getLastSelectedIndex());
                        int end = Math.max(thumbnail.index(), this.selection.getLastSelectedIndex());
                        for (int i = start; i <= end; ++i) {
                            if (this.selection.get().contains(i)) continue;
                            this.selection.select(i);
                        }
                    } else if (this.selection.get().contains(thumbnail.index)) {
                        this.selection.remove(thumbnail.index());
                    } else {
                        this.selection.select(thumbnail.index());
                    }
                    this.updateElements();
                } else {
                    this.openPhotographView(thumbnail.index());
                }
                return true;
            }
            if (!this.selection.isEmpty()) {
                this.selection.clear();
                this.updateThumbnailsGrid();
                return true;
            }
        }
        if (this.canScroll()) {
            if (this.isMouseOver(this.scrollThumb, mouseX, mouseY)) {
                this.m_7897_(true);
                this.isDraggingScrollbar = true;
                this.dragDelta = 0.0;
                this.topRowIndexAtDragStart = this.topRowIndex;
                return true;
            }
            if (this.isMouseOver(this.scrollBarArea, mouseX, mouseY)) {
                int direction = mouseY < (double)this.scrollThumb.m_110086_() ? -1 : 1;
                this.scroll(4 * direction);
                return true;
            }
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.isDraggingScrollbar || button != 0) {
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        this.dragDelta += dragY;
        double threshold = (double)this.scrollBarArea.m_110091_() / (double)Math.max(this.totalRows, 1);
        int rows = (int)(this.dragDelta / threshold);
        if (rows != 0 || this.topRowIndex != this.topRowIndexAtDragStart) {
            this.scrollTo(this.topRowIndexAtDragStart + rows);
        }
        return true;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.isDraggingScrollbar = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (super.m_6050_(mouseX, mouseY, delta)) {
            return true;
        }
        this.scroll((int)(-delta));
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && (this.searchBox.m_93696_() || this.isThumbnailsGridFocused)) {
            this.m_7522_(null);
            this.isThumbnailsGridFocused = false;
            return true;
        }
        if (this.isThumbnailsGridFocused && keyCode == 257) {
            this.openPhotographView(this.thumbnails.get(this.focusedThumbnailIndex).index());
            return true;
        }
        if (this.searchBox.m_94204_() && keyCode != 258) {
            String string = this.searchBox.m_94155_();
            if (this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
                if (!string.equals(this.searchBox.m_94155_())) {
                    this.refreshSearchResults();
                }
                return true;
            }
            if (keyCode != 256) {
                return true;
            }
        }
        if (this.tabKeyPressed(keyCode)) {
            return true;
        }
        if (this.arrowKeysPressed(keyCode)) {
            return true;
        }
        if (keyCode == 268) {
            this.selection.clear();
            this.selection.select(0);
            this.focusedThumbnailIndex = 0;
            this.scroll(Integer.MIN_VALUE);
            return true;
        }
        if (keyCode == 269) {
            this.selection.clear();
            this.selection.select(this.filteredItems.size() - 1);
            this.focusedThumbnailIndex = this.filteredItems.size() - 1;
            this.scroll(Integer.MAX_VALUE);
            return true;
        }
        if (keyCode == 261) {
            this.deleteExposures();
            return true;
        }
        if (Screen.m_96637_()) {
            if (keyCode == 70) {
                this.m_7522_((GuiEventListener)this.searchBox);
                return true;
            }
            if (keyCode == 77) {
                this.changeMode(Mode.values()[(this.mode.ordinal() + 1) % Mode.values().length]);
                this.playClickSound();
                return true;
            }
            if (keyCode == 82) {
                if (this.canRefresh()) {
                    this.refresh();
                    this.playClickSound();
                }
                return true;
            }
            if (keyCode == 69) {
                this.exportExposures();
                this.playClickSound();
                return true;
            }
            if (keyCode == 65) {
                this.selection.clear();
                this.selection.select(IntStream.range(0, this.filteredItems.size()).boxed().toList());
                this.updateElements();
                this.playClickSound();
                return true;
            }
            if (keyCode == 68) {
                if (!this.selection.isEmpty()) {
                    this.selection.clear();
                    this.updateElements();
                    this.playClickSound();
                }
                return true;
            }
        }
        if (Minecraft.m_91087_().f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private boolean tabKeyPressed(int keyCode) {
        if (keyCode != 258) {
            return false;
        }
        if (!this.filteredItems.isEmpty() && !Screen.m_96638_() && this.m_7222_() == this.modeButton) {
            this.m_7522_(null);
            this.isThumbnailsGridFocused = true;
            this.focusedThumbnailIndex = 0;
            this.selection.clear();
            this.selection.select(this.focusedThumbnailIndex + this.topRowIndex * 6);
            this.updateElements();
            return true;
        }
        if (!this.filteredItems.isEmpty() && Screen.m_96638_() && this.m_7222_() == this.refreshButton && !this.isThumbnailsGridFocused) {
            this.m_7522_(null);
            this.isThumbnailsGridFocused = true;
            this.focusedThumbnailIndex = 0;
            this.selection.clear();
            this.selection.select(this.focusedThumbnailIndex + this.topRowIndex * 6);
            this.updateElements();
            return true;
        }
        if (this.isThumbnailsGridFocused) {
            Button newFocusTarget = Screen.m_96638_() ? this.modeButton : this.refreshButton;
            this.m_7522_((GuiEventListener)newFocusTarget);
            this.isThumbnailsGridFocused = false;
            if (this.selection.size() == 1 && this.selection.get().iterator().next() == this.focusedThumbnailIndex + this.topRowIndex * 6) {
                this.selection.clear();
                this.updateElements();
            }
            return true;
        }
        return false;
    }

    private boolean arrowKeysPressed(int keyCode) {
        if (this.filteredItems.isEmpty() || !List.of(Integer.valueOf(263), Integer.valueOf(262), Integer.valueOf(265), Integer.valueOf(264)).contains(keyCode)) {
            return false;
        }
        if (!this.isThumbnailsGridFocused) {
            this.m_7522_(null);
            this.isThumbnailsGridFocused = true;
            this.focusedThumbnailIndex = 0;
            this.selection.select(this.focusedThumbnailIndex + this.topRowIndex * 6);
            this.updateElements();
            return true;
        }
        Map<Integer, Integer> keys = Map.of(263, -1, 262, 1, 265, -6, 264, 6);
        int change = keys.get(keyCode);
        int oldIndex = this.focusedThumbnailIndex;
        int newIndex = this.focusedThumbnailIndex + change;
        if (newIndex < 0) {
            if (this.topRowIndex <= 0) {
                return true;
            }
            this.scroll(-1);
            newIndex += 6;
        } else if (newIndex > 23) {
            if (this.topRowIndex >= this.totalRows - 4) {
                return true;
            }
            this.scroll(1);
            newIndex -= 6;
        }
        this.focusedThumbnailIndex = Mth.m_14045_((int)newIndex, (int)0, (int)(this.thumbnails.size() - 1));
        if (!Screen.m_96638_()) {
            this.selection.clear();
        } else {
            int lesser = Math.min(oldIndex, newIndex);
            int larger = Math.max(oldIndex, newIndex);
            for (int i = lesser; i <= larger; ++i) {
                this.selection.select(i + this.topRowIndex * 6);
            }
        }
        this.selection.select(this.focusedThumbnailIndex + this.topRowIndex * 6);
        this.updateElements();
        return true;
    }

    protected void updateElements() {
        this.totalRows = (int)Math.ceil((float)this.filteredItems.size() / 6.0f);
        this.updateScrollThumb();
        this.updateButtons();
        this.updateThumbnailsGrid();
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.searchBox.m_94204_()) {
            String string = this.searchBox.m_94155_();
            if (this.searchBox.m_5534_(codePoint, modifiers)) {
                if (!string.equals(this.searchBox.m_94155_())) {
                    this.refreshSearchResults();
                }
                return true;
            }
        }
        return false;
    }

    public boolean canScroll() {
        return this.totalRows > 4;
    }

    public void scroll(int rows) {
        this.scrollTo(this.topRowIndex + rows);
    }

    public void scrollTo(int row) {
        int maxRowWhenAtEnd = Math.max(0, (int)Math.ceil((float)(this.filteredItems.size() - 24) / 6.0f));
        this.topRowIndex = Mth.m_14045_((int)row, (int)0, (int)maxRowWhenAtEnd);
        this.updateScrollThumb();
        this.updateThumbnailsGrid();
        this.lastScrolledTime = Util.m_137550_();
    }

    protected void updateScrollThumb() {
        int minSize = 9;
        float ratio = 4.0f / (float)Math.max(this.totalRows, 1);
        int size = Mth.m_14045_((int)Mth.m_14167_((float)((float)this.scrollBarArea.m_110091_() * ratio)), (int)minSize, (int)this.scrollBarArea.m_110091_());
        int midSize = size - 3 - 2;
        int correctedMidSize = Math.max(midSize - midSize % 4, 4);
        size = 3 + correctedMidSize + 2;
        float topRowPos = (float)this.topRowIndex / (float)Math.max(1, this.totalRows - 4);
        int pos = (int)Mth.m_184637_((float)topRowPos, (float)0.0f, (float)1.0f, (float)0.0f, (float)(this.scrollBarArea.m_110091_() - size));
        this.scrollThumb = new Rect2i(this.scrollBarArea.m_110085_(), this.scrollBarArea.m_110086_() + pos, this.scrollBarArea.m_110090_(), size);
    }

    protected void openPhotographView(int clickedIndex) {
        ArrayList<String> items = !this.selection.isEmpty() ? this.selection.get().stream().map(i -> this.filteredItems.get((int)i)).toList() : this.filteredItems;
        ArrayList<ItemAndStack<PhotographItem>> photographs = new ArrayList<ItemAndStack<PhotographItem>>(items.stream().map(item -> {
            ItemStack stack = new ItemStack((ItemLike)Exposure.Items.PHOTOGRAPH.get());
            CompoundTag tag = new CompoundTag();
            tag.m_128359_(this.mode == Mode.EXPOSURES ? "Id" : "Texture", item);
            stack.m_41751_(tag);
            return new ItemAndStack(stack);
        }).toList());
        String clickedId = this.filteredItems.get(clickedIndex);
        int clickedIdIndex = Math.max(0, items.indexOf(clickedId));
        Collections.rotate(photographs, -clickedIdIndex);
        CatalogPhotographScreen screen = new CatalogPhotographScreen(this, photographs);
        Minecraft.m_91087_().m_91152_((Screen)screen);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get()), (float)(Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_9236_().m_213780_().m_188501_() * 0.2f + 1.3f), (float)0.75f));
    }

    public void m_7379_() {
        this.saveState();
        CatalogClient.clear();
        ExposureClient.getExposureStorage().clear();
        Packets.sendToServer(new CatalogClosedC2SP());
        super.m_7379_();
    }

    protected void saveState() {
        JsonObject obj = new JsonObject();
        obj.addProperty("mode", this.mode.m_7912_());
        obj.addProperty("order", this.order.m_7912_());
        obj.addProperty("sorting", this.sorting.m_7912_());
        obj.addProperty("export_size", this.exportSize.m_7912_());
        obj.addProperty("export_look", this.exportLook.m_7912_());
        try (FileWriter writer = new FileWriter(this.stateFile);){
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)obj, (Appendable)writer);
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Cannot save catalog state: " + e);
        }
    }

    protected void loadState() {
        try {
            if (!Files.exists(this.stateFile.toPath(), new LinkOption[0]) || Files.size(this.stateFile.toPath()) == 0L) {
                return;
            }
            try (FileReader reader = new FileReader(this.stateFile);){
                JsonObject obj = GsonHelper.m_13859_((Reader)reader);
                this.mode = Mode.fromSerializedString(obj.get("mode").getAsString());
                this.order = Order.fromSerializedString(obj.get("order").getAsString());
                this.sorting = Sorting.fromSerializedString(obj.get("sorting").getAsString());
                this.exportSize = ExposureSize.byName((String)obj.get("export_size").getAsString());
                this.exportLook = ExposureLook.byName((String)obj.get("export_look").getAsString());
            }
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Cannot load catalog state: {}", (Object)e.toString());
        }
    }

    public record Thumbnail(int index, int gridIndex, Either<String, ResourceLocation> idOrTexture, Rect2i area, boolean selected) {
        public boolean isMouseOver(double mouseX, double mouseY) {
            return mouseX >= (double)this.area.m_110085_() && mouseX < (double)(this.area.m_110085_() + this.area.m_110090_()) && mouseY >= (double)this.area.m_110086_() && mouseY < (double)(this.area.m_110086_() + this.area.m_110091_());
        }
    }
}

