/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog.gui.screen;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.util.Either;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.camera.infrastructure.FrameData;
import io.github.mortuusars.exposure.gui.screen.ZoomableScreen;
import io.github.mortuusars.exposure.gui.screen.element.Pager;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.render.PhotographRenderer;
import io.github.mortuusars.exposure.util.ItemAndStack;
import io.github.mortuusars.exposure.util.PagingDirection;
import io.github.mortuusars.exposure_catalog.gui.screen.OverlayScreen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CatalogPhotographScreen
extends ZoomableScreen
implements OverlayScreen {
    public static final ResourceLocation WIDGETS_TEXTURE = Exposure.resource((String)"textures/gui/widgets.png");
    private final Screen parent;
    private final List<ItemAndStack<PhotographItem>> photographs;
    private final Pager pager = new Pager((SoundEvent)Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get());

    public CatalogPhotographScreen(Screen parentScreen, List<ItemAndStack<PhotographItem>> photographs) {
        super((Component)Component.m_237119_());
        this.parent = parentScreen;
        Preconditions.checkState((!photographs.isEmpty() ? 1 : 0) != 0, (Object)"No photographs to display.");
        this.photographs = photographs;
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.zoomFactor = (float)this.f_96544_ / (float)ExposureClient.getExposureRenderer().getSize();
        ImageButton previousButton = new ImageButton(0, (int)((float)this.f_96544_ / 2.0f - 8.0f), 16, 16, 0, 0, 16, WIDGETS_TEXTURE, 256, 256, button -> this.pager.changePage(PagingDirection.PREVIOUS), (Component)Component.m_237115_((String)"gui.exposure.previous_page"));
        this.m_142416_((GuiEventListener)previousButton);
        ImageButton nextButton = new ImageButton(this.f_96543_ - 16, (int)((float)this.f_96544_ / 2.0f - 8.0f), 16, 16, 16, 0, 16, WIDGETS_TEXTURE, 256, 256, button -> this.pager.changePage(PagingDirection.NEXT), (Component)Component.m_237115_((String)"gui.exposure.next_page"));
        this.m_142416_((GuiEventListener)nextButton);
        this.pager.init(this.photographs.size(), true, (AbstractButton)previousButton, (AbstractButton)nextButton);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.zoom.targetZoom == this.zoom.minZoom) {
            this.close();
            return;
        }
        this.pager.update();
        this.m_280273_(guiGraphics);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 500.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(this.x, this.y, 0.0f);
        guiGraphics.m_280168_().m_252880_((float)this.f_96543_ / 2.0f, (float)this.f_96544_ / 2.0f, 0.0f);
        guiGraphics.m_280168_().m_85841_(this.scale, this.scale, this.scale);
        guiGraphics.m_280168_().m_252880_((float)ExposureClient.getExposureRenderer().getSize() / -2.0f, (float)ExposureClient.getExposureRenderer().getSize() / -2.0f, 0.0f);
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        ArrayList<ItemAndStack<PhotographItem>> photos = new ArrayList<ItemAndStack<PhotographItem>>(this.photographs);
        Collections.rotate(photos, -this.pager.getCurrentPage());
        PhotographRenderer.renderStackedPhotographs(photos, (PoseStack)guiGraphics.m_280168_(), (MultiBufferSource)bufferSource, (int)0xF000F0, (int)255, (int)255, (int)255, (int)255);
        bufferSource.m_109911_();
        guiGraphics.m_280168_().m_85849_();
        ItemAndStack<PhotographItem> photograph = this.photographs.get(this.pager.getCurrentPage());
        Either idOrTexture = FrameData.getIdOrTexture((ItemStack)photograph.getStack());
        String exposureName = (String)idOrTexture.map(id -> id, ResourceLocation::toString);
        if (this.minecraft.f_91074_ != null && this.minecraft.f_91074_.m_7500_() && !exposureName.isEmpty()) {
            guiGraphics.m_280488_(this.f_96547_, "?", this.f_96543_ - this.f_96547_.m_92895_("?") - 10, 10, -1);
            if (mouseX > this.f_96543_ - 20 && mouseX < this.f_96543_ && mouseY < 20) {
                ArrayList<Object> lines = new ArrayList<Object>();
                lines.add(Component.m_237113_((String)exposureName));
                lines.add(Component.m_237110_((String)"gui.exposure.photograph_screen.drop_as_item_tooltip", (Object[])new Object[]{Component.m_237113_((String)"CTRL + I")}));
                lines.add((Component)idOrTexture.map(id -> Component.m_237110_((String)"gui.exposure.photograph_screen.copy_id_tooltip", (Object[])new Object[]{"CTRL + C"}), texture -> Component.m_237110_((String)"gui.exposure.photograph_screen.copy_texture_path_tooltip", (Object[])new Object[]{"CTRL + C"})));
                guiGraphics.m_280677_(this.f_96547_, lines, Optional.empty(), mouseX, mouseY + 20);
            }
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 || this.minecraft.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.zoom.set(0.0f);
            return true;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (Screen.m_96637_() && player != null && player.m_7500_()) {
            ItemAndStack<PhotographItem> photograph = this.photographs.get(this.pager.getCurrentPage());
            if (keyCode == 67) {
                Either idOrTexture = FrameData.getIdOrTexture((ItemStack)photograph.getStack());
                String exposureId = (String)idOrTexture.map(id -> id, ResourceLocation::toString);
                if (!exposureId.isEmpty()) {
                    Minecraft.m_91087_().f_91068_.m_90911_(exposureId);
                    player.m_5661_((Component)Component.m_237110_((String)"gui.exposure.photograph_screen.copied_message", (Object[])new Object[]{exposureId}), false);
                }
                return true;
            }
            if (keyCode == 73) {
                if (Minecraft.m_91087_().f_91072_ != null) {
                    Minecraft.m_91087_().f_91072_.m_105239_(photograph.getStack().m_41777_());
                    player.m_5661_((Component)Component.m_237110_((String)"gui.exposure.photograph_screen.item_dropped_message", (Object[])new Object[]{photograph.getStack().toString()}), false);
                }
                return true;
            }
        }
        return this.pager.handleKeyPressed(keyCode, scanCode, modifiers) || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return this.pager.handleKeyReleased(keyCode, scanCode, modifiers) || super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 1) {
            this.zoom.set(0.0f);
            return true;
        }
        return false;
    }

    public void close() {
        Minecraft.m_91087_().m_91152_(this.getParent());
        if (this.minecraft.f_91074_ != null) {
            this.minecraft.f_91074_.m_5496_((SoundEvent)Exposure.SoundEvents.PHOTOGRAPH_PLACE.get(), 0.7f, 1.1f);
        }
    }

    @Override
    public Screen getParent() {
        return this.parent;
    }
}

