/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.object;

import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.tslat.smartbrainlib.util.SensoryUtils;
import org.jetbrains.annotations.Nullable;

public class ExtendedTargetingConditions {
    protected BiPredicate<LivingEntity, LivingEntity> customFilter = null;
    protected Function<LivingEntity, Double> rangeRetriever = null;
    protected boolean isAttacking = true;
    protected boolean checkLineOfSight = true;
    protected boolean ignoresInvisibility = false;

    public static ExtendedTargetingConditions forLookTarget() {
        return new ExtendedTargetingConditions().isJustLooking();
    }

    public static ExtendedTargetingConditions forLookTargetIgnoringInvisibility() {
        return ExtendedTargetingConditions.forLookTarget().skipInvisibilityCheck();
    }

    public static ExtendedTargetingConditions forAttackTarget() {
        return new ExtendedTargetingConditions();
    }

    public static ExtendedTargetingConditions forAttackTargetIgnoringInvisibility() {
        return ExtendedTargetingConditions.forAttackTarget().skipInvisibilityCheck();
    }

    public ExtendedTargetingConditions isJustLooking() {
        this.isAttacking = false;
        return this;
    }

    public ExtendedTargetingConditions withRange(double range) {
        return this.withRange(entity -> range);
    }

    public ExtendedTargetingConditions withRange(Function<LivingEntity, Double> function) {
        this.rangeRetriever = function;
        return this;
    }

    public ExtendedTargetingConditions withFollowRange() {
        return this.withRange(entity -> entity.m_21051_(Attributes.f_22277_) != null ? entity.m_21133_(Attributes.f_22277_) : 16.0);
    }

    public ExtendedTargetingConditions onlyTargeting(BiPredicate<@Nullable LivingEntity, LivingEntity> predicate) {
        this.customFilter = predicate;
        return this;
    }

    public ExtendedTargetingConditions ignoreLineOfSight() {
        this.checkLineOfSight = false;
        return this;
    }

    public ExtendedTargetingConditions skipInvisibilityCheck() {
        this.ignoresInvisibility = true;
        return this;
    }

    public boolean test(@Nullable LivingEntity entity, LivingEntity target) {
        if (entity == target || !target.m_142065_()) {
            return false;
        }
        if (this.customFilter != null && !this.customFilter.test(entity, target)) {
            return false;
        }
        if (entity == null) {
            return !this.isAttacking || target.m_142066_() && target.m_9236_().m_46791_() != Difficulty.PEACEFUL;
        }
        if (this.isAttacking && (!entity.m_6779_(target) || !entity.m_6549_(target.m_6095_()) || entity.m_7307_((Entity)target))) {
            return false;
        }
        double range = this.rangeRetriever.apply(entity);
        if (range > 0.0) {
            double sightRange = Math.max(range * (this.ignoresInvisibility ? 1.0 : target.m_20968_((Entity)entity)), 2.0);
            if (entity.m_20280_((Entity)target) > sightRange * sightRange) {
                return false;
            }
        }
        if (this.checkLineOfSight) {
            return SensoryUtils.hasLineOfSight(entity, (Entity)target);
        }
        return true;
    }
}

