/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.platform.forge;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.untitledduckmod.DuckMod;
import net.untitledduckmod.common.entity.CustomSpawnGroup;
import net.untitledduckmod.common.entity.forge.DuckEntityForge;
import net.untitledduckmod.common.entity.forge.GooseEntityForge;

public class RegistryHelperImpl {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"untitledduckmod");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"untitledduckmod");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"untitledduckmod");
    public static final DeferredRegister<Potion> POTIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)"untitledduckmod");
    public static final DeferredRegister<MobEffect> STATUS_EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"untitledduckmod");
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"untitledduckmod");

    public static <T extends Item> Supplier<T> registerItem(String name, Supplier<T> item) {
        return ITEMS.register(name, item);
    }

    public static <T extends Item> Supplier<T> registerSpawnEggItem(String name, Supplier<? extends EntityType<? extends Mob>> type, int primaryColor, int secondaryColor, Item.Properties settings) {
        return RegistryHelperImpl.registerItem(name, () -> new ForgeSpawnEggItem(type, primaryColor, secondaryColor, settings));
    }

    public static <T extends EntityType<?>> Supplier<T> registerEntity(String name, Supplier<T> entityType) {
        if (name.equals("duck")) {
            entityType = () -> EntityType.Builder.m_20704_(DuckEntityForge::new, (MobCategory)CustomSpawnGroup.WATERFOWL.spawnGroup).m_20699_(0.6f, 0.6f).m_20702_(10).m_20712_(DuckMod.stringID("duck"));
        } else if (name.equals("goose")) {
            entityType = () -> EntityType.Builder.m_20704_(GooseEntityForge::new, (MobCategory)CustomSpawnGroup.WATERFOWL.spawnGroup).m_20699_(0.7f, 1.2f).m_20702_(10).m_20712_(DuckMod.stringID("goose"));
        }
        return ENTITY_TYPES.register(name, entityType);
    }

    public static Supplier<SoundEvent> registerSoundEvent(String name) {
        return SOUND_EVENTS.register(name, () -> SoundEvent.m_262824_((ResourceLocation)DuckMod.id(name)));
    }

    public static <T extends Potion> Supplier<T> registerPotion(String name, Supplier<T> potion) {
        return POTIONS.register(name, potion);
    }

    public static <T extends MobEffect> Supplier<T> registerStatusEffect(String name, Supplier<T> statusEffect) {
        return STATUS_EFFECTS.register(name, statusEffect);
    }

    public static <T extends Codec<? extends BiomeModifier>> void registerBiomeModifier(String name, Supplier<T> biomeModifier) {
        BIOME_MODIFIERS.register(name, biomeModifier);
    }
}

