/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.entity;

import dev.shadowsoffire.placebo.reload.DynamicHolder;
import io.github.chakyl.splendidslimes.SlimyConfig;
import io.github.chakyl.splendidslimes.data.SlimeBreed;
import io.github.chakyl.splendidslimes.entity.SlimeEntityBase;
import io.github.chakyl.splendidslimes.item.SlimeSpawnEggItem;
import io.github.chakyl.splendidslimes.registry.ModElements;
import io.github.chakyl.splendidslimes.util.SlimeData;
import io.github.chakyl.splendidslimes.util.SlimeUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SplendidSlime
extends SlimeEntityBase {
    public static final EntityDataAccessor<Integer> HAPPINESS = SynchedEntityData.m_135353_(SplendidSlime.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> EATING_COOLDOWN = SynchedEntityData.m_135353_(SplendidSlime.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LAST_ATE = SynchedEntityData.m_135353_(SplendidSlime.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> TARGET_ENTITY = SynchedEntityData.m_135353_(SplendidSlime.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> PARTICLE_ANIMATION_TICK = SynchedEntityData.m_135353_(SplendidSlime.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> TAMED = SynchedEntityData.m_135353_(SplendidSlime.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(SplendidSlime.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static final String SLIME = "slime";
    public static final String ID = "id";
    public static final String DATA = "data";
    public static final int SLIME_EFFECT_COOLDOWN = SlimyConfig.slimeEffectCooldown;
    public static final int SLIME_STARVING_COOLDOWN = SlimyConfig.slimeStarvingTime;
    public static final int SLIME_HUNGRY_THRESHOLD = SLIME_STARVING_COOLDOWN / 2;
    public static final int MAX_HAPPINESS = SlimyConfig.slimeMaxHappiness;
    public static final int FURIOUS_THRESHOLD = SlimyConfig.slimeFuriousThreshold;
    public static final int UNHAPPY_THRESHOLD = SlimyConfig.slimeUnhappyThreshold;
    public static final int HAPPY_THRESHOLD = SlimyConfig.slimeHappyThreshold;
    public ItemEntity itemTarget = null;
    boolean tarred;
    private final EntityType<SlimeEntityBase> entityType;
    private final int effectRadius = 6;
    private final int particleAnimationTime = 2;

    public SplendidSlime(EntityType<SlimeEntityBase> entityType, Level level) {
        super(entityType, level);
        this.entityType = entityType;
        this.tarred = false;
        this.f_21342_ = new SlimeMoveControl(this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SlimeFloatGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new SlimeTargetItemGoal(this, 60));
        this.f_21345_.m_25352_(2, new SlimeAttackEntities((Mob)this, true, 60, null));
        this.f_21345_.m_25352_(2, (Goal)new SlimeAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new SlimeRandomDirectionGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new SlimeKeepOnJumpingGoal(this));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            DynamicHolder<SlimeBreed> slime;
            int happiness = this.getHappiness();
            int eatCooldown = this.getEatingCooldown();
            if (eatCooldown > 0 && this.f_19797_ % 20 == 0 && this.isOwnerOnline()) {
                this.setEatingCooldown(eatCooldown - 20);
            }
            if (this.f_19797_ == 2) {
                slime = this.getSlime();
                DynamicHolder<SlimeBreed> secondarySlime = this.getSecondarySlime();
                if (slime.isBound()) {
                    SlimeUtils.applyEffects(this, (LivingEntity)this, ((SlimeBreed)slime.get()).innateEffects(), false);
                }
                if (secondarySlime.isBound()) {
                    SlimeUtils.applyEffects(this, (LivingEntity)this, ((SlimeBreed)secondarySlime.get()).innateEffects(), false);
                }
            }
            if (this.f_19797_ % SLIME_EFFECT_COOLDOWN == 0 && this.isOwnerOnline() && (slime = this.getSlime()).isBound()) {
                if (happiness <= UNHAPPY_THRESHOLD || this.hasTrait("inverse") && happiness >= HAPPY_THRESHOLD) {
                    double chance = 1.0 - ((double)happiness + 1.0) / (double)UNHAPPY_THRESHOLD;
                    if ((double)this.f_19796_.m_188501_() <= chance) {
                        List nearbyEntities = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(6.0));
                        for (LivingEntity entity : nearbyEntities) {
                            SlimeUtils.applyNegativeEffects(this, entity, true);
                        }
                        SlimeUtils.executeSlimeCommands(this, true, false);
                    }
                } else if (happiness >= HAPPY_THRESHOLD || this.hasTrait("inverse")) {
                    double chance = 1.0 - ((double)happiness + 1.0) / (double)HAPPY_THRESHOLD;
                    if ((double)this.f_19796_.m_188501_() <= chance) {
                        List nearbyEntities = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(6.0));
                        for (LivingEntity entity : nearbyEntities) {
                            SlimeUtils.applyPositiveEffects(this, entity, true);
                        }
                        SlimeUtils.executeSlimeCommands(this, false, false);
                    }
                }
                if (!this.notHungry()) {
                    SlimeUtils.handleHungryTraits(this);
                }
            }
            if (this.f_19797_ % (SLIME_EFFECT_COOLDOWN * 4) == 0 && this.hasTrait("weeping") && !SlimeUtils.cry(this, this.m_9236_())) {
                this.addHappiness(-50);
            }
            if (this.f_19797_ % 600 == 0 && this.isOwnerOnline()) {
                if (happiness <= FURIOUS_THRESHOLD && this.hasTrait("nuclear")) {
                    this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.hasTrait("flaming") ? 12.0f : 16.0f, this.hasTrait("flaming"), Level.ExplosionInteraction.MOB);
                    this.m_6074_();
                }
                if (this.hasTrait("floating") && (double)this.f_19796_.m_188501_() <= 0.65) {
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19620_, this.f_19796_.m_216332_(10, 300), 0, true, false));
                }
                if (happiness > MAX_HAPPINESS) {
                    this.setHappiness(MAX_HAPPINESS - 1);
                } else if (happiness > 0) {
                    if (this.hasTrait("aquatic") && !this.m_20069_()) {
                        this.addHappiness(-10);
                    }
                    if (this.getEatingCooldown() == 0) {
                        this.addHappiness(-5);
                    }
                } else {
                    this.setHappiness(0);
                }
            }
            int particleAnimationTick = this.getParticleAnimationTick();
            int animationTime = 12;
            if (!this.m_21224_() && particleAnimationTick > -1 && particleAnimationTick < animationTime) {
                this.m_9236_().m_7605_((Entity)this, (byte)5);
                if (particleAnimationTick + 1 >= animationTime) {
                    this.setParticleAnimationTick(-1);
                } else {
                    this.setParticleAnimationTick(particleAnimationTick + 1);
                }
            }
        }
    }

    public void m_7822_(byte event) {
        if (event == 5) {
            SimpleParticleType particle = ((SlimeBreed)this.getSlime().get()).emitEffectParticle();
            int ringPoints = 32;
            int tickCount = this.getParticleAnimationTick();
            for (int i = 0; i < ringPoints; ++i) {
                double radius = 0.5 * (double)tickCount;
                double angle = Math.PI * 2 * (double)i / (double)ringPoints;
                double x = this.m_20208_(0.8) + radius * Math.cos(angle);
                double y = this.m_20187_() + 0.5;
                double z = this.m_20262_(0.8) + radius * Math.sin(angle);
                this.m_9236_().m_6493_((ParticleOptions)particle, true, x, y, z, 0.0, 0.0, 0.0);
            }
        }
        if (event == 4) {
            for (int i = 0; i < 32; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.2;
                double d1 = this.f_19796_.m_188583_() * 0.2;
                double d2 = this.f_19796_.m_188583_() * 0.2;
                this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123767_, true, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
        } else {
            super.m_7822_(event);
        }
    }

    public InteractionResult pickupSlime(Player player) {
        ItemStack slimeItem = new ItemStack((ItemLike)ModElements.Items.SLIME_ITEM.get());
        CompoundTag nbt = new CompoundTag();
        CompoundTag entity = new CompoundTag();
        CompoundTag id = new CompoundTag();
        id.m_128359_(ID, this.getSlimeBreed());
        nbt.m_128365_(SLIME, (Tag)id);
        entity.m_128359_("entity", EntityType.m_20613_((EntityType)this.m_6095_()).toString());
        if (this.m_8077_()) {
            entity.m_128359_("name", this.m_7770_().getString());
        } else {
            entity.m_128359_("name", this.m_7755_().getString());
        }
        this.m_20240_(entity);
        nbt.m_128365_("entity", (Tag)entity);
        nbt.m_128405_("Happiness", this.getHappiness());
        nbt.m_128405_("LastAte", this.getLastAte());
        nbt.m_128405_("EatingCooldown", this.getEatingCooldown());
        if (this.getOwnerUUID() != null) {
            nbt.m_128362_("Owner", this.getOwnerUUID());
        }
        nbt.m_128405_("TargetEntity", this.getEatingCooldown());
        slimeItem.m_41751_(nbt);
        this.m_5496_(SoundEvents.f_11752_, 1.0f, 0.9f);
        if (!player.m_150109_().m_36054_(slimeItem)) {
            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), slimeItem);
            itemEntity.m_32010_(0);
            itemEntity.m_20256_(itemEntity.m_20184_().m_82542_(0.0, 1.0, 0.0));
            this.m_9236_().m_7967_((Entity)itemEntity);
        } else {
            player.m_150109_().m_36054_(slimeItem);
        }
        this.m_146870_();
        return InteractionResult.m_19078_((boolean)true);
    }

    public EntityType<SlimeEntityBase> getEntityType() {
        return this.entityType;
    }

    public boolean m_21531_() {
        return true;
    }

    private boolean notHungry() {
        return this.getEatingCooldown() > SLIME_HUNGRY_THRESHOLD;
    }

    public boolean checkFoods(ItemStack pStack, List<Object> foods) {
        Item pickUpItem = pStack.m_41720_();
        for (Object food : foods) {
            if (food.getClass() == ItemStack.class && ((ItemStack)food).m_41720_() == pickUpItem) {
                return true;
            }
            if (food.getClass() != TagKey.class || !pStack.m_204117_((TagKey)food)) continue;
            return true;
        }
        return false;
    }

    public boolean isPrimaryFood(ItemStack food) {
        SlimeBreed slime = (SlimeBreed)this.getSlime().get();
        return this.checkFoods(food, slime.foods());
    }

    public boolean m_7243_(ItemStack pStack) {
        CompoundTag plortTag;
        Item pickUpItem = pStack.m_41720_();
        if (this.notHungry() && pickUpItem != ModElements.Items.PLORT.get()) {
            return false;
        }
        if (pickUpItem == ModElements.Items.SLIME_CANDY.get()) {
            return true;
        }
        if (!this.getSlime().isBound()) {
            return false;
        }
        if (pickUpItem instanceof SpawnEggItem) {
            return false;
        }
        SlimeBreed slime = (SlimeBreed)this.getSlime().get();
        if (pickUpItem == ModElements.Items.PLORT.get() && pStack.m_41782_() && !this.hasTrait("largoless") && (plortTag = pStack.m_41737_("plort")) != null && plortTag.m_128441_(ID)) {
            String id = plortTag.m_128423_(ID).toString();
            if (SlimeData.plortIsFromLargoless(id)) {
                return false;
            }
            return !id.contains(this.getSlimeBreed()) && (this.getSlimeSecondaryBreed().isEmpty() || !id.contains(this.getSlimeSecondaryBreed()));
        }
        if (pStack == slime.favoriteFood()) {
            return true;
        }
        if (this.checkFoods(pStack, slime.foods())) {
            return true;
        }
        if (this.getSecondarySlime().isBound()) {
            SlimeBreed secondarySlime = (SlimeBreed)this.getSecondarySlime().get();
            if (pStack == secondarySlime.favoriteFood()) {
                return true;
            }
            return this.checkFoods(pStack, secondarySlime.foods());
        }
        return false;
    }

    public boolean isOwnerOnline() {
        if (!this.getTamed()) {
            return true;
        }
        return this.m_9236_().m_46003_(this.getOwnerUUID()) != null;
    }

    public ItemStack getSlimePlort() {
        return this.getSlimePlort(false);
    }

    public ItemStack getSlimePlort(Boolean secondary) {
        ItemStack plort = new ItemStack((ItemLike)ModElements.Items.PLORT.get());
        if (secondary.booleanValue()) {
            plort.m_41698_("plort").m_128359_(ID, this.getSlimeSecondaryBreed());
        } else {
            plort.m_41698_("plort").m_128359_(ID, this.getSlimeBreed());
        }
        return plort;
    }

    public List<EntityType<? extends LivingEntity>> getEdibleMobs() {
        DynamicHolder<SlimeBreed> slime = this.getSlime();
        if (!slime.isBound()) {
            return null;
        }
        DynamicHolder<SlimeBreed> secondarySlime = this.getSecondarySlime();
        if (secondarySlime.isBound()) {
            ArrayList<EntityType<? extends LivingEntity>> edibleMobs = new ArrayList<EntityType<? extends LivingEntity>>();
            edibleMobs.addAll(((SlimeBreed)slime.get()).entities());
            edibleMobs.addAll(((SlimeBreed)secondarySlime.get()).entities());
            return edibleMobs;
        }
        return ((SlimeBreed)slime.get()).entities();
    }

    public List<EntityType<? extends LivingEntity>> getHostileToMobs() {
        DynamicHolder<SlimeBreed> slime = this.getSlime();
        if (!slime.isBound()) {
            return null;
        }
        DynamicHolder<SlimeBreed> secondarySlime = this.getSecondarySlime();
        if (secondarySlime.isBound()) {
            ArrayList<EntityType<? extends LivingEntity>> hostileTo = new ArrayList<EntityType<? extends LivingEntity>>();
            hostileTo.addAll(((SlimeBreed)slime.get()).hostileToEntities());
            hostileTo.addAll(((SlimeBreed)secondarySlime.get()).hostileToEntities());
            return hostileTo;
        }
        return ((SlimeBreed)slime.get()).hostileToEntities();
    }

    public Boolean hasSameBreed(LivingEntity livingEntity) {
        if (livingEntity.m_6095_() == this.m_6095_()) {
            SynchedEntityData entityData = livingEntity.m_20088_();
            if (((String)entityData.m_135370_(BREED)).equals(this.getSlimeBreed())) {
                return true;
            }
            return ((String)entityData.m_135370_(SECONDARY_BREED)).equals(this.getSlimeBreed());
        }
        return false;
    }

    public boolean isFavoriteFood(Item item) {
        DynamicHolder<SlimeBreed> slime = this.getSlime();
        if (!slime.isBound()) {
            return false;
        }
        boolean favorite = item == ((SlimeBreed)slime.get()).favoriteFood().m_41720_();
        DynamicHolder<SlimeBreed> secondarySlime = this.getSecondarySlime();
        if (!favorite && secondarySlime.isBound()) {
            favorite = item == ((SlimeBreed)secondarySlime.get()).favoriteFood().m_41720_();
        }
        return favorite;
    }

    public boolean getFavoriteEntity(EntityType<? extends LivingEntity> entityType) {
        DynamicHolder<SlimeBreed> slime = this.getSlime();
        if (!slime.isBound()) {
            return false;
        }
        boolean favorite = entityType == ((SlimeBreed)slime.get()).favoriteEntity();
        DynamicHolder<SlimeBreed> secondarySlime = this.getSecondarySlime();
        if (!favorite && secondarySlime.isBound()) {
            favorite = entityType == ((SlimeBreed)secondarySlime.get()).favoriteEntity();
        }
        return favorite;
    }

    public void setTarred() {
        this.tarred = true;
    }

    public boolean getTarred() {
        return this.tarred;
    }

    public void setItemTarget(ItemEntity entity) {
        this.itemTarget = entity;
    }

    public ItemEntity getItemTarget() {
        return this.itemTarget;
    }

    public int getHappiness() {
        return (Integer)this.f_19804_.m_135370_(HAPPINESS);
    }

    public void addHappiness(int data) {
        if (this.hasTrait("moody")) {
            this.setHappiness(this.getHappiness() + data * 2);
        } else {
            this.setHappiness(this.getHappiness() + data);
        }
    }

    public void setHappiness(int data) {
        this.f_19804_.m_135381_(HAPPINESS, (Object)data);
    }

    public String getTargetEntity() {
        return (String)this.f_19804_.m_135370_(TARGET_ENTITY);
    }

    public void setTargetEntity(String data) {
        this.f_19804_.m_135381_(TARGET_ENTITY, (Object)data);
    }

    public int getEatingCooldown() {
        return (Integer)this.f_19804_.m_135370_(EATING_COOLDOWN);
    }

    public void setEatingCooldown(int data) {
        this.f_19804_.m_135381_(EATING_COOLDOWN, (Object)data);
    }

    public int getParticleAnimationTick() {
        return (Integer)this.f_19804_.m_135370_(PARTICLE_ANIMATION_TICK);
    }

    public int getLastAte() {
        return (Integer)this.f_19804_.m_135370_(LAST_ATE);
    }

    public void setLastAte(int data) {
        this.f_19804_.m_135381_(LAST_ATE, (Object)data);
    }

    public void setParticleAnimationTick(int data) {
        this.f_19804_.m_135381_(PARTICLE_ANIMATION_TICK, (Object)data);
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    public boolean getTamed() {
        return (Boolean)this.f_19804_.m_135370_(TAMED);
    }

    public void setTamed(boolean tamed) {
        this.f_19804_.m_135381_(TAMED, (Object)tamed);
    }

    public boolean m_6673_(DamageSource pSource) {
        if (pSource.m_276093_(DamageTypes.f_268565_) || pSource.m_276093_(DamageTypes.f_268448_)) {
            return true;
        }
        if ((pSource.m_276093_(DamageTypes.f_268468_) || pSource.m_276093_(DamageTypes.f_268631_)) && (this.hasTrait("flaming") || this.hasTrait("aquatic"))) {
            return true;
        }
        return super.m_6673_(pSource);
    }

    public boolean hasTrait(String trait) {
        DynamicHolder<SlimeBreed> slime = this.getSlime();
        DynamicHolder<SlimeBreed> secondarySlime = this.getSecondarySlime();
        if (slime.isBound()) {
            List<String> traits = ((SlimeBreed)slime.get()).traits();
            if (traits.contains(trait)) {
                return true;
            }
            if (secondarySlime.isBound()) {
                List<String> secondarySlimeTraits = ((SlimeBreed)secondarySlime.get()).traits();
                return secondarySlimeTraits.contains(trait);
            }
        }
        return false;
    }

    public void m_7334_(Entity pEntity) {
        super.m_7334_(pEntity);
        if (!(!this.hasTrait("flaming") || pEntity instanceof SplendidSlime && ((SplendidSlime)pEntity).hasTrait("flaming"))) {
            pEntity.m_20254_(3);
        }
        if (this.notHungry()) {
            return;
        }
        List<EntityType<? extends LivingEntity>> edibleMobs = this.getEdibleMobs();
        if (edibleMobs == null) {
            return;
        }
        for (EntityType<? extends LivingEntity> mobType : edibleMobs) {
            if (pEntity.m_6095_() != mobType) continue;
            this.m_33637_((LivingEntity)pEntity);
            SlimeUtils.applyNegativeEffects(this, (LivingEntity)pEntity, false);
        }
    }

    public boolean m_214076_(ServerLevel pLevel, LivingEntity pEntity) {
        if (this.notHungry()) {
            return true;
        }
        List<EntityType<? extends LivingEntity>> edibleMobs = this.getEdibleMobs();
        if (edibleMobs == null) {
            return true;
        }
        for (EntityType<? extends LivingEntity> mobType : edibleMobs) {
            if (pEntity.m_6095_() != mobType) continue;
            this.handleFeed(this.getFavoriteEntity((EntityType<? extends LivingEntity>)pEntity.m_6095_()), null);
        }
        return true;
    }

    public void m_6123_(Player pEntity) {
        if (pEntity.m_21055_((Item)ModElements.Items.SLIME_VAC.get()) && pEntity.m_6047_() && this.getSlimeSecondaryBreed().isEmpty()) {
            this.pickupSlime(pEntity);
        }
        if (this.m_7483_() && (this.getHappiness() <= FURIOUS_THRESHOLD || this.hasTrait("spiky") || this.hasTrait("feral"))) {
            SlimeUtils.applyNegativeEffects(this, (LivingEntity)pEntity, false);
            super.m_6123_(pEntity);
        }
        if (this.m_7483_() && this.hasTrait("flaming")) {
            pEntity.m_20254_(3);
        }
    }

    private void handleSlimeCandy() {
        int happiness = this.getHappiness();
        int newHappiness = happiness < FURIOUS_THRESHOLD ? UNHAPPY_THRESHOLD : (happiness < UNHAPPY_THRESHOLD ? HAPPY_THRESHOLD : MAX_HAPPINESS);
        this.setHappiness(newHappiness);
    }

    public void handleFeed(boolean isFavorite, ItemStack food) {
        int nearbyFriends;
        double d2;
        double d1;
        int i;
        int happiness = this.getHappiness();
        int happinessIncrease = isFavorite ? 50 : 25;
        boolean displayAngerParticles = false;
        if (food != null && food.m_150930_((Item)ModElements.Items.SLIME_CANDY.get())) {
            this.handleSlimeCandy();
            for (i = 0; i < 8; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.04;
                d1 = this.f_19796_.m_188583_() * 0.04;
                d2 = this.f_19796_.m_188583_() * 0.04;
                this.m_20194_().m_129880_(this.m_9236_().m_46472_()).m_8767_((ParticleOptions)ParticleTypes.f_123758_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 1, d0, d1, d2, 0.2);
            }
        }
        if (happiness > FURIOUS_THRESHOLD) {
            ItemStack dropOne = this.getSlimePlort();
            int size = this.m_33632_();
            if (size >= 2) {
                if (isFavorite) {
                    dropOne.m_41764_(2);
                }
                this.m_19983_(dropOne);
                if (!this.getSlimeSecondaryBreed().isEmpty()) {
                    ItemStack dropTwo = this.getSlimePlort(true);
                    if (isFavorite) {
                        dropTwo.m_41764_(2);
                    }
                    this.m_19983_(dropTwo);
                    if (size == 2) {
                        this.m_7839_(size + 1, true);
                    }
                }
            } else {
                this.m_7839_(size + 1, true);
            }
        }
        if (!this.getTamed()) {
            Player closestPlayer = null;
            List nearbyPlayers = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(18.0));
            if (!nearbyPlayers.isEmpty()) {
                for (Player player : nearbyPlayers) {
                    if (closestPlayer == null) {
                        closestPlayer = player;
                        continue;
                    }
                    if (!(player.m_20270_((Entity)this) < closestPlayer.m_20270_((Entity)this))) continue;
                    closestPlayer = player;
                }
                this.setOwnerUUID(closestPlayer.m_20148_());
                this.setTamed(true);
                this.m_21530_();
            }
        }
        if (isFavorite) {
            for (i = 0; i < 4; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                d1 = this.f_19796_.m_188583_() * 0.02;
                d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_20194_().m_129880_(this.m_9236_().m_46472_()).m_8767_((ParticleOptions)ParticleTypes.f_123758_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 1, d0, d1, d2, 0.2);
            }
        }
        if ((nearbyFriends = this.m_9236_().m_6443_(SplendidSlime.class, this.m_20191_().m_82400_(7.0), e -> Objects.equals(e.getSlimeBreed(), this.getSlimeBreed()) || Objects.equals(e.getSlimeSecondaryBreed(), this.getSlimeSecondaryBreed())).size()) >= 3) {
            happinessIncrease += 15;
        }
        if (nearbyFriends > 5) {
            happinessIncrease += 15;
        }
        if (nearbyFriends > 8) {
            happinessIncrease -= 120;
            displayAngerParticles = true;
        }
        if (this.hasTrait("photosynthesizing") && !this.m_9236_().m_46861_(this.m_20097_())) {
            displayAngerParticles = true;
            this.addHappiness(-40);
        }
        if (this.hasTrait("picky") && this.isLargo() && food != null) {
            boolean isPrimary = this.isPrimaryFood(food);
            if (this.getLastAte() == 0 && isPrimary || this.getLastAte() == 1 && !isPrimary) {
                displayAngerParticles = true;
                happinessIncrease = -60;
            } else if (this.getLastAte() == 1) {
                this.setLastAte(0);
            } else {
                this.setLastAte(1);
            }
        }
        if (displayAngerParticles) {
            for (int i2 = 0; i2 < 4; ++i2) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d12 = this.f_19796_.m_188583_() * 0.02;
                double d22 = this.f_19796_.m_188583_() * 0.02;
                this.m_20194_().m_129880_(this.m_9236_().m_46472_()).m_8767_((ParticleOptions)ParticleTypes.f_123792_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 1, d0, d12, d22, 0.2);
            }
        }
        this.m_5634_(2.0f);
        this.m_5496_(SoundEvents.f_11752_, 1.0f, 0.9f);
        this.addHappiness(happinessIncrease);
        this.setEatingCooldown(SLIME_STARVING_COOLDOWN);
    }

    @Nullable
    public ItemStack m_142340_() {
        ItemStack spawnEggStack = ((SlimeSpawnEggItem)((Object)ModElements.Items.SPLENDID_SLIME_SPAWN_EGG.get())).m_7968_();
        spawnEggStack.m_41698_("EntityTag").m_128359_("Breed", this.getSlimeBreed());
        return spawnEggStack;
    }

    protected ParticleOptions m_6300_() {
        ItemStack particleItem = this.getSlimePlort();
        DynamicHolder<SlimeBreed> slime = this.getSlime();
        if (slime.isBound() && ((SlimeBreed)slime.get()).particle().m_41720_() != Items.f_41852_) {
            particleItem = ((SlimeBreed)slime.get()).particle();
        }
        return new ItemParticleOption(ParticleTypes.f_123752_, particleItem);
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack item = itemEntity.m_32055_();
        boolean atePlort = false;
        if (this.m_7243_(item)) {
            CompoundTag plortTag;
            if (this.getHappiness() > FURIOUS_THRESHOLD && item.m_41720_() == ModElements.Items.PLORT.get() && item.m_41782_() && (plortTag = item.m_41737_("plort")) != null && plortTag.m_128441_(ID)) {
                atePlort = true;
                if (this.getSlimeSecondaryBreed().isEmpty()) {
                    if (this.m_33632_() < 4) {
                        this.m_7839_(this.m_33632_() + 1, false);
                    }
                    this.m_5496_(SoundEvents.f_144049_, 1.0f, 0.9f);
                    this.setSlimeSecondaryBreed(plortTag.m_128423_(ID).toString().replace("\"", ""));
                    DynamicHolder<SlimeBreed> secondaryBreed = this.getSecondarySlime();
                    if (secondaryBreed.isBound()) {
                        SlimeUtils.applyEffects(this, (LivingEntity)this, ((SlimeBreed)secondaryBreed.get()).innateEffects(), false);
                    }
                } else {
                    this.causeChaos();
                }
            }
            if (!atePlort) {
                this.handleFeed(this.isFavoriteFood(item.m_41720_()), item);
            }
            item.m_41764_(item.m_41613_() - 1);
            itemEntity.m_32045_(item);
        }
    }

    public void causeChaos() {
        this.setTarred();
        this.m_6074_();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.hasTrait("defiant")) {
            if (pSource.m_276093_(DamageTypes.f_286979_)) {
                return super.m_6469_(pSource, pAmount);
            }
            if (pAmount <= 1.0f) {
                return super.m_6469_(pSource, pAmount);
            }
            double chance = 1.0f - this.m_21223_() / pAmount;
            if ((double)this.f_19796_.m_188501_() < chance) {
                this.m_5496_(SoundEvents.f_12513_, 0.4f, 1.1f);
                this.m_5634_(pAmount);
                this.m_9236_().m_7605_((Entity)this, (byte)4);
                return false;
            }
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack;
        ItemStack itemstack1;
        if (!pPlayer.m_21205_().m_41619_() && this.hasTrait("handy") && !(itemstack1 = this.m_255207_((itemstack = pPlayer.m_21205_()).m_41777_())).m_41619_()) {
            itemstack.m_41774_(itemstack1.m_41613_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        int size = this.m_33632_();
        if (!this.m_9236_().f_46443_ && this.m_21224_()) {
            if (!SlimyConfig.enableTarrs || !this.getTarred()) {
                if (size > 1) {
                    Component component = this.m_7770_();
                    boolean flag = this.m_21525_();
                    SplendidSlime slime = (SplendidSlime)this.m_6095_().m_20615_(this.m_9236_());
                    if (slime != null) {
                        if (this.m_21532_()) {
                            slime.m_21530_();
                        }
                        String secondaryBreed = this.getSlimeSecondaryBreed();
                        slime.setSlimeBreed(this.getSlimeBreed());
                        if (!secondaryBreed.isEmpty()) {
                            slime.setSlimeSecondaryBreed(secondaryBreed);
                        }
                        slime.m_6593_(component);
                        slime.m_21557_(flag);
                        slime.m_20331_(this.m_20147_());
                        slime.m_7839_(size - 1, true);
                        slime.setOwnerUUID(this.getOwnerUUID());
                        slime.setTamed(this.getTamed());
                        slime.setHappiness(this.getHappiness() - 100);
                        slime.setEatingCooldown(this.getEatingCooldown());
                        slime.m_7678_(this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), this.f_19796_.m_188501_() * 360.0f, 0.0f);
                        this.m_9236_().m_7967_((Entity)slime);
                    }
                }
            } else {
                Component component = this.m_7770_();
                int victimSize = this.m_33632_();
                if (victimSize > 0) {
                    --victimSize;
                }
                SlimeEntityBase tarr = (SlimeEntityBase)((EntityType)ModElements.Entities.TARR.get()).m_20615_(this.m_9236_());
                tarr.m_6593_(component);
                tarr.m_20331_(this.m_20147_());
                tarr.m_7839_(victimSize, true);
                tarr.m_7678_(this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), this.f_19796_.m_188501_() * 360.0f, 0.0f);
                this.m_9236_().m_7967_((Entity)tarr);
            }
        }
        this.m_142467_(pReason);
        this.invalidateCaps();
        this.f_20939_.m_276084_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAPPINESS, (Object)500);
        this.f_19804_.m_135372_(LAST_ATE, (Object)0);
        this.f_19804_.m_135372_(EATING_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(TARGET_ENTITY, (Object)"");
        this.f_19804_.m_135372_(PARTICLE_ANIMATION_TICK, (Object)-1);
        this.f_19804_.m_135372_(TAMED, (Object)false);
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
    }

    @Override
    public void m_7378_(@Nonnull CompoundTag nbt) {
        UUID uuid;
        String secondaryBreed = nbt.m_128461_("SecondaryBreed");
        if (this.hasTrait("largoless")) {
            this.setSlimeSecondaryBreed("");
        }
        if (!secondaryBreed.isEmpty() && SlimeData.plortIsFromLargoless(secondaryBreed)) {
            this.setSlimeSecondaryBreed("");
        }
        this.setEatingCooldown(nbt.m_128451_("EatingCooldown"));
        this.setLastAte(nbt.m_128451_("LastAte"));
        this.setHappiness(nbt.m_128451_("Happiness"));
        this.setTargetEntity(nbt.m_128461_("TargetEntity"));
        this.setParticleAnimationTick(nbt.m_128451_("ParticleAnimationTick"));
        if (nbt.m_128403_("Owner")) {
            uuid = nbt.m_128342_("Owner");
        } else {
            String s = nbt.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
                this.setTamed(true);
            }
            catch (Throwable throwable) {
                this.setTamed(false);
            }
        }
        super.m_7378_(nbt);
    }

    @Override
    public void m_7380_(@Nonnull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("EatingCooldown", this.getEatingCooldown());
        nbt.m_128405_("LastAte", this.getLastAte());
        nbt.m_128405_("Happiness", this.getHappiness());
        nbt.m_128359_("TargetEntity", this.getTargetEntity());
        nbt.m_128405_("ParticleAnimationTick", this.getParticleAnimationTick());
        if (this.getOwnerUUID() != null) {
            nbt.m_128362_("Owner", this.getOwnerUUID());
        }
        nbt.m_128379_("Tamed", this.getTamed());
    }

    static class SlimeMoveControl
    extends MoveControl {
        private float yRot;
        private int jumpDelay;
        private final SplendidSlime slime;
        private boolean isAggressive;

        public SlimeMoveControl(SplendidSlime pSlime) {
            super((Mob)pSlime);
            this.slime = pSlime;
            this.yRot = 180.0f * pSlime.m_146908_() / (float)Math.PI;
        }

        public void setDirection(float pYRot, boolean pAggressive) {
            this.yRot = pYRot;
            this.isAggressive = pAggressive;
        }

        public void setWantedMovement(double pSpeed) {
            this.f_24978_ = pSpeed;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.f_24974_.m_20096_()) {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.m_217043_().m_188503_(20) + 10;
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.m_21569_().m_24901_();
                    } else {
                        this.slime.f_20900_ = 0.0f;
                        this.slime.f_20902_ = 0.0f;
                        this.f_24974_.m_7910_(0.0f);
                    }
                } else {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                }
            }
        }
    }

    static class SlimeFloatGoal
    extends Goal {
        private final SplendidSlime slime;

        public SlimeFloatGoal(SplendidSlime pSlime) {
            this.slime = pSlime;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            pSlime.m_21573_().m_7008_(true);
        }

        public boolean m_8036_() {
            return this.slime.m_21573_().m_26576_() && (this.slime.m_20069_() || this.slime.m_20077_()) && this.slime.m_21566_() instanceof SlimeMoveControl;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.slime.m_21573_().m_26576_()) {
                MoveControl movecontrol;
                if (this.slime.m_217043_().m_188501_() < 0.8f) {
                    this.slime.m_21569_().m_24901_();
                }
                if ((movecontrol = this.slime.m_21566_()) instanceof SlimeMoveControl) {
                    SlimeMoveControl slime$slimemovecontrol = (SlimeMoveControl)movecontrol;
                    slime$slimemovecontrol.setWantedMovement(1.2);
                }
                if (this.slime.f_19797_ % 40 == 0 && this.slime.hasTrait("aquatic")) {
                    this.slime.m_21573_().m_7008_(false);
                }
            }
        }
    }

    static class SlimeTargetItemGoal
    extends Goal {
        private final SplendidSlime slime;
        private ItemEntity targetItem;
        protected final int randomInterval;

        public SlimeTargetItemGoal(SplendidSlime slime, int pRandomInterval) {
            this.slime = slime;
            this.randomInterval = SlimeTargetItemGoal.m_186073_((int)pRandomInterval);
        }

        protected void findTarget() {
            List nearbyItems = this.slime.m_9236_().m_45976_(ItemEntity.class, this.slime.m_20191_().m_82400_(10.0));
            if (nearbyItems.isEmpty()) {
                return;
            }
            ItemEntity target = null;
            for (ItemEntity potentialTarget : nearbyItems) {
                if (target != null && !(this.slime.m_20280_((Entity)potentialTarget) < this.slime.m_20280_((Entity)target)) || !this.slime.m_7243_(potentialTarget.m_32055_())) continue;
                target = potentialTarget;
            }
            this.targetItem = target;
            this.slime.setItemTarget(target);
        }

        public void m_8037_() {
            if (this.targetItem != null) {
                this.slime.m_21391_((Entity)this.targetItem, 10.0f, 10.0f);
                MoveControl movecontrol = this.slime.m_21566_();
                if (movecontrol instanceof SlimeMoveControl) {
                    SlimeMoveControl slime$slimemovecontrol = (SlimeMoveControl)movecontrol;
                    slime$slimemovecontrol.setDirection(this.slime.m_146908_(), true);
                }
            }
        }

        public boolean m_8045_() {
            if (!this.targetItem.m_6084_()) {
                this.targetItem = null;
            }
            if (this.slime.notHungry()) {
                this.targetItem = null;
                return false;
            }
            return this.targetItem != null && this.targetItem.m_6084_();
        }

        public boolean m_8036_() {
            if (this.slime.notHungry()) {
                return false;
            }
            if (this.randomInterval > 0 && this.slime.m_217043_().m_188503_(this.randomInterval) != 0) {
                return false;
            }
            this.findTarget();
            return this.targetItem != null;
        }

        public void m_8056_() {
            if (this.slime.hasTrait("foodporting")) {
                this.slime.m_6034_(this.targetItem.m_20185_(), this.targetItem.m_20186_(), this.targetItem.m_20189_());
                this.slime.m_5496_(SoundEvents.f_12418_, 1.0f, 1.0f);
            }
            super.m_8056_();
        }

        public void m_8041_() {
            this.slime.setItemTarget(null);
            this.targetItem = null;
        }
    }

    public class SlimeAttackEntities<T extends LivingEntity>
    extends TargetGoal {
        protected LivingEntity target;
        protected TargetingConditions targetConditions;
        protected final int randomInterval;

        public SlimeAttackEntities(Mob pMob, boolean pMustSee, @Nullable int pRandomInterval, Predicate<LivingEntity> pTargetPredicate) {
            super(pMob, pMustSee);
            this.randomInterval = SlimeAttackEntities.m_186073_((int)pRandomInterval);
            this.targetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(pTargetPredicate);
        }

        protected void findTarget() {
            List<EntityType<? extends LivingEntity>> edibleMobs = SplendidSlime.this.getEdibleMobs();
            List<EntityType<? extends LivingEntity>> hostileToMobs = SplendidSlime.this.getHostileToMobs();
            if (edibleMobs == null && hostileToMobs == null) {
                return;
            }
            List<EntityType<? extends LivingEntity>> finalHostileToMobs = hostileToMobs;
            List nearbyEntities = this.f_26135_.m_9236_().m_6443_(LivingEntity.class, this.f_26135_.m_20191_().m_82400_(10.0), e -> !SplendidSlime.this.notHungry() && edibleMobs.contains(e.m_6095_()) || finalHostileToMobs.contains(e.m_6095_()) || SplendidSlime.this.hasTrait("feral") && e.m_6095_() == EntityType.f_20532_ || ((SplendidSlime)this.f_26135_).getHappiness() < FURIOUS_THRESHOLD && e.m_6095_() == EntityType.f_20532_);
            if (!nearbyEntities.isEmpty()) {
                LivingEntity targetEntity = (LivingEntity)nearbyEntities.get(0);
                for (LivingEntity potentialTarget : nearbyEntities) {
                    if (!(this.f_26135_.m_20280_((Entity)potentialTarget) < this.f_26135_.m_20280_((Entity)targetEntity))) continue;
                    targetEntity = potentialTarget;
                }
                if (hostileToMobs.contains(targetEntity.m_6095_())) {
                    SplendidSlime.this.setTargetEntity(targetEntity.m_20148_().toString());
                }
                this.target = targetEntity;
            }
        }

        public boolean m_8036_() {
            if (SplendidSlime.this.notHungry() && SplendidSlime.this.getHostileToMobs().isEmpty()) {
                return false;
            }
            if (this.randomInterval > 0 && this.f_26135_.m_217043_().m_188503_(this.randomInterval) != 0) {
                return false;
            }
            this.findTarget();
            return this.target != null;
        }

        public void m_8037_() {
            if (this.f_26135_.f_19797_ % 600 == 0 && !SplendidSlime.this.getTargetEntity().equals("")) {
                SlimeUtils.executeSlimeCommands((SplendidSlime)this.f_26135_, false, true);
            }
        }

        public void m_8056_() {
            if (((SplendidSlime)this.f_26135_).hasTrait("foodporting")) {
                this.f_26135_.m_6034_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
                this.f_26135_.m_5496_(SoundEvents.f_12418_, 1.0f, 1.0f);
            }
            this.f_26135_.m_6710_(this.target);
            super.m_8056_();
        }

        public void m_8041_() {
            this.f_26135_.m_6710_((LivingEntity)null);
            SplendidSlime.this.setTargetEntity("");
            this.f_26137_ = null;
        }
    }

    static class SlimeAttackGoal
    extends Goal {
        private final SplendidSlime slime;
        private int growTiredTimer;

        public SlimeAttackGoal(SplendidSlime pSlime) {
            this.slime = pSlime;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity == null) {
                return false;
            }
            return !this.slime.m_6779_(livingentity) ? false : this.slime.m_21566_() instanceof SlimeMoveControl;
        }

        public void m_8056_() {
            this.growTiredTimer = SlimeAttackGoal.m_186073_((int)300);
            super.m_8056_();
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!this.slime.m_6779_(livingentity)) {
                return false;
            }
            return --this.growTiredTimer > 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            MoveControl movecontrol;
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity != null) {
                this.slime.m_21391_((Entity)livingentity, 10.0f, 10.0f);
            }
            if ((movecontrol = this.slime.m_21566_()) instanceof SlimeMoveControl) {
                SlimeMoveControl slime$slimemovecontrol = (SlimeMoveControl)movecontrol;
                slime$slimemovecontrol.setDirection(this.slime.m_146908_(), true);
            }
        }
    }

    static class SlimeRandomDirectionGoal
    extends Goal {
        private final SplendidSlime slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public SlimeRandomDirectionGoal(SplendidSlime pSlime) {
            this.slime = pSlime;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.slime.getItemTarget() == null && this.slime.m_5448_() == null && (this.slime.m_20096_() || this.slime.m_20069_() || this.slime.m_20077_() || this.slime.m_21023_(MobEffects.f_19620_)) && this.slime.m_21566_() instanceof SlimeMoveControl;
        }

        public void m_8037_() {
            MoveControl movecontrol;
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = this.m_183277_(40 + this.slime.m_217043_().m_188503_(60));
                this.chosenDegrees = this.slime.m_217043_().m_188503_(360);
            }
            if ((movecontrol = this.slime.m_21566_()) instanceof SlimeMoveControl) {
                SlimeMoveControl slime$slimemovecontrol = (SlimeMoveControl)movecontrol;
                slime$slimemovecontrol.setDirection(this.chosenDegrees, false);
            }
        }
    }

    static class SlimeKeepOnJumpingGoal
    extends Goal {
        private final SplendidSlime slime;

        public SlimeKeepOnJumpingGoal(SplendidSlime pSlime) {
            this.slime = pSlime;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.slime.m_20159_();
        }

        public void m_8037_() {
            MoveControl movecontrol = this.slime.m_21566_();
            if (movecontrol instanceof SlimeMoveControl) {
                SlimeMoveControl slime$slimemovecontrol = (SlimeMoveControl)movecontrol;
                slime$slimemovecontrol.setWantedMovement(1.0);
            }
        }
    }
}

