/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.table;

import dev.gigaherz.sewingkit.table.SewingTableMenu;
import java.util.EnumMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SewingTableBlock
extends Block {
    private static final Logger LOGGER = LogManager.getLogger();
    public static DirectionProperty FACING = BlockStateProperties.f_61374_;
    private final EnumMap<Direction, VoxelShape> cache = new EnumMap(Direction.class);

    public SewingTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape cuboidWithRotation(Direction facing, double x1, double y1, double z1, double x2, double y2, double z2) {
        switch (facing) {
            case NORTH: {
                return SewingTableBlock.m_49796_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
            }
            case EAST: {
                return SewingTableBlock.m_49796_((double)(16.0 - z2), (double)y1, (double)x1, (double)(16.0 - z1), (double)y2, (double)x2);
            }
            case SOUTH: {
                return SewingTableBlock.m_49796_((double)(16.0 - x2), (double)y1, (double)(16.0 - z2), (double)(16.0 - x1), (double)y2, (double)(16.0 - z1));
            }
            case WEST: {
                return SewingTableBlock.m_49796_((double)z1, (double)y1, (double)(16.0 - x2), (double)z2, (double)y2, (double)(16.0 - x1));
            }
        }
        LOGGER.warn("Sewing Table voxel shape requested for an invalid rotation " + facing + ". This can't happen. The selection/collision shape will be wrong.");
        return SewingTableBlock.m_49796_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    @Nonnull
    private VoxelShape makeTableShape(Direction facing) {
        return Shapes.m_83124_((VoxelShape)this.cuboidWithRotation(facing, 0.0, 14.0, 0.0, 16.0, 16.0, 16.0), (VoxelShape[])new VoxelShape[]{this.cuboidWithRotation(facing, 2.0, 0.0, 2.0, 4.0, 6.0, 4.0), this.cuboidWithRotation(facing, 2.0, 0.0, 12.0, 4.0, 6.0, 14.0), this.cuboidWithRotation(facing, 12.0, 0.0, 2.0, 14.0, 6.0, 4.0), this.cuboidWithRotation(facing, 12.0, 0.0, 12.0, 14.0, 6.0, 14.0), this.cuboidWithRotation(facing, 2.0, 6.0, 2.0, 4.0, 14.0, 14.0), this.cuboidWithRotation(facing, 12.0, 6.0, 2.0, 14.0, 14.0, 14.0), this.cuboidWithRotation(facing, 4.0, 10.0, 10.0, 12.0, 14.0, 12.0)});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return this.cache.computeIfAbsent(facing, this::makeTableShape);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        player.m_5893_((MenuProvider)new SimpleMenuProvider((id, playerInv, p) -> new SewingTableMenu(id, playerInv, ContainerLevelAccess.m_39289_((Level)worldIn, (BlockPos)pos)), (Component)Component.m_237115_((String)"container.sewingkit.sewing_station")));
        return InteractionResult.SUCCESS;
    }
}

