/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.gigaherz.sewingkit.SewingKitMod;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;

public class SewingRecipe
implements Recipe<Container> {
    private final String group;
    private final ResourceLocation id;
    private final NonNullList<Material> materials;
    @Nullable
    private final Ingredient pattern;
    @Nullable
    private final Ingredient tool;
    private final ItemStack output;

    public SewingRecipe(ResourceLocation id, String group, NonNullList<Material> materials, @Nullable Ingredient pattern, @Nullable Ingredient tool, ItemStack output) {
        this.group = group;
        this.id = id;
        this.materials = materials;
        this.pattern = pattern;
        this.tool = tool;
        this.output = output;
    }

    public static Collection<SewingRecipe> getAllRecipes(Level world) {
        return world.m_7465_().m_44013_((RecipeType)SewingKitMod.SEWING.get());
    }

    public String m_6076_() {
        return this.group;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 4;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList allIngredients = NonNullList.m_122779_();
        allIngredients.add((Object)(this.pattern != null ? this.pattern : Ingredient.f_43901_));
        allIngredients.add((Object)(this.tool != null ? this.tool : Ingredient.f_43901_));
        this.materials.stream().map(m -> m.ingredient).forEach(arg_0 -> allIngredients.add(arg_0));
        return allIngredients;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        ItemStack toolStack = inv.m_8020_(0);
        ItemStack patternStack = inv.m_8020_(1);
        Map<Ingredient, Integer> missing = this.materials.stream().collect(Collectors.toMap(i -> i.ingredient, i -> i.count));
        for (int i2 = 0; i2 < 4; ++i2) {
            for (Map.Entry<Ingredient, Integer> mat : missing.entrySet()) {
                Ingredient ing = mat.getKey();
                int value = mat.getValue();
                ItemStack stack = inv.m_8020_(i2 + 2);
                if (!ing.test(stack)) continue;
                int remaining = Math.max(0, value - stack.m_41613_());
                mat.setValue(remaining);
            }
        }
        return missing.values().stream().noneMatch(v -> v > 0) && (this.pattern != null ? patternStack.m_41613_() > 0 && this.pattern.test(patternStack) : patternStack.m_41613_() == 0) && (this.tool != null ? toolStack.m_41613_() > 0 && this.tool.test(toolStack) : toolStack.m_41613_() == 0);
    }

    public ItemStack m_5874_(Container p_44001_, RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess).m_41777_();
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output;
    }

    public ItemStack getResultItem() {
        return this.output;
    }

    public NonNullList<Material> getMaterials() {
        return this.materials;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SewingKitMod.SEWING_RECIPE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)SewingKitMod.SEWING.get();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)SewingKitMod.WOOD_SEWING_NEEDLE.get());
    }

    public Ingredient getTool() {
        return this.tool != null ? this.tool : Ingredient.f_43901_;
    }

    public Ingredient getPattern() {
        return this.pattern != null ? this.pattern : Ingredient.f_43901_;
    }

    public static class Material
    implements Predicate<ItemStack> {
        public final Ingredient ingredient;
        public final int count;

        private Material(Ingredient ingredient, int count) {
            this.ingredient = ingredient;
            this.count = count;
        }

        public static Material of(Ingredient ingredient, int count) {
            return new Material(ingredient, count);
        }

        @Override
        public boolean test(ItemStack itemStack) {
            return this.ingredient.test(itemStack) && itemStack.m_41613_() >= this.count;
        }

        public JsonObject serialize() {
            JsonObject material = new JsonObject();
            material.add("ingredient", this.ingredient.m_43942_());
            material.addProperty("count", (Number)this.count);
            return material;
        }

        public static Material deserialize(JsonObject object) {
            Ingredient ingredient = CraftingHelper.getIngredient((JsonElement)object.get("ingredient"), (boolean)true);
            int count = GsonHelper.m_13824_((JsonObject)object, (String)"count", (int)1);
            if (count <= 0) {
                throw new IllegalArgumentException("Material count must be a positive integer.");
            }
            return new Material(ingredient, count);
        }

        public void write(FriendlyByteBuf packet) {
            packet.m_130130_(this.count);
            this.ingredient.m_43923_(packet);
        }

        public static Material read(FriendlyByteBuf packet) {
            int count = packet.m_130242_();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)packet);
            return new Material(ingredient, count);
        }
    }

    public static class Serializer
    implements RecipeSerializer<SewingRecipe> {
        protected SewingRecipe createRecipe(ResourceLocation recipeId, String group, NonNullList<Material> materials, Ingredient pattern, Ingredient tool, ItemStack result) {
            return new SewingRecipe(recipeId, group, materials, pattern, tool, result);
        }

        public SewingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            JsonArray materialsJson = GsonHelper.m_13933_((JsonObject)json, (String)"materials");
            NonNullList materials = NonNullList.m_122779_();
            for (int i = 0; i < materialsJson.size(); ++i) {
                materials.add((Object)Material.deserialize(materialsJson.get(i).getAsJsonObject()));
            }
            Ingredient pattern = json.has("pattern") ? CraftingHelper.getIngredient((JsonElement)json.get("pattern"), (boolean)true) : null;
            Ingredient tool = json.has("tool") ? CraftingHelper.getIngredient((JsonElement)json.get("tool"), (boolean)true) : null;
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            return this.createRecipe(recipeId, group, (NonNullList<Material>)materials, pattern, tool, result);
        }

        public SewingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            int numMaterials = buffer.m_130242_();
            NonNullList materials = NonNullList.m_122779_();
            for (int i = 0; i < numMaterials; ++i) {
                materials.add((Object)Material.read(buffer));
            }
            boolean hasPattern = buffer.readBoolean();
            Ingredient pattern = hasPattern ? Ingredient.m_43940_((FriendlyByteBuf)buffer) : null;
            boolean hasTool = buffer.readBoolean();
            Ingredient tool = hasTool ? Ingredient.m_43940_((FriendlyByteBuf)buffer) : null;
            ItemStack result = buffer.m_130267_();
            return this.createRecipe(recipeId, group, (NonNullList<Material>)materials, pattern, tool, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, SewingRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130130_(recipe.materials.size());
            for (Material input : recipe.materials) {
                input.write(buffer);
            }
            boolean hasPattern = recipe.pattern != null;
            buffer.writeBoolean(hasPattern);
            if (hasPattern) {
                recipe.pattern.m_43923_(buffer);
            }
            boolean hasTool = recipe.tool != null;
            buffer.writeBoolean(hasTool);
            if (hasTool) {
                recipe.tool.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.output);
        }
    }
}

