/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.generic;

import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.data.Pair;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericKey;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericKeyRegistration;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericKeySerializer;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_abstractions.generic.impl.GenericContentExtender;
import ru.zznty.create_factory_abstractions.generic.key.item.ItemKey;
import ru.zznty.create_factory_logistics.FactoryGenericAttributeTypes;
import ru.zznty.create_factory_logistics.logistics.generic.FluidKey;
import ru.zznty.create_factory_logistics.logistics.generic.GenericAttribute;
import ru.zznty.create_factory_logistics.logistics.generic.GenericAttributeType;

public class FluidGenericAttribute
implements GenericAttribute {
    @Nullable
    protected FluidKey fluid;

    public FluidGenericAttribute(@Nullable FluidKey fluid) {
        this.fluid = fluid;
    }

    @Override
    public boolean appliesTo(GenericStack stack, Level world) {
        if (this.fluid == null) {
            return false;
        }
        GenericKey genericKey = stack.key();
        if (!(genericKey instanceof FluidKey)) {
            return false;
        }
        FluidKey fluidKey = (FluidKey)genericKey;
        return this.fluid.equals(fluidKey);
    }

    public ItemAttributeType getType() {
        return (ItemAttributeType)FactoryGenericAttributeTypes.IS_FLUID.get();
    }

    public void save(CompoundTag nbt) {
        if (this.fluid == null) {
            return;
        }
        ((GenericKeyRegistration)GenericContentExtender.REGISTRATIONS.get(FluidKey.class)).serializer().write((GenericKey)this.fluid, nbt);
    }

    public void load(CompoundTag nbt) {
        GenericKeySerializer serializer = ((GenericKeyRegistration)GenericContentExtender.REGISTRATIONS.get(FluidKey.class)).serializer();
        this.fluid = (FluidKey)serializer.read(nbt);
        if (this.fluid.fluid() == Fluids.f_76191_) {
            this.fluid = null;
        }
    }

    public String getTranslationKey() {
        return "is_fluid";
    }

    public Object[] getTranslationParameters() {
        String parameter = "";
        if (this.fluid != null) {
            FluidType fluidType = this.fluid.fluid().getFluidType();
            parameter = this.fluid.nbt() == null ? fluidType.getDescription().getString() : fluidType.getDescription(this.fluid.stack()).getString();
        }
        return new Object[]{parameter};
    }

    protected static List<FluidKey> extractFluids(GenericStack stack, Level level) {
        GenericKey genericKey = stack.key();
        if (genericKey instanceof FluidKey) {
            FluidKey fluidKey = (FluidKey)genericKey;
            return List.of(fluidKey);
        }
        genericKey = stack.key();
        if (!(genericKey instanceof ItemKey)) {
            return List.of();
        }
        ItemKey itemKey = (ItemKey)genericKey;
        LazyOptional fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemKey.stack());
        if (fluidHandler.isPresent()) {
            ArrayList<FluidKey> attributes = new ArrayList<FluidKey>();
            IFluidHandlerItem handlerItem = (IFluidHandlerItem)fluidHandler.orElse(null);
            for (int i = 0; i < handlerItem.getTanks(); ++i) {
                FluidStack fluidInItem = handlerItem.getFluidInTank(i);
                if (fluidInItem.getRawFluid() == Fluids.f_76191_) continue;
                attributes.add(new FluidKey(fluidInItem.getRawFluid(), fluidInItem.getTag()));
            }
            return attributes;
        }
        Pair emptyResult = GenericItemEmptying.emptyItem((Level)level, (ItemStack)itemKey.stack(), (boolean)true);
        FluidStack resultFluid = (FluidStack)emptyResult.getFirst();
        if (resultFluid.isEmpty()) {
            return List.of();
        }
        return List.of(new FluidKey(resultFluid.getFluid(), resultFluid.getTag()));
    }

    public static class Type
    implements GenericAttributeType {
        @Override
        @NotNull
        public GenericAttribute create() {
            return new FluidGenericAttribute(null);
        }

        @Override
        public List<ItemAttribute> getAllAttributes(GenericStack stack, Level level) {
            return FluidGenericAttribute.extractFluids(stack, level).stream().map(FluidGenericAttribute::new).toList();
        }
    }
}

