/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.registry;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.wildernature.block.entity.BountyBoardBlockEntity;
import net.satisfy.wildernature.block.entity.CompletionistBannerEntity;
import net.satisfy.wildernature.client.gui.handlers.BountyBlockScreenHandler;
import net.satisfy.wildernature.entity.BisonEntity;
import net.satisfy.wildernature.entity.BoarEntity;
import net.satisfy.wildernature.entity.BulletEntity;
import net.satisfy.wildernature.entity.CassowaryEntity;
import net.satisfy.wildernature.entity.DeerEntity;
import net.satisfy.wildernature.entity.DogEntity;
import net.satisfy.wildernature.entity.FlamingoEntity;
import net.satisfy.wildernature.entity.HedgehogEntity;
import net.satisfy.wildernature.entity.MiniSheepEntity;
import net.satisfy.wildernature.entity.OwlEntity;
import net.satisfy.wildernature.entity.PelicanEntity;
import net.satisfy.wildernature.entity.PenguinEntity;
import net.satisfy.wildernature.entity.RaccoonEntity;
import net.satisfy.wildernature.entity.RedWolfEntity;
import net.satisfy.wildernature.entity.SquirrelEntity;
import net.satisfy.wildernature.entity.TurkeyEntity;
import net.satisfy.wildernature.registry.ObjectRegistry;
import net.satisfy.wildernature.util.WilderNatureIdentifier;

public class EntityRegistry {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((String)"wildernature", (ResourceKey)Registries.f_256922_);
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"wildernature", (ResourceKey)Registries.f_256939_);
    public static final RegistrySupplier<BlockEntityType<CompletionistBannerEntity>> COMPLETIONIST_BANNER_ENTITY = EntityRegistry.createBlockEntity("completionist_banner", () -> BlockEntityType.Builder.m_155273_(CompletionistBannerEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.WOLF_TRAPPER_BANNER.get(), (Block)ObjectRegistry.WOLF_TRAPPER_WALL_BANNER.get(), (Block)ObjectRegistry.BUNNY_STALKER_BANNER.get(), (Block)ObjectRegistry.BUNNY_STALKER_WALL_BANNER.get(), (Block)ObjectRegistry.COD_CATCHER_BANNER.get(), (Block)ObjectRegistry.COD_CATCHER_WALL_BANNER.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<BountyBoardBlockEntity>> BOUNTY_BOARD_ENTITY = EntityRegistry.createBlockEntity("bounty_board", () -> BlockEntityType.Builder.m_155273_(BountyBoardBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.BOUNTY_BOARD.get()}).m_58966_(null));
    public static final RegistrySupplier<EntityType<BisonEntity>> BISON = EntityRegistry.createEntity("bison", () -> EntityType.Builder.m_20704_(BisonEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.8f, 2.2f).m_20712_(new WilderNatureIdentifier("bison").toString()));
    public static final RegistrySupplier<EntityType<BoarEntity>> BOAR = EntityRegistry.createEntity("boar", () -> EntityType.Builder.m_20704_(BoarEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.1f, 1.1f).m_20712_(new WilderNatureIdentifier("boar").toString()));
    public static final RegistrySupplier<EntityType<CassowaryEntity>> CASSOWARY = EntityRegistry.createEntity("cassowary", () -> EntityType.Builder.m_20704_(CassowaryEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.8f, 0.8f).m_20702_(10).m_20712_(new WilderNatureIdentifier("cassowary").toString()));
    public static final RegistrySupplier<EntityType<DeerEntity>> DEER = EntityRegistry.createEntity("deer", () -> EntityType.Builder.m_20704_(DeerEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.3f, 1.6f).m_20712_(new WilderNatureIdentifier("deer").toString()));
    public static final RegistrySupplier<EntityType<DogEntity>> DOG = EntityRegistry.createEntity("dog", () -> EntityType.Builder.m_20704_(DogEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.3f).m_20712_(new WilderNatureIdentifier("dog").toString()));
    public static final RegistrySupplier<EntityType<FlamingoEntity>> FLAMINGO = EntityRegistry.createEntity("flamingo", () -> EntityType.Builder.m_20704_(FlamingoEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.0f).m_20702_(10).m_20712_(new WilderNatureIdentifier("flamingo").toString()));
    public static final RegistrySupplier<EntityType<HedgehogEntity>> HEDGEHOG = EntityRegistry.createEntity("hedgehog", () -> EntityType.Builder.m_20704_(HedgehogEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.3f, 0.3f).m_20702_(10).m_20712_(new WilderNatureIdentifier("hedgehog").toString()));
    public static final RegistrySupplier<EntityType<MiniSheepEntity>> MINISHEEP = EntityRegistry.createEntity("minisheep", () -> EntityType.Builder.m_20704_(MiniSheepEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.3f).m_20712_(new WilderNatureIdentifier("minisheep").toString()));
    public static final RegistrySupplier<EntityType<OwlEntity>> OWL = EntityRegistry.createEntity("owl", () -> EntityType.Builder.m_20704_(OwlEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.0f).m_20712_(new WilderNatureIdentifier("owl").toString()));
    public static final RegistrySupplier<EntityType<PelicanEntity>> PELICAN = EntityRegistry.createEntity("pelican", () -> EntityType.Builder.m_20704_(PelicanEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.0f).m_20712_(new WilderNatureIdentifier("pelican").toString()));
    public static final RegistrySupplier<EntityType<PenguinEntity>> PENGUIN = EntityRegistry.createEntity("penguin", () -> EntityType.Builder.m_20704_(PenguinEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.7f, 0.9f).m_20702_(10).m_20712_(new WilderNatureIdentifier("penguin").toString()));
    public static final RegistrySupplier<EntityType<RaccoonEntity>> RACCOON = EntityRegistry.createEntity("raccoon", () -> EntityType.Builder.m_20704_(RaccoonEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 0.6f).m_20712_(new WilderNatureIdentifier("raccoon").toString()));
    public static final RegistrySupplier<EntityType<RedWolfEntity>> RED_WOLF = EntityRegistry.createEntity("red_wolf", () -> EntityType.Builder.m_20704_(RedWolfEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.7f, 0.9f).m_20702_(10).m_20712_(String.valueOf((Object)new WilderNatureIdentifier("red_wolf"))));
    public static final RegistrySupplier<EntityType<SquirrelEntity>> SQUIRREL = EntityRegistry.createEntity("squirrel", () -> EntityType.Builder.m_20704_(SquirrelEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.4f, 0.9f).m_20712_(new WilderNatureIdentifier("squirrel").toString()));
    public static final RegistrySupplier<EntityType<TurkeyEntity>> TURKEY = EntityRegistry.createEntity("turkey", () -> EntityType.Builder.m_20704_(TurkeyEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.0f).m_20712_(new WilderNatureIdentifier("turkey").toString()));
    public static final RegistrySupplier<EntityType<BulletEntity>> BULLET = EntityRegistry.createEntity("bullet", () -> EntityType.Builder.m_20704_(BulletEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.3125f, 0.3125f).m_20702_(64).m_20717_(2).m_20712_(new WilderNatureIdentifier("bullet").toString()));

    public static <T extends EntityType<?>> RegistrySupplier<T> createEntity(String path, Supplier<T> type) {
        return ENTITY_TYPES.register((ResourceLocation)new WilderNatureIdentifier(path), type);
    }

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> createBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITIES.register((ResourceLocation)new WilderNatureIdentifier(path), type);
    }

    public static void init() {
        ENTITY_TYPES.register();
        BLOCK_ENTITIES.register();
        EntityAttributeRegistry.register(BISON, BisonEntity::createMobAttributes);
        EntityAttributeRegistry.register(BOAR, BoarEntity::createMobAttributes);
        EntityAttributeRegistry.register(CASSOWARY, CassowaryEntity::createMobAttributes);
        EntityAttributeRegistry.register(DEER, DeerEntity::createMobAttributes);
        EntityAttributeRegistry.register(DOG, DogEntity::createMobAttributes);
        EntityAttributeRegistry.register(FLAMINGO, FlamingoEntity::createMobAttributes);
        EntityAttributeRegistry.register(HEDGEHOG, HedgehogEntity::createMobAttributes);
        EntityAttributeRegistry.register(MINISHEEP, MiniSheepEntity::createMobAttributes);
        EntityAttributeRegistry.register(OWL, OwlEntity::createMobAttributes);
        EntityAttributeRegistry.register(PELICAN, PelicanEntity::createMobAttributes);
        EntityAttributeRegistry.register(PENGUIN, PenguinEntity::createMobAttributes);
        EntityAttributeRegistry.register(RACCOON, RaccoonEntity::createMobAttributes);
        EntityAttributeRegistry.register(RED_WOLF, RedWolfEntity::createMobAttributes);
        EntityAttributeRegistry.register(SQUIRREL, SquirrelEntity::createMobAttributes);
        EntityAttributeRegistry.register(TURKEY, TurkeyEntity::createMobAttributes);
        BountyBlockScreenHandler.registerMenuTypes();
    }
}

