/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.entity;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.satisfy.wildernature.entity.ai.RandomAction;
import net.satisfy.wildernature.entity.ai.RandomActionGoal;
import net.satisfy.wildernature.entity.animation.ServerAnimationDurations;
import net.satisfy.wildernature.registry.EntityRegistry;
import net.satisfy.wildernature.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HedgehogEntity
extends Animal {
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public AnimationState sniffAnimationState = new AnimationState();
    private static final EntityDataAccessor<Boolean> SNIFFING = SynchedEntityData.m_135353_(HedgehogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public HedgehogEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.13000000417232513).m_22268_(Attributes.f_22276_, 4.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42583_}), true));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.f_21345_.m_25352_(6, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(7, (Goal)new RandomActionGoal(new RandomAction(){

            @Override
            public boolean isInterruptable() {
                return false;
            }

            @Override
            public void onStart() {
                HedgehogEntity.this.setSniffing(true);
            }

            @Override
            public void onStop() {
                HedgehogEntity.this.setSniffing(false);
            }

            @Override
            public boolean isPossible() {
                return true;
            }

            @Override
            public int duration() {
                return (int)(ServerAnimationDurations.hedgehog_sniffing * 20.0f);
            }

            @Override
            public float chance() {
                return 0.005f;
            }

            @Override
            public AttributeInstance getAttribute(Attribute movementSpeed) {
                return HedgehogEntity.this.m_21051_(movementSpeed);
            }
        }));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82377_(0.5, 0.5, 0.5));
            for (Entity entity : entities) {
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                if (!(player.f_19789_ > 1.0f) || !(player.m_20186_() > this.m_20186_() + 1.0)) continue;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                this.m_6074_();
                player.m_6469_(this.m_9236_().m_269111_().m_269264_(), 3.0f);
                break;
            }
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        this.sniffAnimationState.m_246184_(this.isSniffing(), this.f_19797_);
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    private boolean isSniffing() {
        return (Boolean)this.f_19804_.m_135370_(SNIFFING);
    }

    public void setSniffing(boolean sniffing) {
        this.f_19804_.m_135381_(SNIFFING, (Object)sniffing);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)EntityRegistry.HEDGEHOG.get()).m_20615_((Level)serverLevel);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SNIFFING, (Object)false);
    }

    protected void m_267689_(float pPartialTick) {
        super.m_267689_(pPartialTick);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.HEDGEHOG_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.HEDGEHOG_DEATH.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.HEDGEHOG_AMBIENT.get();
    }

    protected float m_6121_() {
        return 0.1f;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_42583_);
    }

    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_150930_(Items.f_42583_)) {
            if (this.m_6898_(itemstack) && this.m_146764_() == 0 && !this.m_9236_().f_46443_) {
                this.m_142075_(player, hand, itemstack);
                this.m_27595_(player);
                return InteractionResult.SUCCESS;
            }
        } else if (itemstack.m_150930_(Items.f_42455_)) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
                player.m_36356_(new ItemStack((ItemLike)Items.f_42446_));
            }
            this.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 240, 1));
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }
}

