/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.entity;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.satisfy.wildernature.entity.ai.AnimationAttackGoal;
import net.satisfy.wildernature.entity.ai.EntityWithAttackAnimation;
import net.satisfy.wildernature.entity.ai.RandomAction;
import net.satisfy.wildernature.entity.ai.RandomActionGoal;
import net.satisfy.wildernature.entity.animation.ServerAnimationDurations;
import net.satisfy.wildernature.registry.EntityRegistry;
import net.satisfy.wildernature.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DogEntity
extends TamableAnimal
implements EntityWithAttackAnimation {
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public AnimationState howlingAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public final AnimationState sitAnimationState = new AnimationState();
    private static final EntityDataAccessor<Boolean> HOWLING = SynchedEntityData.m_135353_(DogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(DogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(DogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final double MOVEMENT_SPEED = 0.23;
    private static final double MAX_HEALTH = 12.0;
    private static final double ATTACK_DAMAGE = 3.0;
    private static final float SOUND_VOLUME = 0.3f;

    public DogEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22281_, 3.0);
    }

    @Nullable
    public DogEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (DogEntity)((EntityType)EntityRegistry.DOG.get()).m_20615_((Level)serverLevel);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new AnimationAttackGoal(this, 1.2f, true, (int)(ServerAnimationDurations.dog_bite * 20.0f), 7));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.15));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.25, 18.0f, 7.0f, false));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42500_}), false));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.f_21345_.m_25352_(6, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(7, (Goal)new GoAfterCatGoal(this));
        this.f_21345_.m_25352_(7, (Goal)this.createRandomActionGoal());
        this.f_21346_.m_25352_(10, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    private RandomActionGoal createRandomActionGoal() {
        return new RandomActionGoal(new RandomAction(){

            @Override
            public boolean isInterruptable() {
                return false;
            }

            @Override
            public void onStart() {
                DogEntity.this.setHowling(true);
            }

            @Override
            public void onStop() {
                DogEntity.this.setHowling(false);
            }

            @Override
            public boolean isPossible() {
                return true;
            }

            @Override
            public void onTick(int tick) {
                if (tick == 20) {
                    DogEntity.this.m_9236_().m_6269_(null, (Entity)DogEntity.this, (SoundEvent)SoundRegistry.DOG_AMBIENT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            }

            @Override
            public int duration() {
                return (int)(ServerAnimationDurations.dog_howl * 20.0f);
            }

            @Override
            public float chance() {
                return 0.005f;
            }

            @Override
            public AttributeInstance getAttribute(Attribute movementSpeed) {
                return DogEntity.this.m_21051_(movementSpeed);
            }
        });
    }

    public void m_8119_() {
        super.m_8119_();
        this.handleSittingState();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    private void handleSittingState() {
        if (!this.m_9236_().m_5776_() && this.m_21824_() && ((Boolean)this.f_19804_.m_135370_(SITTING)).booleanValue() != this.m_21827_()) {
            this.m_21839_((Boolean)this.f_19804_.m_135370_(SITTING));
        }
    }

    private void setupAnimationStates() {
        this.handleIdleAnimation();
        this.howlingAnimationState.m_246184_(this.isHowling(), this.f_19797_);
        this.attackAnimationState.m_246184_(this.isAttacking(), this.f_19797_);
        this.sitAnimationState.m_246184_(this.m_21827_(), this.f_19797_);
    }

    private void handleIdleAnimation() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    private boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    private boolean isHowling() {
        return (Boolean)this.f_19804_.m_135370_(HOWLING);
    }

    public void setHowling(boolean howling) {
        this.f_19804_.m_135381_(HOWLING, (Object)howling);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOWLING, (Object)false);
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(SITTING, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Sitting", this.m_21827_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        boolean sitting = compound.m_128471_("Sitting");
        this.m_21839_(false);
        this.m_21839_(sitting);
        this.f_19804_.m_135381_(SITTING, (Object)sitting);
    }

    public void m_21839_(boolean sitting) {
        super.m_21839_(sitting);
        this.f_19804_.m_135381_(SITTING, (Object)sitting);
    }

    public boolean m_21827_() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    protected void m_267689_(float partialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(partialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.DOG_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.DOG_DEATH.get();
    }

    protected float m_6121_() {
        return 0.3f;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_42500_);
    }

    public boolean m_6573_(Player player) {
        return true;
    }

    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.m_9236_().m_5776_()) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || itemstack.m_150930_(Items.f_42500_) && !this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return this.handleServerSideInteraction(player, itemstack, hand);
    }

    private InteractionResult handleServerSideInteraction(Player player, ItemStack itemstack, InteractionHand hand) {
        if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)player)) {
                if (itemstack.m_150930_(Items.f_42500_)) {
                    return this.handleHealing();
                }
                return this.handleNonBoneInteraction(player);
            }
        } else if (itemstack.m_150930_(Items.f_42500_)) {
            return this.handleTaming(player, itemstack);
        }
        return super.m_6071_(player, hand);
    }

    private InteractionResult handleHealing() {
        if (this.m_21223_() < this.m_21233_()) {
            this.m_5634_(2.0f);
            this.m_146852_(GameEvent.f_223708_, (Entity)this);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    private InteractionResult handleNonBoneInteraction(Player player) {
        InteractionResult interactionresult = super.m_6071_(player, InteractionHand.MAIN_HAND);
        if (!interactionresult.m_19077_() || this.m_6162_()) {
            this.m_21839_(!this.m_21827_());
            this.f_20899_ = false;
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            return InteractionResult.SUCCESS;
        }
        return interactionresult;
    }

    private InteractionResult handleTaming(Player player, ItemStack itemstack) {
        this.m_142075_(player, InteractionHand.MAIN_HAND, itemstack);
        if (this.f_19796_.m_188503_(3) == 0) {
            this.m_21828_(player);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.m_21839_(true);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public LivingEntity getTarget_() {
        return this.m_5448_();
    }

    @Override
    public double getMeleeAttackRangeSqr_(LivingEntity target) {
        return this.m_142593_(target);
    }

    @Override
    public void setAttacking_(boolean b) {
        this.f_19804_.m_135381_(ATTACKING, (Object)b);
    }

    @Override
    public Vec3 getPosition_(int i) {
        return super.m_20318_((float)i);
    }

    @Override
    public void doHurtTarget_(LivingEntity targetEntity) {
        super.m_7327_((Entity)targetEntity);
    }

    public static class GoAfterCatGoal
    extends Goal {
        private final DogEntity dog;
        private List<Cat> catList;
        private int lastCatUpdate = 0;
        private Cat targetCat;
        private static final int CAT_SEARCH_INTERVAL = 20;
        private static final double CAT_DETECTION_RANGE_SQR = 256.0;

        public GoAfterCatGoal(DogEntity dogEntity) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
            this.dog = dogEntity;
        }

        public boolean m_8036_() {
            return !this.getNearbyCats().isEmpty();
        }

        public void m_8056_() {
            super.m_8056_();
            this.updateTargetCat();
        }

        public void m_8037_() {
            super.m_8037_();
            this.updateTargetCat();
            if (this.targetCat != null) {
                this.dog.m_21573_().m_5624_((Entity)this.targetCat, 1.5);
            }
        }

        public boolean m_8045_() {
            return this.targetCat != null && this.targetCat.m_6084_() && this.targetCat.m_20280_((Entity)this.dog) <= 256.0;
        }

        public void m_8041_() {
            this.targetCat = null;
        }

        private List<Cat> getNearbyCats() {
            if (this.catList == null || this.dog.f_19797_ - this.lastCatUpdate >= 20) {
                this.catList = this.dog.m_9236_().m_45971_(Cat.class, TargetingConditions.m_148353_(), (LivingEntity)this.dog, this.dog.m_20191_().m_82400_(16.0));
                this.lastCatUpdate = this.dog.f_19797_;
            }
            return this.catList;
        }

        private void updateTargetCat() {
            if (this.targetCat == null || this.targetCat.m_20280_((Entity)this.dog) > 256.0) {
                double closestDistance = Double.MAX_VALUE;
                Cat closestCat = null;
                for (Cat cat : this.catList) {
                    double distance = cat.m_20280_((Entity)this.dog);
                    if (!(distance < closestDistance)) continue;
                    closestDistance = distance;
                    closestCat = cat;
                }
                this.targetCat = closestCat;
            }
        }
    }
}

