/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.model.entity;

import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.satisfy.wildernature.entity.OwlEntity;
import net.satisfy.wildernature.entity.animation.OwlAnimation;
import net.satisfy.wildernature.util.WilderNatureIdentifier;
import org.jetbrains.annotations.NotNull;

public class OwlModel
extends HierarchicalModel<OwlEntity>
implements HeadedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation((ResourceLocation)new WilderNatureIdentifier("owl"), "main");
    private final ModelPart root;
    private final ModelPart head;

    public OwlModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("root").m_171324_("animroot").m_171324_("head");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)16.8532f, (float)-0.6407f));
        PartDefinition animroot = root.m_171599_("animroot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition torso_r1 = animroot.m_171599_("torso_r1", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171480_().m_171488_(-3.5f, -2.475f, -3.75f, 7.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = animroot.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(5, 38).m_171488_(-7.059f, 4.0f, 3.3f, 7.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.559f, (float)3.2079f, (float)-2.2761f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition tailWing = animroot.m_171599_("tailWing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.6761f, (float)-1.1119f));
        PartDefinition cube_r2 = tailWing.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(-3.5f, -2.5858f, 0.2071f, 7.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.4225f, (float)2.1273f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition wing_right = animroot.m_171599_("wing_right", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.501f, (float)-0.9282f, (float)-2.3335f));
        PartDefinition wing_right_r1 = wing_right.m_171599_("wing_right_r1", CubeListBuilder.m_171558_().m_171514_(14, 9).m_171480_().m_171488_(-0.025f, -0.3609f, -2.4857f, 0.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.074f, (float)0.2394f, (float)0.1449f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition wing_left = animroot.m_171599_("wing_left", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.501f, (float)-0.9282f, (float)-2.3335f));
        PartDefinition wing_left_r1 = wing_left.m_171599_("wing_left_r1", CubeListBuilder.m_171558_().m_171514_(14, 9).m_171488_(0.025f, -0.3609f, -2.4857f, 0.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.074f, (float)0.2394f, (float)0.1449f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition leg_right = animroot.m_171599_("leg_right", CubeListBuilder.m_171558_().m_171514_(23, 4).m_171488_(-1.975f, 2.6133f, -2.7904f, 3.95f, 0.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(27, 4).m_171488_(-0.975f, 0.65f, -0.6f, 1.95f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(20, 0).m_171480_().m_171488_(-1.0f, -0.7354f, -1.0251f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)4.4468f, (float)0.2407f));
        PartDefinition leg_left = animroot.m_171599_("leg_left", CubeListBuilder.m_171558_().m_171514_(23, 4).m_171480_().m_171488_(-1.975f, 2.6133f, -2.7904f, 3.95f, 0.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(27, 4).m_171488_(-0.975f, 0.65f, -0.6f, 1.95f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(20, 0).m_171488_(-1.0f, -0.7354f, -1.0251f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)4.4468f, (float)0.2407f));
        PartDefinition head = animroot.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.525f, -4.25f, -3.0833f, 7.05f, 5.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(6, 11).m_171488_(-3.525f, 0.75f, -3.0833f, 7.05f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 11).m_171480_().m_171488_(-0.5f, -1.25f, -4.0833f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-1.6015f, (float)-1.6284f));
        PartDefinition right_horn_r1 = head.m_171599_("right_horn_r1", CubeListBuilder.m_171558_().m_171514_(0, -1).m_171480_().m_171488_(-1.25f, -2.0f, -1.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)4.4089f, (float)-3.3661f, (float)-2.0833f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition left_horn_r1 = head.m_171599_("left_horn_r1", CubeListBuilder.m_171558_().m_171514_(0, 1).m_171488_(1.25f, -2.0f, -1.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.4089f, (float)-3.3661f, (float)-2.0833f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)48, (int)48);
    }

    public void setupAnim(OwlEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_267799_(OwlAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        if (entity.attackState.m_216984_()) {
            this.m_233381_(entity.attackState, OwlAnimation.attack, ageInTicks);
            return;
        }
        this.m_233381_(entity.flyingState, OwlAnimation.fly, ageInTicks);
        this.m_233381_(entity.hootState, OwlAnimation.hoot, ageInTicks);
        this.m_233381_(entity.sleepState, OwlAnimation.sleep, ageInTicks);
    }

    public void prepareMobModel(OwlEntity entity, float limbAngle, float limbDistance, float delta) {
        super.m_6839_((Entity)entity, limbAngle, limbDistance, delta);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.root;
    }

    @NotNull
    public ModelPart m_5585_() {
        return this.head;
    }
}

