/*
 * Decompiled with CFR 0.152.
 */
package com.cicada.longwings;

import com.cicada.longwings.LongwingsSoundsForge;
import com.cicada.longwings.api.ForgeBiomeHandler;
import com.cicada.longwings.api.ForgeHandbookHandler;
import com.cicada.longwings.api.LongwingsHandler;
import com.cicada.longwings.block.LongwingsBlocksForge;
import com.cicada.longwings.client.LongwingsParticlesForge;
import com.cicada.longwings.client.model.ButterflyModel;
import com.cicada.longwings.client.model.CatchingNetModel;
import com.cicada.longwings.client.model.MothModel;
import com.cicada.longwings.client.renderers.ButterflyEntityRenderer;
import com.cicada.longwings.effect.LongwingsEffectsForge;
import com.cicada.longwings.entity.LongwingsEntityTypes;
import com.cicada.longwings.entity.LongwingsEntityTypesForge;
import com.cicada.longwings.item.LongwingsItemGroup;
import com.cicada.longwings.item.LongwingsItemsForge;
import com.cicada.longwings.networking.LongwingsPackets;
import com.mojang.logging.LogUtils;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="longwings")
public class LongwingsForge {
    private static final Logger LOGGER = LogUtils.getLogger();

    public LongwingsForge() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(LongwingsForge::commonSetup);
        LongwingsSoundsForge.SOUND_EVENT.register(modEventBus);
        LongwingsBlocksForge.BLOCKS.register(modEventBus);
        LongwingsItemsForge.ITEM.register(modEventBus);
        LongwingsBlocksForge.BLOCK_ENTITIES.register(modEventBus);
        LongwingsParticlesForge.PARTICLE_TYPES.register(modEventBus);
        LongwingsItemsForge.RECIPES.register(modEventBus);
        LongwingsEffectsForge.EFFECTS.register(modEventBus);
        LongwingsEntityTypesForge.ENTITY_TYPES.register(modEventBus);
        LongwingsItemGroup.TABS.register(modEventBus);
        LongwingsSoundsForge.registerSounds();
        LongwingsBlocksForge.registerBlocks();
        LongwingsItemsForge.registerItems();
        LongwingsBlocksForge.registerBlockEntities();
        LongwingsParticlesForge.registerParticles();
        LongwingsEffectsForge.registerEffects();
        LongwingsEntityTypesForge.registerEntityTypes();
        LongwingsHandler.setBiomeHandler(new ForgeBiomeHandler());
        LongwingsHandler.setHandbookHandler(new ForgeHandbookHandler());
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(LongwingsPackets::register);
    }

    @Mod.EventBusSubscriber(modid="longwings", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.m_174036_(LongwingsEntityTypes.BUTTERFLY, ButterflyEntityRenderer::new);
            EntityRenderers.m_174036_(LongwingsEntityTypes.MOTH, ButterflyEntityRenderer.MothEntityRenderer::new);
            ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)ButterflyModel.LAYER_LOCATION, ButterflyModel::createBodyLayer);
            ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)MothModel.LAYER_LOCATION, MothModel::createBodyLayer);
            ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)CatchingNetModel.LAYER_LOCATION, CatchingNetModel::createBodyLayer);
        }
    }
}

