/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.block.IKitchenCabinetry;
import com.mrcrayfish.furniture.refurbished.blockentity.KitchenSinkBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class KitchenSinkBlock
extends FurnitureHorizontalEntityBlock
implements IKitchenCabinetry {
    public KitchenSinkBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH));
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape topShape = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape baseShape = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        VoxelShape sinkShape = Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)12.0, (double)16.0, (double)14.0);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(Shapes.m_83148_((VoxelShape)topShape, (VoxelShape)VoxelShapeHelper.rotateHorizontally(sinkShape, direction), (BooleanOp)BooleanOp.f_82685_));
            shapes.add(VoxelShapeHelper.rotateHorizontally(baseShape, direction));
            builder.put((Object)state, (Object)VoxelShapeHelper.combine(shapes));
        }
        return builder.build();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof KitchenSinkBlockEntity) {
            KitchenSinkBlockEntity sink = (KitchenSinkBlockEntity)blockEntity;
            return sink.interact(player, hand, result);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new KitchenSinkBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return KitchenSinkBlock.createTicker(type, (BlockEntityType)ModBlockEntities.KITCHEN_SINK.get(), KitchenSinkBlockEntity::clientTick);
        }
        return null;
    }

    @Override
    public Direction getDirection(BlockState state) {
        return (Direction)state.m_61143_((Property)DIRECTION);
    }
}

