/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.item;

import java.util.function.Supplier;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;

public class SimpleItemTier
implements Tier {
    private final int maxUses;
    private final float efficiency;
    private final float attackDamage;
    private final int harvestLevel;
    private final int enchantability;
    private final LazyLoadedValue<Ingredient> repairMaterial;

    public SimpleItemTier(int maxUses, float efficiency, float attackDamage, int harvestLevel, int enchantability, Supplier<Ingredient> repairMaterial) {
        this.maxUses = maxUses;
        this.efficiency = efficiency;
        this.attackDamage = attackDamage;
        this.harvestLevel = harvestLevel;
        this.enchantability = enchantability;
        this.repairMaterial = new LazyLoadedValue(repairMaterial);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Tier other) {
        return SimpleItemTier.builder().from(other);
    }

    public int m_6609_() {
        return this.maxUses;
    }

    public float m_6624_() {
        return this.efficiency;
    }

    public float m_6631_() {
        return this.attackDamage;
    }

    public int m_6604_() {
        return this.harvestLevel;
    }

    public int m_6601_() {
        return this.enchantability;
    }

    public Ingredient m_6282_() {
        return (Ingredient)this.repairMaterial.m_13971_();
    }

    public static class Builder {
        private int maxUses;
        private float efficiency;
        private float attackDamage;
        private int harvestLevel;
        private int enchantability;
        private Supplier<Ingredient> repairMaterial;

        private Builder() {
        }

        public Builder from(Tier other) {
            this.maxUses(other.m_6609_());
            this.efficiency(other.m_6624_());
            this.attackDamage(other.m_6631_());
            this.harvestLevel(other.m_6604_());
            this.enchantability(other.m_6601_());
            this.repairMaterial(() -> ((Tier)other).m_6282_());
            return this;
        }

        public Builder maxUses(int maxUses) {
            this.maxUses = maxUses;
            return this;
        }

        public Builder efficiency(float efficiency) {
            this.efficiency = efficiency;
            return this;
        }

        public Builder attackDamage(float attackDamage) {
            this.attackDamage = attackDamage;
            return this;
        }

        public Builder harvestLevel(int harvestLevel) {
            this.harvestLevel = harvestLevel;
            return this;
        }

        public Builder enchantability(int enchantability) {
            this.enchantability = enchantability;
            return this;
        }

        public Builder repairMaterial(Supplier<Ingredient> repairMaterial) {
            this.repairMaterial = repairMaterial;
            return this;
        }

        public SimpleItemTier build() {
            return new SimpleItemTier(this.maxUses, this.efficiency, this.attackDamage, this.harvestLevel, this.enchantability, this.repairMaterial);
        }
    }
}

