/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.cycle_menu;

import com.railwayteam.railways.content.cycle_menu.RadialTagCycleMenu;
import com.railwayteam.railways.content.cycle_menu.TagCycleTracker;
import com.railwayteam.railways.registry.CRKeys;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.registry.CRPalettes;
import com.railwayteam.railways.util.EntityUtils;
import com.railwayteam.railways.util.packet.TagCycleSelectionPacket;
import net.createmod.catnip.gui.ScreenOpener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class TagCycleHandlerClient {
    public static final TagCycleTracker CYCLE_TRACKER = new TagCycleTracker();
    @ApiStatus.Internal
    public static int COOLDOWN = 0;

    public static void clientTick() {
        if (COOLDOWN > 0 && !CRKeys.CYCLE_MENU.isPressed()) {
            --COOLDOWN;
        }
    }

    static void select(Item target) {
        CRPackets.PACKETS.send(new TagCycleSelectionPacket(target));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void onKeyInput(int key, boolean pressed) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91072_ == null || mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        if (key != CRKeys.CYCLE_MENU.getBoundCode() || !pressed) {
            return;
        }
        if (COOLDOWN > 0) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        MutableObject cycleTag = new MutableObject();
        @Nullable MutableObject stackTag = new MutableObject();
        if (!EntityUtils.isHolding((Player)player, stack -> {
            Item item = stack.m_41720_();
            TagKey<Item> tag = CYCLE_TRACKER.getCycleTag(item);
            if (tag != null) {
                cycleTag.setValue(tag);
                stackTag.setValue((Object)stack.m_41783_());
            }
            return tag != null;
        })) {
            return;
        }
        ScreenOpener.open((Screen)new RadialTagCycleMenu((TagKey<Item>)((TagKey)cycleTag.getValue()), CYCLE_TRACKER.getCycle((TagKey<Item>)((TagKey)cycleTag.getValue())), (CompoundTag)stackTag.getValue()));
    }

    public static void onTagsUpdated() {
        CYCLE_TRACKER.scheduleRecompute();
    }

    static {
        CRPalettes.CYCLE_GROUPS.values().forEach(CYCLE_TRACKER::registerCycle);
        CYCLE_TRACKER.scheduleRecompute();
    }
}

