/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.client;

import com.mojang.logging.LogUtils;
import com.mrcrayfish.controllable.client.binding.BindingRegistry;
import com.mrcrayfish.controllable.client.binding.KeyAdapterBinding;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.event.ControllerEvents;
import com.mrcrayfish.controllable.event.Value;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import dev.gigaherz.toolbelt.ToolBelt;
import java.util.BitSet;
import net.minecraft.client.KeyMapping;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ControllableSupport {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final BitSet buttons = new BitSet();

    public static void init() {
        try {
            ControllerEvents.INPUT.register((IFrameworkEvent)((ControllerEvents.Input)ControllableSupport::inputEvent));
        }
        catch (Throwable t) {
            LOGGER.error("Error registering event for Controllable input. Assuming the worst and disabling Controllable support.");
            ToolBelt.controllableEnabled = false;
        }
    }

    private static boolean inputEvent(Controller controller, Value<Integer> integerValue, int i, boolean b) {
        buttons.set(i, b);
        return false;
    }

    @Nullable
    public static Boolean isButtonDown(KeyMapping keybind) {
        try {
            String customKey = keybind.m_90860_() + ".custom";
            KeyAdapterBinding adapter = (KeyAdapterBinding)BindingRegistry.getInstance().getKeyAdapters().get(customKey);
            if (adapter == null) {
                return null;
            }
            return buttons.get(adapter.getButton());
        }
        catch (Throwable t) {
            LOGGER.error("Error querying Controllable controller status for a keybind. Assuming the worst and disabling Controllable support.");
            ToolBelt.controllableEnabled = false;
            return null;
        }
    }
}

