/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.portable_blueprints;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import nimble.portable_blueprints.Events.BlueprintWorldInjection;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.init.ModItems;
import nimble.portable_blueprints.init.ModTabs;
import nimble.portable_blueprints.mod_compatibility.ModCompatibilityInit;
import nimble.portable_blueprints.portable_blueprints.ModConfig;
import nimble.portable_blueprints.portable_blueprints.ModServerConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@net.minecraftforge.fml.common.Mod(value="portable_blueprints")
public class Mod {
    public static final Logger LOGGER = LogManager.getLogger(Mod.class);
    public static final String MODID = "portable_blueprints";
    public static final List<String> ListaModContainerNonConsentiti = List.of("storagedrawers");
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("portable_blueprints", "portable_blueprints"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public Mod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.REGISTRY.register(bus);
        ModTabs.REGISTRY.register(bus);
        Blueprint.setup();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ModConfig.SPEC, "portable_blueprints-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ModServerConfig.SPEC, "portable_blueprints-server.toml");
        BlueprintWorldInjection.creaDirectoryConFileSetting();
        ModCompatibilityInit.init();
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }

    public static boolean isModContainerConsentito(BlockEntity blockEntity) {
        ResourceLocation id = ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)blockEntity.m_58903_());
        if (id == null) {
            return false;
        }
        return !ListaModContainerNonConsentiti.contains(id.m_135827_());
    }
}

