/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.structure;

import com.ninni.species.registry.SpeciesEntities;
import com.ninni.species.registry.SpeciesLootTables;
import com.ninni.species.registry.SpeciesStructurePieceTypes;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class WraptorCoopGenerator {
    public static final int COOP_STRUCTURES = 7;
    private static final Function<Integer, ResourceLocation> TEMPLATES = Util.m_143827_(i -> new ResourceLocation("species", "wraptor_coop/coop" + i));

    public static void addPieces(StructureTemplateManager manager, BlockPos pos, int height, Rotation rotation, StructurePieceAccessor holder, RandomSource random) {
        holder.m_142679_((StructurePiece)new Piece(manager, TEMPLATES.apply(Mth.m_216287_((RandomSource)random, (int)1, (int)7)), pos, rotation));
    }

    public static class Piece
    extends TemplateStructurePiece {
        public static final String ROTATION_KEY = "Rotation";

        public Piece(StructureTemplateManager manager, ResourceLocation id, BlockPos pos, Rotation rotation) {
            super((StructurePieceType)SpeciesStructurePieceTypes.WRAPTOR_COOP.get(), 0, manager, id, id.toString(), Piece.createPlacementData(rotation), pos);
        }

        public Piece(StructureTemplateManager manager, CompoundTag nbt) {
            super((StructurePieceType)SpeciesStructurePieceTypes.WRAPTOR_COOP.get(), nbt, manager, id -> Piece.createPlacementData(Rotation.valueOf((String)nbt.m_128461_(ROTATION_KEY))));
        }

        private static StructurePlaceSettings createPlacementData(Rotation rotation) {
            return new StructurePlaceSettings().m_74379_(rotation).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
        }

        protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
            super.m_183620_(structurePieceSerializationContext, compoundTag);
            compoundTag.m_128359_(ROTATION_KEY, this.f_73657_.m_74404_().name());
        }

        public void m_213694_(WorldGenLevel world, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            if (world.m_8055_(this.f_73658_.m_7495_()).m_204336_(BlockTags.f_13077_) || world.m_8055_(this.f_73658_.m_7495_()).m_60713_(Blocks.f_50134_) && world.m_46859_(this.f_73658_)) {
                this.f_73658_ = this.f_73658_.m_7495_();
            }
            super.m_213694_(world, structureManager, chunkGenerator, randomSource, boundingBox, chunkPos, blockPos);
        }

        protected void m_213704_(String metadata, BlockPos pos, ServerLevelAccessor world, RandomSource random, BoundingBox boundingBox) {
            if (metadata.startsWith("Chest")) {
                Rotation rotation = this.f_73657_.m_74404_();
                BlockState blockState = Blocks.f_50087_.m_49966_();
                this.m_226762_(world, boundingBox, random, pos, SpeciesLootTables.WRAPTOR_COOP_CHEST, (BlockState)blockState.m_61124_((Property)ChestBlock.f_51478_, (Comparable)rotation.m_55954_(switch (metadata) {
                    default -> Direction.NORTH;
                    case "ChestEast" -> Direction.EAST;
                    case "ChestSouth" -> Direction.SOUTH;
                    case "ChestWest" -> Direction.WEST;
                })));
            } else {
                ArrayList<Mob> entities = new ArrayList<Mob>();
                if ("Wraptor".equals(metadata)) {
                    entities.add((Mob)((EntityType)SpeciesEntities.WRAPTOR.get()).m_20615_((Level)world.m_6018_()));
                }
                for (Mob entity : entities) {
                    entity.m_21530_();
                    entity.m_20035_(pos, 0.0f, 0.0f);
                    entity.m_6518_(world, world.m_6436_(entity.m_20183_()), MobSpawnType.STRUCTURE, null, null);
                    world.m_47205_((Entity)entity);
                }
            }
        }
    }
}

