/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.structure;

import com.google.common.collect.Maps;
import com.ninni.species.registry.SpeciesBlocks;
import com.ninni.species.registry.SpeciesLootTables;
import com.ninni.species.registry.SpeciesStructurePieceTypes;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class PaleontologyDigSiteGenerator {
    public static final Map<ResourceLocation, Integer> HEIGHT_TO_TEMPLATES = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put(new ResourceLocation("species", "paleontology_dig_site/dig_site_bigger"), 9);
        map.put(new ResourceLocation("species", "paleontology_dig_site/dig_site_crippler"), 6);
        map.put(new ResourceLocation("species", "paleontology_dig_site/dig_site_gripper"), 7);
        map.put(new ResourceLocation("species", "paleontology_dig_site/dig_site_extender"), 3);
        map.put(new ResourceLocation("species", "paleontology_dig_site/dig_site_grinner"), 1);
        map.put(new ResourceLocation("species", "paleontology_dig_site/dig_site_lilypadder"), 7);
        map.put(new ResourceLocation("species", "paleontology_dig_site/dig_site_loser"), 3);
        map.put(new ResourceLocation("species", "paleontology_dig_site/dig_site_shimmer_shell"), 7);
        map.put(new ResourceLocation("species", "paleontology_dig_site/dig_site_shimmer_tail"), 5);
        map.put(new ResourceLocation("species", "paleontology_dig_site/dig_site_stroker"), 2);
        map.put(new ResourceLocation("species", "paleontology_dig_site/dig_site_trampler"), 6);
        map.put(new ResourceLocation("species", "paleontology_dig_site/dig_site_tremor"), 4);
        map.put(new ResourceLocation("species", "paleontology_dig_site/dig_site_zipper"), 10);
    });

    public static void addPieces(StructureTemplateManager manager, BlockPos pos, StructurePieceAccessor holder, RandomSource random) {
        Set<ResourceLocation> resourceLocations = HEIGHT_TO_TEMPLATES.keySet();
        ArrayList templates = new ArrayList(resourceLocations.stream().toList());
        ResourceLocation randomTemplate = (ResourceLocation)Util.m_214621_(templates, (RandomSource)random);
        Rotation rotation = Rotation.m_221990_((RandomSource)random);
        holder.m_142679_((StructurePiece)new Piece(manager, randomTemplate, pos, rotation));
    }

    public static class Piece
    extends TemplateStructurePiece {
        public static final String ROTATION_KEY = "Rotation";

        public Piece(StructureTemplateManager manager, ResourceLocation id, BlockPos pos, Rotation rotation) {
            super((StructurePieceType)SpeciesStructurePieceTypes.PALEONTOLOGY_DIG_SITE.get(), HEIGHT_TO_TEMPLATES.get(id).intValue(), manager, id, id.toString(), Piece.createPlacementData(rotation), pos);
        }

        public Piece(StructureTemplateManager manager, CompoundTag nbt) {
            super((StructurePieceType)SpeciesStructurePieceTypes.PALEONTOLOGY_DIG_SITE.get(), nbt, manager, id -> Piece.createPlacementData(Rotation.valueOf((String)nbt.m_128461_(ROTATION_KEY))));
        }

        private static StructurePlaceSettings createPlacementData(Rotation rotation) {
            return new StructurePlaceSettings().m_74379_(rotation).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
        }

        protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
            super.m_183620_(structurePieceSerializationContext, compoundTag);
            compoundTag.m_128359_(ROTATION_KEY, this.f_73657_.m_74404_().name());
        }

        public void m_213694_(WorldGenLevel world, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            BlockPos blockPos1 = this.f_73658_;
            this.f_73658_ = this.f_73658_.m_6625_(HEIGHT_TO_TEMPLATES.get(new ResourceLocation(this.f_163658_)).intValue());
            super.m_213694_(world, structureManager, chunkGenerator, randomSource, boundingBox, chunkPos, blockPos);
            this.f_73658_ = blockPos1;
        }

        protected void m_213704_(String metadata, BlockPos pos, ServerLevelAccessor world, RandomSource random, BoundingBox boundingBox) {
            if (metadata.equals("COMMON")) {
                this.createRedSuspiciousSand(world, boundingBox, random, pos, SpeciesLootTables.PALEONTOLOGY_DIG_SITE_COMMON);
            }
            if (metadata.equals("RARE")) {
                this.createRedSuspiciousSand(world, boundingBox, random, pos, SpeciesLootTables.PALEONTOLOGY_DIG_SITE_RARE);
            }
            if (metadata.equals("EPIC")) {
                this.createRedSuspiciousSand(world, boundingBox, random, pos, SpeciesLootTables.PALEONTOLOGY_DIG_SITE_EPIC);
            }
        }

        protected void createRedSuspiciousSand(ServerLevelAccessor serverLevelAccessor, BoundingBox boundingBox, RandomSource randomSource, BlockPos blockPos, ResourceLocation resourceLocation) {
            boolean invalidBelowPos;
            Block redSuspiciousSand = (Block)SpeciesBlocks.RED_SUSPICIOUS_SAND.get();
            boolean outsideBoundingBox = !boundingBox.m_71051_((Vec3i)blockPos);
            boolean stateIsSelf = serverLevelAccessor.m_8055_(blockPos).m_60713_(redSuspiciousSand);
            boolean bl = invalidBelowPos = !serverLevelAccessor.m_8055_(blockPos.m_7495_()).m_60783_((BlockGetter)serverLevelAccessor, blockPos.m_7495_(), Direction.UP);
            if (outsideBoundingBox || stateIsSelf || invalidBelowPos) {
                return;
            }
            serverLevelAccessor.m_7731_(blockPos, redSuspiciousSand.m_49966_(), 2);
            BlockEntity blockEntity = serverLevelAccessor.m_7702_(blockPos);
            if (blockEntity instanceof BrushableBlockEntity) {
                BrushableBlockEntity entity = (BrushableBlockEntity)blockEntity;
                entity.m_277049_(resourceLocation, randomSource.m_188505_());
            }
        }
    }
}

