/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.mob.update_3;

import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.server.entity.util.SpeciesPose;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class Hanger
extends Monster {
    public static final EntityDataAccessor<Vector3f> CURRENT_TONGUE_POS = SynchedEntityData.m_135353_(Hanger.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    public static final EntityDataAccessor<Integer> JAW_SNAP_TICKS = SynchedEntityData.m_135353_(Hanger.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> CANT_ATTACK_TICKS = SynchedEntityData.m_135353_(Hanger.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Vector3f> TARGET_POS = SynchedEntityData.m_135353_(Hanger.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    public static final EntityDataAccessor<Boolean> IS_TONGUE_OUT = SynchedEntityData.m_135353_(Hanger.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> RARE = SynchedEntityData.m_135353_(Hanger.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState lookAroundAnimationState = new AnimationState();
    public final AnimationState shiftAnimationState = new AnimationState();
    public final AnimationState eyeTwitchAnimationState = new AnimationState();
    private int eyeTwitchCoooldown = this.f_19796_.m_188503_(50) + 100;
    private int shiftCoooldown = this.f_19796_.m_188503_(1200) + 600;
    private int lookAroundCoooldown = this.f_19796_.m_188503_(200) + 200;
    protected Vector3f tongueTarget;
    protected int targetStuckTicks;
    public float mouthOpenProgress = 0.0f;

    protected Hanger(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new EyeTwitchingAnimationGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new ShiftingAnimationGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new LookAroundAnimationGoal(this));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        this.setRare(this.f_19796_.m_188503_(10) == 0);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, spawnType, groupData, tag);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 8.0);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20089_() != SpeciesPose.READJUSTING.get() && this.shiftCoooldown > 0) {
            --this.shiftCoooldown;
        }
        if (this.m_20089_() != SpeciesPose.TWITCHING.get() && this.eyeTwitchCoooldown > 0) {
            --this.eyeTwitchCoooldown;
        }
        if (this.m_20089_() != SpeciesPose.LOOKING_AROUND.get() && this.lookAroundCoooldown > 0) {
            --this.lookAroundCoooldown;
        }
        if (this.f_19797_ > 2) {
            this.updateTongue();
        }
        if (this.getJawSnapTicks() > 0) {
            this.setJawSnapTicks(this.getJawSnapTicks() - 1);
            this.mouthOpenProgress = this.getJawSnapTicks() > 6 ? 0.0f : (float)(10 - this.getJawSnapTicks()) / 10.0f - 0.4f;
        } else {
            this.mouthOpenProgress = this.isTongueOut() ? Math.min(1.0f, this.mouthOpenProgress + 0.01f) : Math.max(0.0f, this.mouthOpenProgress - 0.25f);
        }
        this.unstuckTarget();
    }

    public void unstuckTarget() {
        if (!this.m_9236_().f_46443_) {
            LivingEntity target = this.m_5448_();
            if (this.getCantAttackTicks() > 0) {
                this.setCantAttackTicks(this.getCantAttackTicks() - 1);
            }
            if (target != null && !(target instanceof Player)) {
                double dz;
                double dy;
                double dx = target.m_20185_() - target.f_19854_;
                double motionSq = dx * dx + (dy = target.m_20186_() - target.f_19855_) * dy + (dz = target.m_20189_() - target.f_19856_) * dz;
                if (motionSq < 0.01 && !target.m_20096_()) {
                    ++this.targetStuckTicks;
                }
                if (this.targetStuckTicks > 200) {
                    this.m_6710_(null);
                    this.setCantAttackTicks(200);
                }
                if (this.getCantAttackTicks() > 0) {
                    this.m_6710_(null);
                }
            } else if (this.targetStuckTicks > 0) {
                this.targetStuckTicks = 0;
            }
        }
    }

    private void updateTongue() {
        if (this.tongueTarget != null) {
            Vector3f target = new Vector3f(this.tongueTarget.x - (float)this.m_20185_(), this.tongueTarget.y - (float)this.m_20186_(), this.tongueTarget.z - (float)this.m_20189_());
            float lerp = Mth.m_14036_((float)(this.getCurrentTonguePos().distance((Vector3fc)target) * 0.3f), (float)0.05f, (float)1.0f);
            this.setCurrentTonguePos(new Vector3f(Mth.m_14179_((float)lerp, (float)this.getCurrentTonguePos().x, (float)target.x), Mth.m_14179_((float)lerp, (float)this.getCurrentTonguePos().y, (float)target.y), Mth.m_14179_((float)lerp, (float)this.getCurrentTonguePos().z, (float)target.z)));
        } else {
            this.tongueTarget = new Vector3f((float)this.m_20185_(), (float)(this.m_20186_() + (double)this.getTongueOffset()), (float)this.m_20189_());
        }
        if (this.getCurrentTonguePos().distance((Vector3fc)new Vector3f(0.0f, this.getTongueOffset(), 0.0f)) > 40.0f || !this.isTongueOut()) {
            this.deactivateTongue();
        }
        this.setTongueTarget(this.getTargetPos());
    }

    public void activateTongue(Vector3f target) {
        Vector3f origin = new Vector3f(0.0f, this.getTongueOffset(), 0.0f);
        this.setCurrentTonguePos(origin);
        this.setTargetPos(target);
        this.setTongueTarget(target);
        this.setTongueOut(true);
    }

    public void deactivateTongue() {
        Vector3f fallback = new Vector3f((float)this.m_20185_(), (float)(this.m_20186_() + (double)this.getTongueOffset()), (float)this.m_20189_());
        this.setTargetPos(fallback);
        this.setTongueTarget(fallback);
        this.setTongueOut(false);
    }

    public float getTongueOffset() {
        return 0.35f;
    }

    public void setTongueTarget(Vector3f tongueTarget) {
        this.tongueTarget = tongueTarget;
    }

    public boolean m_7327_(Entity target) {
        this.setJawSnapTicks(10);
        return super.m_7327_(target);
    }

    protected void m_7472_(DamageSource source, int lootingMultiplier, boolean recentlyHit) {
        super.m_7472_(source, lootingMultiplier, recentlyHit);
        if (this.isTongueOut() && this.f_19796_.m_188501_() < 0.8f) {
            int count = 1;
            if (this.f_19796_.m_188501_() < 0.3f + 0.05f * (float)lootingMultiplier) {
                count += 1 + this.f_19796_.m_188503_(2);
            }
            for (int i = 0; i < count; ++i) {
                this.m_19998_((ItemLike)SpeciesItems.COIL.get());
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (f_19806_.equals(entityDataAccessor)) {
            if (this.m_20089_() == SpeciesPose.TWITCHING.get()) {
                this.eyeTwitchAnimationState.m_216977_(this.f_19797_);
            } else if (this.m_20089_() == SpeciesPose.LOOKING_AROUND.get()) {
                this.lookAroundAnimationState.m_216977_(this.f_19797_);
            } else if (this.m_20089_() == SpeciesPose.READJUSTING.get()) {
                this.shiftAnimationState.m_216977_(this.f_19797_);
            } else if (this.m_20089_() == Pose.STANDING) {
                this.eyeTwitchAnimationState.m_216973_();
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CURRENT_TONGUE_POS, (Object)new Vector3f((float)this.m_20185_(), (float)(this.m_20186_() + (double)this.getTongueOffset()), (float)this.m_20189_()));
        this.f_19804_.m_135372_(JAW_SNAP_TICKS, (Object)0);
        this.f_19804_.m_135372_(CANT_ATTACK_TICKS, (Object)0);
        this.f_19804_.m_135372_(TARGET_POS, (Object)new Vector3f((float)this.m_20185_(), (float)this.m_20186_() + this.getTongueOffset(), (float)this.m_20189_()));
        this.f_19804_.m_135372_(IS_TONGUE_OUT, (Object)false);
        this.f_19804_.m_135372_(RARE, (Object)false);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128350_("CurrentTonguePosX", this.getCurrentTonguePos().x);
        compoundTag.m_128350_("CurrentTonguePosY", this.getCurrentTonguePos().y);
        compoundTag.m_128350_("CurrentTonguePosZ", this.getCurrentTonguePos().z);
        compoundTag.m_128350_("TargetPosX", this.getTargetPos().x);
        compoundTag.m_128350_("TargetPosY", this.getTargetPos().y);
        compoundTag.m_128350_("TargetPosZ", this.getTargetPos().z);
        compoundTag.m_128405_("JawSnapTicks", this.getJawSnapTicks());
        compoundTag.m_128405_("CantAttackTicks", this.getCantAttackTicks());
        compoundTag.m_128379_("IsTongueOut", this.isTongueOut());
        compoundTag.m_128379_("Rare", this.isRare());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setCurrentTonguePos(new Vector3f(compoundTag.m_128457_("CurrentTonguePosX"), compoundTag.m_128457_("CurrentTonguePosY"), compoundTag.m_128457_("CurrentTonguePosZ")));
        this.setTargetPos(new Vector3f(compoundTag.m_128457_("TargetPosX"), compoundTag.m_128457_("TargetPosY"), compoundTag.m_128457_("TargetPosZ")));
        this.setJawSnapTicks(compoundTag.m_128451_("JawSnapTicks"));
        this.setCantAttackTicks(compoundTag.m_128451_("CantAttackTicks"));
        this.setTongueOut(compoundTag.m_128471_("IsTongueOut"));
        this.setRare(compoundTag.m_128471_("Rare"));
    }

    public Vector3f getCurrentTonguePos() {
        return (Vector3f)this.f_19804_.m_135370_(CURRENT_TONGUE_POS);
    }

    public void setCurrentTonguePos(Vector3f vec) {
        this.f_19804_.m_135381_(CURRENT_TONGUE_POS, (Object)vec);
    }

    public void setJawSnapTicks(int ticks) {
        this.f_19804_.m_135381_(JAW_SNAP_TICKS, (Object)ticks);
    }

    public int getJawSnapTicks() {
        return (Integer)this.f_19804_.m_135370_(JAW_SNAP_TICKS);
    }

    public void setCantAttackTicks(int ticks) {
        this.f_19804_.m_135381_(CANT_ATTACK_TICKS, (Object)ticks);
    }

    public int getCantAttackTicks() {
        return (Integer)this.f_19804_.m_135370_(CANT_ATTACK_TICKS);
    }

    public Vector3f getTargetPos() {
        return (Vector3f)this.f_19804_.m_135370_(TARGET_POS);
    }

    public void setTargetPos(Vector3f vec) {
        this.f_19804_.m_135381_(TARGET_POS, (Object)vec);
    }

    public boolean isTongueOut() {
        return (Boolean)this.f_19804_.m_135370_(IS_TONGUE_OUT);
    }

    public void setTongueOut(boolean tongueOut) {
        this.f_19804_.m_135381_(IS_TONGUE_OUT, (Object)tongueOut);
    }

    public boolean isRare() {
        return (Boolean)this.f_19804_.m_135370_(RARE);
    }

    public void setRare(boolean rare) {
        this.f_19804_.m_135381_(RARE, (Object)rare);
    }

    public boolean m_6094_() {
        return !this.isTongueOut() && super.m_6094_();
    }

    public static class EyeTwitchingAnimationGoal
    extends Goal {
        public Hanger hanger;
        public int timer;

        public EyeTwitchingAnimationGoal(Hanger hanger) {
            this.hanger = hanger;
        }

        public boolean m_8036_() {
            return this.hanger.eyeTwitchCoooldown == 0 && this.hanger.m_20089_() == Pose.STANDING;
        }

        public void m_8056_() {
            this.timer = 30;
            this.hanger.m_21573_().m_26573_();
            this.hanger.m_20124_(SpeciesPose.TWITCHING.get());
        }

        public boolean m_8045_() {
            return this.timer > 0 && this.hanger.m_20089_() == SpeciesPose.TWITCHING.get();
        }

        public void m_8037_() {
            --this.timer;
        }

        public void m_8041_() {
            this.hanger.eyeTwitchCoooldown = this.hanger.f_19796_.m_188503_(50) + 100;
            this.hanger.m_20124_(Pose.STANDING);
        }
    }

    public static class ShiftingAnimationGoal
    extends Goal {
        public Hanger hanger;
        public int timer;

        public ShiftingAnimationGoal(Hanger hanger) {
            this.hanger = hanger;
        }

        public boolean m_8036_() {
            return this.hanger.shiftCoooldown == 0 && this.hanger.m_20089_() == Pose.STANDING;
        }

        public void m_8056_() {
            this.timer = 260;
            this.hanger.m_21573_().m_26573_();
            this.hanger.m_20124_(SpeciesPose.READJUSTING.get());
        }

        public boolean m_8045_() {
            return this.timer > 0 && this.hanger.m_20089_() == SpeciesPose.READJUSTING.get();
        }

        public void m_8037_() {
            --this.timer;
        }

        public void m_8041_() {
            this.hanger.shiftCoooldown = this.hanger.f_19796_.m_188503_(1200) + 600;
            this.hanger.m_20124_(Pose.STANDING);
        }
    }

    public static class LookAroundAnimationGoal
    extends Goal {
        public Hanger hanger;
        public int timer;

        public LookAroundAnimationGoal(Hanger hanger) {
            this.hanger = hanger;
        }

        public boolean m_8036_() {
            return this.hanger.lookAroundCoooldown == 0 && this.hanger.m_20089_() == Pose.STANDING;
        }

        public void m_8056_() {
            this.timer = 160;
            this.hanger.m_21573_().m_26573_();
            this.hanger.m_20124_(SpeciesPose.LOOKING_AROUND.get());
        }

        public boolean m_8045_() {
            return this.timer > 0 && this.hanger.m_20089_() == SpeciesPose.LOOKING_AROUND.get();
        }

        public void m_8037_() {
            --this.timer;
        }

        public void m_8041_() {
            this.hanger.lookAroundCoooldown = this.hanger.f_19796_.m_188503_(200) + 200;
            this.hanger.m_20124_(Pose.STANDING);
        }
    }
}

