/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.mob.update_2;

import com.google.common.annotations.VisibleForTesting;
import com.ninni.species.registry.SpeciesEntities;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.registry.SpeciesTags;
import com.ninni.species.server.criterion.SpeciesCriterion;
import com.ninni.species.server.entity.ai.goal.GooberLayDownGoal;
import com.ninni.species.server.entity.ai.goal.GooberRearUpGoal;
import com.ninni.species.server.entity.ai.goal.GooberYawnGoal;
import com.ninni.species.server.entity.mob.update_2.GooberGoo;
import com.ninni.species.server.entity.util.GooberBehavior;
import com.ninni.species.server.entity.util.SpeciesPose;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Goober
extends Animal {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState layDownIdleAnimationState = new AnimationState();
    public final AnimationState layDownAnimationState = new AnimationState();
    public final AnimationState standUpAnimationState = new AnimationState();
    public final AnimationState yawnAnimationState = new AnimationState();
    public final AnimationState layDownYawnAnimationState = new AnimationState();
    public final AnimationState sneezeAnimationState = new AnimationState();
    public final AnimationState layDownSneezeAnimationState = new AnimationState();
    public final AnimationState rearUpAnimationState = new AnimationState();
    public static final EntityDataAccessor<Long> LAST_POSE_CHANGE_TICK = SynchedEntityData.m_135353_(Goober.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    private static final EntityDataAccessor<String> BEHAVIOR = SynchedEntityData.m_135353_(Goober.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> LAY_DOWN_COOLDOWN = SynchedEntityData.m_135353_(Goober.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> YAWN_COOLDOWN = SynchedEntityData.m_135353_(Goober.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> YAWN_TIMER = SynchedEntityData.m_135353_(Goober.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> REAR_UP_COOLDOWN = SynchedEntityData.m_135353_(Goober.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> REAR_UP_TIMER = SynchedEntityData.m_135353_(Goober.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> SNEEZE_COOLDOWN = SynchedEntityData.m_135353_(Goober.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> SNEEZE_TIMER = SynchedEntityData.m_135353_(Goober.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDimensions SITTING_DIMENSIONS = EntityDimensions.m_20395_((float)2.0f, (float)1.4f);
    private int idleAnimationTimeout = 0;

    public Goober(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new GooberMoveControl();
        this.f_21365_ = new GooberLookControl(this);
        this.m_274367_(1.0f);
    }

    protected BodyRotationControl m_7560_() {
        return new GooberBodyRotationControl(this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_204132_(SpeciesTags.GOOBER_BREED_ITEMS), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new GooberYawnGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new GooberRearUpGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new GooberLayDownGoal(this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22279_, 0.15);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        boolean bl = this.m_6898_(itemStack);
        InteractionResult interactionResult = super.m_6071_(player, interactionHand);
        if (interactionResult.m_19077_() && bl) {
            if (this.isGooberLayingDown()) {
                this.standUp();
            }
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)SpeciesSoundEvents.GOOBER_EAT.get(), SoundSource.NEUTRAL, 1.0f, Mth.m_216283_((RandomSource)this.m_9236_().f_46441_, (float)0.8f, (float)1.2f));
        }
        if ((itemStack.m_150930_(Items.f_42402_) || itemStack.m_150930_(Items.f_271356_)) && this.getSneezeCooldown() == 0 && this.getBehavior().equals(GooberBehavior.IDLE.getName())) {
            this.setSneezeTimer(GooberBehavior.SNEEZING.getLength());
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SpeciesCriterion.TICKLE_GOOBER.trigger(serverPlayer);
            }
            this.m_20124_(this.isGooberLayingDown() ? SpeciesPose.SNEEZING_LAYING_DOWN.get() : SpeciesPose.SNEEZING.get());
            this.sneezeCooldown();
            this.m_5496_((SoundEvent)SpeciesSoundEvents.GOOBER_SNEEZE.get(), 2.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return interactionResult;
    }

    public void m_27563_(ServerLevel serverLevel, Animal animal) {
        ItemStack itemStack = new ItemStack((ItemLike)SpeciesItems.PETRIFIED_EGG.get());
        ItemEntity itemEntity = new ItemEntity((Level)serverLevel, this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), itemStack);
        itemEntity.m_32060_();
        this.m_277117_(serverLevel, animal, null);
        this.m_5496_((SoundEvent)SpeciesSoundEvents.PETRIFIED_EGG_PLOP.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.5f);
        serverLevel.m_7967_((Entity)itemEntity);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(SpeciesTags.GOOBER_BREED_ITEMS);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getLayDownCooldown() > 0) {
            this.setLayDownCooldown(this.getLayDownCooldown() - 1);
        }
        if (this.getRearUpCooldown() > 0) {
            if (this.getBehavior().equals(GooberBehavior.REAR_UP.getName())) {
                this.setBehavior(GooberBehavior.IDLE.getName());
            }
            this.setRearUpCooldown(this.getRearUpCooldown() - 1);
        }
        if (this.getYawnCooldown() > 0) {
            if (this.getBehavior().equals(GooberBehavior.YAWN.getName())) {
                this.setBehavior(GooberBehavior.IDLE.getName());
            }
            this.setYawnCooldown(this.getYawnCooldown() - 1);
        }
        if (this.getSneezeCooldown() > 0) {
            if (this.getBehavior().equals(GooberBehavior.SNEEZING.getName())) {
                this.setBehavior(GooberBehavior.IDLE.getName());
            }
            this.setSneezeCooldown(this.getSneezeCooldown() - 1);
        }
        if (this.getRearUpTimer() > 0) {
            this.setRearUpTimer(this.getRearUpTimer() - 1);
            if (this.getRearUpTimer() == 0) {
                this.m_20124_(Pose.STANDING);
                this.setBehavior(GooberBehavior.IDLE.getName());
                this.rearUpCooldown();
            }
        }
        if (this.getYawnTimer() > 0) {
            this.setYawnTimer(this.getYawnTimer() - 1);
            if (this.getYawnTimer() == 0) {
                if (this.isGooberLayingDown()) {
                    this.m_20124_(SpeciesPose.LAYING_DOWN.get());
                } else {
                    this.m_20124_(Pose.STANDING);
                }
                this.setBehavior(GooberBehavior.IDLE.getName());
                this.yawnCooldown();
            }
        }
        if (this.getSneezeTimer() > 0) {
            this.setBehavior(GooberBehavior.SNEEZING.getName());
            this.setSneezeTimer(this.getSneezeTimer() - 1);
            if (this.getSneezeTimer() == 35) {
                BlockPos blockPos = this.m_20183_();
                float angle = (float)Math.PI / 180 * this.f_20883_;
                double headX = 3.0f * this.m_6134_() * Mth.m_14031_((float)((float)Math.PI + angle));
                double headZ = 3.0f * this.m_6134_() * Mth.m_14089_((float)angle);
                Vec3 shootingVec = this.m_20154_().m_82490_(2.0).m_82542_(0.25, 1.0, 0.25);
                GooberGoo goo = new GooberGoo(this.m_9236_(), (double)blockPos.m_123341_() + headX, (float)blockPos.m_123342_() + this.m_20192_() + (this.isGooberLayingDown() ? 0.0f : 0.35f), (double)blockPos.m_123343_() + headZ);
                double d = shootingVec.m_7096_();
                double e = shootingVec.m_7098_();
                double g = shootingVec.m_7094_();
                double h = Math.sqrt(d * d + g * g);
                goo.m_6686_(d, e + h * (double)0.1f, g, 0.8f, 14 - this.m_9236_().m_46791_().m_19028_() * 4);
                this.m_9236_().m_7967_((Entity)goo);
                if (!this.isGooberLayingDown()) {
                    this.m_246865_(new Vec3(0.0, 0.25, 0.0));
                    this.m_246865_(this.m_20154_().m_82490_(2.0).m_82542_(-0.5, 0.0, -0.5));
                }
            }
            if (this.getSneezeTimer() == 1) {
                if (this.isGooberLayingDown()) {
                    this.m_20124_(SpeciesPose.LAYING_DOWN.get());
                } else {
                    this.m_20124_(Pose.STANDING);
                }
                this.setBehavior(GooberBehavior.IDLE.getName());
            }
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        if (this.isGooberLayingDown() && this.m_20069_()) {
            this.standUpInstantly();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout == 0) {
            this.idleAnimationTimeout = 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isGooberVisuallyLayingDown()) {
            this.standUpAnimationState.m_216973_();
            this.yawnAnimationState.m_216973_();
            this.sneezeAnimationState.m_216973_();
            this.rearUpAnimationState.m_216973_();
            if (this.isVisuallyLayingDown()) {
                this.layDownAnimationState.m_216982_(this.f_19797_);
                this.layDownIdleAnimationState.m_216973_();
            } else {
                this.layDownAnimationState.m_216973_();
                this.layDownIdleAnimationState.m_216982_(this.f_19797_);
            }
        } else {
            this.layDownAnimationState.m_216973_();
            this.layDownIdleAnimationState.m_216973_();
            this.standUpAnimationState.m_246184_(this.isInPoseTransition() && this.getPoseTime() >= 0L, this.f_19797_);
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        return pose == SpeciesPose.LAYING_DOWN.get() || pose == SpeciesPose.YAWNING_LAYING_DOWN.get() || pose == SpeciesPose.SNEEZING_LAYING_DOWN.get() ? SITTING_DIMENSIONS.m_20388_(this.m_6134_()) : super.m_6972_(pose);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (f_19806_.equals(entityDataAccessor)) {
            if (this.m_20089_() == SpeciesPose.SNEEZING.get()) {
                this.sneezeAnimationState.m_216977_(this.f_19797_);
            }
            if (this.m_20089_() == SpeciesPose.SNEEZING_LAYING_DOWN.get()) {
                this.layDownSneezeAnimationState.m_216977_(this.f_19797_);
            }
            if (this.m_20089_() == SpeciesPose.YAWNING.get()) {
                this.yawnAnimationState.m_216977_(this.f_19797_);
            }
            if (this.m_20089_() == SpeciesPose.YAWNING_LAYING_DOWN.get()) {
                this.layDownYawnAnimationState.m_216977_(this.f_19797_);
            }
            if (this.m_20089_() == SpeciesPose.REARING_UP.get()) {
                this.rearUpAnimationState.m_216977_(this.f_19797_);
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public boolean m_5825_() {
        return this.m_6162_();
    }

    public boolean m_5829_() {
        return this.isGooberLayingDown();
    }

    public void m_7023_(Vec3 vec3) {
        if (this.refuseToMove() && this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            vec3 = vec3.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(vec3);
    }

    protected void m_6475_(DamageSource damageSource, float f) {
        this.standUpInstantly();
        super.m_6475_(damageSource, f);
    }

    public boolean refuseToMove() {
        return this.isGooberLayingDown() || this.isInPoseTransition();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LAST_POSE_CHANGE_TICK, (Object)0L);
        this.f_19804_.m_135372_(BEHAVIOR, (Object)GooberBehavior.IDLE.getName());
        this.f_19804_.m_135372_(LAY_DOWN_COOLDOWN, (Object)(240 + this.f_19796_.m_188503_(600)));
        this.f_19804_.m_135372_(YAWN_COOLDOWN, (Object)(40 + this.f_19796_.m_188503_(240)));
        this.f_19804_.m_135372_(REAR_UP_COOLDOWN, (Object)(1200 + this.f_19796_.m_188503_(4800)));
        this.f_19804_.m_135372_(SNEEZE_TIMER, (Object)0);
        this.f_19804_.m_135372_(REAR_UP_TIMER, (Object)0);
        this.f_19804_.m_135372_(YAWN_TIMER, (Object)0);
        this.f_19804_.m_135372_(SNEEZE_COOLDOWN, (Object)0);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128356_("LastPoseTick", ((Long)this.f_19804_.m_135370_(LAST_POSE_CHANGE_TICK)).longValue());
        compoundTag.m_128359_("Behavior", this.getBehavior());
        compoundTag.m_128405_("LayDownCooldown", this.getLayDownCooldown());
        compoundTag.m_128405_("YawnCooldown", this.getYawnCooldown());
        compoundTag.m_128405_("RearUpCooldown", this.getRearUpCooldown());
        compoundTag.m_128405_("YawnTimer", this.getYawnTimer());
        compoundTag.m_128405_("RearUpTimer", this.getRearUpTimer());
        compoundTag.m_128405_("SneezeTimer", this.getSneezeTimer());
        compoundTag.m_128405_("SneezeCooldown", this.getSneezeCooldown());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setLayDownCooldown(compoundTag.m_128451_("LayDownCooldown"));
        this.setYawnCooldown(compoundTag.m_128451_("YawnCooldown"));
        this.setRearUpCooldown(compoundTag.m_128451_("RearUpCooldown"));
        this.setYawnTimer(compoundTag.m_128451_("YawnTimer"));
        this.setRearUpTimer(compoundTag.m_128451_("RearUpTimer"));
        this.setSneezeTimer(compoundTag.m_128451_("SneezeTimer"));
        this.setSneezeCooldown(compoundTag.m_128451_("SneezeCooldown"));
        this.setBehavior(compoundTag.m_128461_("Behavior"));
        long l = compoundTag.m_128454_("LastPoseTick");
        if (l < 0L) {
            this.m_20124_(SpeciesPose.LAYING_DOWN.get());
        }
        this.resetLastPoseChangeTick(l);
    }

    public String getBehavior() {
        return (String)this.f_19804_.m_135370_(BEHAVIOR);
    }

    public void setBehavior(String behavior) {
        this.f_19804_.m_135381_(BEHAVIOR, (Object)behavior);
    }

    public int getLayDownCooldown() {
        return (Integer)this.f_19804_.m_135370_(LAY_DOWN_COOLDOWN);
    }

    public void setLayDownCooldown(int cooldown) {
        this.f_19804_.m_135381_(LAY_DOWN_COOLDOWN, (Object)cooldown);
    }

    public void layDownCooldown() {
        this.f_19804_.m_135381_(LAY_DOWN_COOLDOWN, (Object)(600 + this.f_19796_.m_188503_(2400)));
    }

    public void standUpCooldown() {
        this.f_19804_.m_135381_(LAY_DOWN_COOLDOWN, (Object)(1200 + this.f_19796_.m_188503_(2400)));
    }

    public int getYawnTimer() {
        return (Integer)this.f_19804_.m_135370_(YAWN_TIMER);
    }

    public void setYawnTimer(int timer) {
        this.f_19804_.m_135381_(YAWN_TIMER, (Object)timer);
    }

    public int getYawnCooldown() {
        return (Integer)this.f_19804_.m_135370_(YAWN_COOLDOWN);
    }

    public void setYawnCooldown(int cooldown) {
        this.f_19804_.m_135381_(YAWN_COOLDOWN, (Object)cooldown);
    }

    public void yawnCooldown() {
        this.f_19804_.m_135381_(YAWN_COOLDOWN, (Object)(120 + this.f_19796_.m_188503_(2400)));
    }

    public int getSneezeTimer() {
        return (Integer)this.f_19804_.m_135370_(SNEEZE_TIMER);
    }

    public void setSneezeTimer(int timer) {
        this.f_19804_.m_135381_(SNEEZE_TIMER, (Object)timer);
    }

    public int getSneezeCooldown() {
        return (Integer)this.f_19804_.m_135370_(SNEEZE_COOLDOWN);
    }

    public void setSneezeCooldown(int cooldown) {
        this.f_19804_.m_135381_(SNEEZE_COOLDOWN, (Object)cooldown);
    }

    public void sneezeCooldown() {
        this.f_19804_.m_135381_(SNEEZE_COOLDOWN, (Object)(2400 + this.f_19796_.m_188503_(9600)));
    }

    public int getRearUpTimer() {
        return (Integer)this.f_19804_.m_135370_(REAR_UP_TIMER);
    }

    public void setRearUpTimer(int timer) {
        this.f_19804_.m_135381_(REAR_UP_TIMER, (Object)timer);
    }

    public int getRearUpCooldown() {
        return (Integer)this.f_19804_.m_135370_(REAR_UP_COOLDOWN);
    }

    public void setRearUpCooldown(int cooldown) {
        this.f_19804_.m_135381_(REAR_UP_COOLDOWN, (Object)cooldown);
    }

    public void rearUpCooldown() {
        this.f_19804_.m_135381_(REAR_UP_COOLDOWN, (Object)(2400 + this.f_19796_.m_188503_(9600)));
    }

    public boolean isGooberLayingDown() {
        return (Long)this.f_19804_.m_135370_(LAST_POSE_CHANGE_TICK) < 0L;
    }

    public boolean isGooberVisuallyLayingDown() {
        return this.getPoseTime() < 0L != this.isGooberLayingDown();
    }

    public boolean isInPoseTransition() {
        long l = this.getPoseTime();
        return l < (long)(this.isGooberLayingDown() ? 40 : 52);
    }

    private boolean isVisuallyLayingDown() {
        return this.isGooberLayingDown() && this.getPoseTime() < 40L && this.getPoseTime() >= 0L;
    }

    public void layDown() {
        if (this.isGooberLayingDown()) {
            return;
        }
        this.m_5496_((SoundEvent)SpeciesSoundEvents.GOOBER_LAY_DOWN.get(), 1.0f, 1.0f);
        this.m_20124_(SpeciesPose.LAYING_DOWN.get());
        this.resetLastPoseChangeTick(-this.m_9236_().m_46467_());
        this.m_6210_();
    }

    public void standUp() {
        if (!this.isGooberLayingDown()) {
            return;
        }
        this.m_20124_(Pose.STANDING);
        this.resetLastPoseChangeTick(this.m_9236_().m_46467_());
        this.m_6210_();
    }

    public void standUpInstantly() {
        this.m_20124_(Pose.STANDING);
        this.resetLastPoseChangeTickToFullStand(this.m_9236_().m_46467_());
        this.m_6210_();
    }

    @VisibleForTesting
    public void resetLastPoseChangeTick(long l) {
        this.f_19804_.m_135381_(LAST_POSE_CHANGE_TICK, (Object)l);
    }

    private void resetLastPoseChangeTickToFullStand(long l) {
        this.resetLastPoseChangeTick(Math.max(0L, l - 52L - 1L));
    }

    public long getPoseTime() {
        return this.m_9236_().m_46467_() - Math.abs((Long)this.f_19804_.m_135370_(LAST_POSE_CHANGE_TICK));
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.getBehavior().equals(GooberBehavior.IDLE.getName()) ? (this.isGooberLayingDown() ? (SoundEvent)SpeciesSoundEvents.GOOBER_IDLE_RESTING.get() : (SoundEvent)SpeciesSoundEvents.GOOBER_IDLE.get()) : SoundEvents.f_271165_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SpeciesSoundEvents.GOOBER_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SpeciesSoundEvents.GOOBER_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)SpeciesSoundEvents.GOOBER_STEP.get(), 0.35f, 1.0f);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)SpeciesEntities.GOOBER.get()).m_20615_((Level)serverLevel);
    }

    public static boolean canSpawn(EntityType<Goober> entity, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return false;
    }

    class GooberMoveControl
    extends MoveControl {
        public GooberMoveControl() {
            super((Mob)Goober.this);
        }

        public void m_8126_() {
            if (!Goober.this.refuseToMove()) {
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !Goober.this.m_21523_() && Goober.this.isGooberLayingDown() && !Goober.this.isInPoseTransition()) {
                    Goober.this.standUp();
                }
                super.m_8126_();
            }
        }
    }

    static class GooberLookControl
    extends LookControl {
        protected final Goober mob;

        GooberLookControl(Goober mob) {
            super((Mob)mob);
            this.mob = mob;
        }

        public void m_8128_() {
            if (!this.mob.refuseToMove()) {
                super.m_8128_();
            }
        }
    }

    class GooberBodyRotationControl
    extends BodyRotationControl {
        public GooberBodyRotationControl(Goober goober) {
            super((Mob)goober);
        }

        public void m_8121_() {
            if (!Goober.this.refuseToMove()) {
                super.m_8121_();
            }
        }
    }
}

