/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesRecipeSerializers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MobHeadFireworkStarRecipe
extends CustomRecipe {
    private static final Ingredient SHAPE_INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)SpeciesItems.QUAKE_HEAD.get(), (ItemLike)SpeciesItems.GHOUL_HEAD.get(), (ItemLike)SpeciesItems.BEWEREAGER_HEAD.get(), (ItemLike)SpeciesItems.WICKED_CANDLE.get()});
    private static final Map<Item, FireworkRocketItem.Shape> SHAPE_BY_ITEM = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put((Item)SpeciesItems.QUAKE_HEAD.get(), FireworkRocketItem.Shape.CREEPER);
        map.put((Item)SpeciesItems.GHOUL_HEAD.get(), FireworkRocketItem.Shape.CREEPER);
        map.put((Item)SpeciesItems.BEWEREAGER_HEAD.get(), FireworkRocketItem.Shape.CREEPER);
        map.put((Item)SpeciesItems.WICKED_CANDLE.get(), FireworkRocketItem.Shape.CREEPER);
    });
    private static final Ingredient TRAIL_INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_});
    private static final Ingredient FLICKER_INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42525_});
    private static final Ingredient GUNPOWDER_INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42403_});

    public MobHeadFireworkStarRecipe(ResourceLocation name, CraftingBookCategory category) {
        super(name, category);
    }

    public boolean matches(CraftingContainer p_43895_, Level p_43896_) {
        boolean flag = false;
        boolean flag1 = false;
        boolean flag2 = false;
        boolean flag3 = false;
        boolean flag4 = false;
        for (int i = 0; i < p_43895_.m_6643_(); ++i) {
            ItemStack itemstack = p_43895_.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            if (SHAPE_INGREDIENT.test(itemstack)) {
                if (flag2) {
                    return false;
                }
                flag2 = true;
                continue;
            }
            if (FLICKER_INGREDIENT.test(itemstack)) {
                if (flag4) {
                    return false;
                }
                flag4 = true;
                continue;
            }
            if (TRAIL_INGREDIENT.test(itemstack)) {
                if (flag3) {
                    return false;
                }
                flag3 = true;
                continue;
            }
            if (GUNPOWDER_INGREDIENT.test(itemstack)) {
                if (flag) {
                    return false;
                }
                flag = true;
                continue;
            }
            if (!(itemstack.m_41720_() instanceof DyeItem)) {
                return false;
            }
            flag1 = true;
        }
        return flag && flag1;
    }

    public ItemStack assemble(CraftingContainer p_43893_, RegistryAccess p_266692_) {
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42689_);
        CompoundTag compoundtag = itemstack.m_41698_("Explosion");
        FireworkRocketItem.Shape fireworkrocketitem$shape = FireworkRocketItem.Shape.SMALL_BALL;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < p_43893_.m_6643_(); ++i) {
            ItemStack itemstack1 = p_43893_.m_8020_(i);
            if (itemstack1.m_41619_()) continue;
            if (SHAPE_INGREDIENT.test(itemstack1)) {
                FireworkRocketItem.Shape shape = SHAPE_BY_ITEM.get(itemstack1.m_41720_());
                if (shape == null) continue;
                fireworkrocketitem$shape = shape;
                continue;
            }
            if (FLICKER_INGREDIENT.test(itemstack1)) {
                compoundtag.m_128379_("Flicker", true);
                continue;
            }
            if (TRAIL_INGREDIENT.test(itemstack1)) {
                compoundtag.m_128379_("Trail", true);
                continue;
            }
            if (!(itemstack1.m_41720_() instanceof DyeItem)) continue;
            list.add(((DyeItem)itemstack1.m_41720_()).m_41089_().m_41070_());
        }
        compoundtag.m_128408_("Colors", (List)list);
        fireworkrocketitem$shape.save(compoundtag);
        return itemstack;
    }

    public boolean m_8004_(int p_43885_, int p_43886_) {
        return p_43885_ * p_43886_ >= 2;
    }

    public ItemStack m_8043_(RegistryAccess p_266932_) {
        return new ItemStack((ItemLike)Items.f_42689_);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SpeciesRecipeSerializers.SPECIES_MOB_HEAD_FIREWORK_STAR.get();
    }
}

