/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.block;

import com.ninni.species.registry.SpeciesEntities;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.registry.SpeciesTags;
import com.ninni.species.server.block.property.SpeciesProperties;
import com.ninni.species.server.entity.mob.update_2.Goober;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PetrifiedEggBlock
extends Block {
    public static final int MAX_HATCH_LEVEL = 2;
    public static final IntegerProperty HATCH = BlockStateProperties.f_61416_;
    public static final BooleanProperty HEATED = SpeciesProperties.HEATED;
    private static final int REGULAR_HATCH_TIME_TICKS = 24000;
    private static final int BOOSTED_HATCH_TIME_TICKS = 12000;
    private static final int RANDOM_HATCH_OFFSET_TICKS = 300;
    private static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public PetrifiedEggBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0))).m_61124_((Property)HEATED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HATCH, HEATED});
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public int getHatchLevel(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)HATCH);
    }

    private boolean isHeated(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)HEATED);
    }

    private boolean isReadyToHatch(BlockState blockState) {
        return this.getHatchLevel(blockState) == 2;
    }

    public void m_213897_(BlockState state, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (this.isHeated(state)) {
            if (!this.isReadyToHatch(state)) {
                serverLevel.m_5594_(null, blockPos, (SoundEvent)SpeciesSoundEvents.PETRIFIED_EGG_CRACK.get(), SoundSource.BLOCKS, 0.7f, 0.9f + randomSource.m_188501_() * 0.2f);
                serverLevel.m_7731_(blockPos, (BlockState)state.m_61124_((Property)HATCH, (Comparable)Integer.valueOf(this.getHatchLevel(state) + 1)), 2);
                return;
            }
            serverLevel.m_5594_(null, blockPos, (SoundEvent)SpeciesSoundEvents.PETRIFIED_EGG_HATCH.get(), SoundSource.BLOCKS, 0.7f, 0.9f + randomSource.m_188501_() * 0.2f);
            serverLevel.m_46961_(blockPos, false);
            Goober goober = (Goober)((EntityType)SpeciesEntities.GOOBER.get()).m_20615_((Level)serverLevel);
            if (goober != null) {
                Vec3 vec3 = blockPos.m_252807_();
                goober.m_6863_(true);
                goober.m_7678_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), Mth.m_14177_((float)(serverLevel.f_46441_.m_188501_() * 360.0f)), 0.0f);
                serverLevel.m_7967_((Entity)goober);
            }
        }
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        boolean bl2 = PetrifiedEggBlock.hatchBoost((BlockGetter)level, blockPos);
        if (level.m_8055_(blockPos.m_7495_()).m_204336_(SpeciesTags.PETRIFIED_EGG_HATCH)) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)HEATED, (Comparable)Boolean.valueOf(true)), 2);
        }
        if (!level.m_5776_() && bl2) {
            level.m_46796_(3009, blockPos, 0);
        }
        int i = bl2 ? 12000 : 24000;
        int j = i / 3;
        level.m_220407_(GameEvent.f_157797_, blockPos, GameEvent.Context.m_223722_((BlockState)blockState));
        level.m_186460_(blockPos, (Block)this, j + level.f_46441_.m_188503_(300));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)HEATED, (Comparable)Boolean.valueOf(PetrifiedEggBlock.isBelowHeated((BlockGetter)blockPlaceContext.m_43725_(), blockPlaceContext.m_8083_())));
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (direction == Direction.DOWN) {
            return (BlockState)blockState.m_61124_((Property)HEATED, (Comparable)Boolean.valueOf(PetrifiedEggBlock.isBelowHeated((BlockGetter)levelAccessor, blockPos)));
        }
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }

    public static boolean isBelowHeated(BlockGetter blockGetter, BlockPos blockPos) {
        return blockGetter.m_8055_(blockPos.m_7495_()).m_204336_(SpeciesTags.PETRIFIED_EGG_HATCH);
    }

    public static boolean hatchBoost(BlockGetter blockGetter, BlockPos blockPos) {
        return blockGetter.m_8055_(blockPos.m_7495_()).m_204336_(SpeciesTags.PETRIFIED_EGG_HATCH_BOOST);
    }
}

