/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.client.renderer.entity.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ninni.species.client.model.mob.update_2.SpringlingModel;
import com.ninni.species.client.renderer.entity.SpringlingRenderer;
import com.ninni.species.server.entity.mob.update_2.Springling;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class SpringlingNeckLayer
extends RenderLayer<Springling, SpringlingModel<Springling>> {
    public SpringlingNeckLayer(RenderLayerParent<Springling, SpringlingModel<Springling>> parent) {
        super(parent);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Springling entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        float height;
        float interpolatedStep = Mth.m_14179_((float)partialTicks, (float)entity.previousQuantizedStep, (float)entity.currentQuantizedStep) / 10.0f;
        float vMax = height = interpolatedStep * -1.469f - 0.8125f;
        poseStack.m_85836_();
        if (entity.m_6162_()) {
            float scale = 0.25f;
            poseStack.m_85841_(scale, scale, scale);
            poseStack.m_252880_(0.0f, 4.5f, 0.0f);
        }
        Vec3 base = new Vec3(0.0, 0.0, 0.0);
        Vec3 tip = new Vec3(0.0, (double)height, 0.0);
        poseStack.m_85837_(0.0, 0.4375, 0.0);
        poseStack.m_252781_(new Quaternionf().rotationY(interpolatedStep * -2.0f));
        ResourceLocation texture = entity.m_7755_().getString().equalsIgnoreCase("piston") ? SpringlingRenderer.TEXTURE_PISTON_NECK : SpringlingRenderer.TEXTURE_NECK;
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)texture));
        int overlay = LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f);
        float halfWidth = 0.125f;
        this.drawNeckQuad(poseStack, builder, base.m_82520_(0.0, 0.0, (double)(-halfWidth)), tip.m_82520_(0.0, 0.0, (double)(-halfWidth)), new Vec3((double)halfWidth, 0.0, 0.0), new Vec3(0.0, 0.0, -1.0), vMax, packedLight, overlay);
        this.drawNeckQuad(poseStack, builder, base.m_82520_(0.0, 0.0, (double)halfWidth), tip.m_82520_(0.0, 0.0, (double)halfWidth), new Vec3((double)(-halfWidth), 0.0, 0.0), new Vec3(0.0, 0.0, 1.0), vMax, packedLight, overlay);
        this.drawNeckQuad(poseStack, builder, base.m_82520_((double)(-halfWidth), 0.0, 0.0), tip.m_82520_((double)(-halfWidth), 0.0, 0.0), new Vec3(0.0, 0.0, (double)halfWidth), new Vec3(-1.0, 0.0, 0.0), vMax, packedLight, overlay);
        this.drawNeckQuad(poseStack, builder, base.m_82520_((double)halfWidth, 0.0, 0.0), tip.m_82520_((double)halfWidth, 0.0, 0.0), new Vec3(0.0, 0.0, (double)(-halfWidth)), new Vec3(1.0, 0.0, 0.0), vMax, packedLight, overlay);
        poseStack.m_85849_();
    }

    public void drawNeckQuad(PoseStack poseStack, VertexConsumer builder, Vec3 base, Vec3 tip, Vec3 side, Vec3 normalDir, float vMax, int packedLight, int overlay) {
        PoseStack.Pose pose = poseStack.m_85850_();
        float uMin = 0.375f;
        float uMax = 0.625f;
        builder.m_252986_(pose.m_252922_(), (float)(base.f_82479_ + side.f_82479_), (float)(base.f_82480_ + side.f_82480_), (float)(base.f_82481_ + side.f_82481_)).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMin, 0.0f).m_86008_(overlay).m_85969_(packedLight).m_252939_(pose.m_252943_(), (float)normalDir.f_82479_, (float)normalDir.f_82480_, (float)normalDir.f_82481_).m_5752_();
        builder.m_252986_(pose.m_252922_(), (float)(base.f_82479_ - side.f_82479_), (float)(base.f_82480_ - side.f_82480_), (float)(base.f_82481_ - side.f_82481_)).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMax, 0.0f).m_86008_(overlay).m_85969_(packedLight).m_252939_(pose.m_252943_(), (float)normalDir.f_82479_, (float)normalDir.f_82480_, (float)normalDir.f_82481_).m_5752_();
        builder.m_252986_(pose.m_252922_(), (float)(tip.f_82479_ - side.f_82479_), (float)(tip.f_82480_ - side.f_82480_), (float)(tip.f_82481_ - side.f_82481_)).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMax, vMax).m_86008_(overlay).m_85969_(packedLight).m_252939_(pose.m_252943_(), (float)normalDir.f_82479_, (float)normalDir.f_82480_, (float)normalDir.f_82481_).m_5752_();
        builder.m_252986_(pose.m_252922_(), (float)(tip.f_82479_ + side.f_82479_), (float)(tip.f_82480_ + side.f_82480_), (float)(tip.f_82481_ + side.f_82481_)).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMin, vMax).m_86008_(overlay).m_85969_(packedLight).m_252939_(pose.m_252943_(), (float)normalDir.f_82479_, (float)normalDir.f_82480_, (float)normalDir.f_82481_).m_5752_();
    }
}

