/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.client.renderer.entity.feature;

import com.ninni.species.client.model.mob.update_3.SpectreModel;
import com.ninni.species.client.renderer.entity.SpectreRenderer;
import com.ninni.species.client.renderer.entity.rendertypes.OffsetRenderLayer;
import com.ninni.species.registry.SpeciesEntityModelLayers;
import com.ninni.species.server.entity.mob.update_3.Spectre;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpectreWiggleFeatureRenderer<T extends Spectre, M extends SpectreModel<T>>
extends OffsetRenderLayer<T, M> {
    private final SpectreModel<T> modelSpectre;
    private final SpectreModel<T> modelSableSpectre;
    private final SpectreModel<T> modelJoustingSpectre;

    public SpectreWiggleFeatureRenderer(RenderLayerParent<T, M> renderLayerParent, EntityRendererProvider.Context ctx) {
        super(renderLayerParent);
        this.modelSpectre = new SpectreModel(ctx.m_174023_(SpeciesEntityModelLayers.SPECTRE));
        this.modelSableSpectre = new SpectreModel(ctx.m_174023_(SpeciesEntityModelLayers.SABLE_SPECTRE));
        this.modelJoustingSpectre = new SpectreModel(ctx.m_174023_(SpeciesEntityModelLayers.JOUSTING_SPECTRE));
    }

    @Override
    protected float xOffset(float f) {
        return f * 0.01f;
    }

    @Override
    protected EntityModel<T> model(T entity) {
        return switch (((Spectre)entity).getVariant()) {
            default -> throw new IncompatibleClassChangeError();
            case Spectre.Type.SPECTRE -> this.modelSpectre;
            case Spectre.Type.HULKING_SPECTRE -> this.modelSableSpectre;
            case Spectre.Type.JOUSTING_SPECTRE -> this.modelJoustingSpectre;
        };
    }

    protected ResourceLocation getTextureLocation(T entity) {
        return SpectreRenderer.getSpectreVariantTextureLocation(entity, "spirit_wiggle");
    }
}

