/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.client.renderer.entity.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ninni.species.client.model.mob.update_3.SpectreModel;
import com.ninni.species.client.renderer.entity.SpectreRenderer;
import com.ninni.species.registry.SpeciesEntityModelLayers;
import com.ninni.species.registry.SpeciesRenderTypes;
import com.ninni.species.server.entity.mob.update_3.Spectre;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpectreBodyFeatureRenderer<T extends Spectre, M extends SpectreModel<T>>
extends RenderLayer<T, M> {
    private final SpectreModel<T> modelSpectre;
    private final SpectreModel<T> modelSableSpectre;
    private final SpectreModel<T> modelJoustingSpectre;

    public SpectreBodyFeatureRenderer(RenderLayerParent<T, M> renderLayerParent, EntityRendererProvider.Context ctx) {
        super(renderLayerParent);
        this.modelSpectre = new SpectreModel(ctx.m_174023_(SpeciesEntityModelLayers.SPECTRE));
        this.modelSableSpectre = new SpectreModel(ctx.m_174023_(SpeciesEntityModelLayers.SABLE_SPECTRE));
        this.modelJoustingSpectre = new SpectreModel(ctx.m_174023_(SpeciesEntityModelLayers.JOUSTING_SPECTRE));
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T spectre, float f, float g, float h, float j, float k, float l) {
        if (!spectre.m_20145_()) {
            ((SpectreModel)this.m_117386_()).m_102624_(this.model(spectre));
            this.model(spectre).m_6839_(spectre, f, g, h);
            this.model(spectre).m_6973_(spectre, f, g, j, k, l);
            VertexConsumer vertexConsumerCharged = multiBufferSource.m_6299_(SpeciesRenderTypes.spectreBody(this.getTEXTURE(spectre)));
            this.model(spectre).m_7695_(poseStack, vertexConsumerCharged, i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    protected EntityModel<T> model(T entity) {
        return switch (((Spectre)entity).getVariant()) {
            default -> throw new IncompatibleClassChangeError();
            case Spectre.Type.SPECTRE -> this.modelSpectre;
            case Spectre.Type.HULKING_SPECTRE -> this.modelSableSpectre;
            case Spectre.Type.JOUSTING_SPECTRE -> this.modelJoustingSpectre;
        };
    }

    public ResourceLocation getTEXTURE(T spectre) {
        if (spectre != null) {
            return ((Spectre)spectre).isFromSword() ? SpectreRenderer.getSpectreVariantTextureLocation(spectre, "spirit_tamed") : SpectreRenderer.getSpectreVariantTextureLocation(spectre, "spirit");
        }
        return new ResourceLocation("");
    }
}

