/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.client.renderer.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ninni.species.Species;
import com.ninni.species.client.model.mob_heads.BewereagerHeadModel;
import com.ninni.species.client.model.mob_heads.GhoulHeadModel;
import com.ninni.species.client.model.mob_heads.MobHeadModelBase;
import com.ninni.species.client.model.mob_heads.QuakeHeadModel;
import com.ninni.species.client.model.mob_heads.WickedHeadModel;
import com.ninni.species.registry.SpeciesEntityModelLayers;
import com.ninni.species.server.block.MobHeadBlock;
import com.ninni.species.server.block.WallMobHeadBlock;
import com.ninni.species.server.block.entity.MobHeadBlockEntity;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MobHeadBlockEntityRenderer
implements BlockEntityRenderer<MobHeadBlockEntity> {
    public final Map<MobHeadBlock.Type, MobHeadModelBase> modelByType;
    public static final Map<MobHeadBlock.Type, ResourceLocation> SKIN_BY_TYPE = (Map)Util.m_137469_((Object)Maps.newHashMap(), p_261388_ -> {
        p_261388_.put(MobHeadBlock.Types.GHOUL, new ResourceLocation("species", "textures/entity/ghoul/ghoul.png"));
        p_261388_.put(MobHeadBlock.Types.WICKED, new ResourceLocation("species", "textures/entity/wicked/wicked.png"));
        p_261388_.put(MobHeadBlock.Types.QUAKE, new ResourceLocation("species", "textures/entity/quake/quake.png"));
        p_261388_.put(MobHeadBlock.Types.BEWEREAGER, new ResourceLocation("species", "textures/entity/bewereager/bewereager.png"));
    });

    public static Map<MobHeadBlock.Type, MobHeadModelBase> createMobHeadRenderers(EntityModelSet root) {
        ModelPart bewere;
        ModelPart quake;
        ModelPart wicked;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ModelPart ghoul = MobHeadBlockEntityRenderer.safeBake(root, SpeciesEntityModelLayers.GHOUL_HEAD, "GhoulHeadModel");
        if (ghoul != null) {
            builder.put((Object)MobHeadBlock.Types.GHOUL, (Object)new GhoulHeadModel(ghoul));
        }
        if ((wicked = MobHeadBlockEntityRenderer.safeBake(root, SpeciesEntityModelLayers.WICKED_CANDLE, "WickedHeadModel")) != null) {
            builder.put((Object)MobHeadBlock.Types.WICKED, (Object)new WickedHeadModel(wicked));
        }
        if ((quake = MobHeadBlockEntityRenderer.safeBake(root, SpeciesEntityModelLayers.QUAKE_HEAD, "QuakeHeadModel")) != null) {
            builder.put((Object)MobHeadBlock.Types.QUAKE, (Object)new QuakeHeadModel(quake));
        }
        if ((bewere = MobHeadBlockEntityRenderer.safeBake(root, SpeciesEntityModelLayers.BEWEREAGER_HEAD, "BewereagerHeadModel")) != null) {
            builder.put((Object)MobHeadBlock.Types.BEWEREAGER, (Object)new BewereagerHeadModel(bewere));
        }
        return builder.build();
    }

    @Nullable
    private static ModelPart safeBake(EntityModelSet root, ModelLayerLocation layer, String who) {
        try {
            return root.m_171103_(layer);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            Species.LOGGER.warn("[Species] Skipping mob-head layer {} while creating {} ({}).", new Object[]{layer, who, e.toString()});
            return null;
        }
    }

    public MobHeadBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.modelByType = MobHeadBlockEntityRenderer.createMobHeadRenderers(context.m_173585_());
    }

    public void render(MobHeadBlockEntity blockEntity, float v, PoseStack poseStack, MultiBufferSource bufferSource, int i1, int i2) {
        float f = blockEntity.getAnimation(v);
        BlockState state = blockEntity.m_58900_();
        boolean flag = state.m_60734_() instanceof WallMobHeadBlock;
        Direction direction = flag ? (Direction)state.m_61143_((Property)WallMobHeadBlock.FACING) : null;
        int i = flag ? RotationSegment.m_245225_((Direction)direction.m_122424_()) : (Integer)state.m_61143_((Property)MobHeadBlock.ROTATION);
        float f1 = RotationSegment.m_245107_((int)i);
        MobHeadBlock.Type type = state.m_60734_() instanceof WallMobHeadBlock ? ((WallMobHeadBlock)state.m_60734_()).getType() : ((MobHeadBlock)state.m_60734_()).getType();
        MobHeadModelBase modelBase = this.modelByType.get(type);
        if (modelBase == null) {
            return;
        }
        RenderType rendertype = MobHeadBlockEntityRenderer.getRenderType(type);
        MobHeadBlockEntityRenderer.renderMobHead(direction, f1, f, poseStack, bufferSource, i1, modelBase, rendertype, null, type, false);
    }

    public static void renderMobHead(@Nullable Direction direction, float v, float v1, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, MobHeadModelBase modelBase, RenderType renderType, @Nullable ItemDisplayContext context, MobHeadBlock.Type type, boolean isLayer) {
        poseStack.m_85836_();
        if (direction == null) {
            poseStack.m_252880_(0.5f, 0.0f, 0.5f);
        } else if (type == MobHeadBlock.Types.QUAKE) {
            poseStack.m_252880_(0.5f - (float)direction.m_122429_() * 0.18625f, 0.25f, 0.5f - (float)direction.m_122431_() * 0.18625f);
        } else if (type == MobHeadBlock.Types.BEWEREAGER) {
            poseStack.m_252880_(0.5f - (float)direction.m_122429_() * 0.15f, 0.1925f, 0.5f - (float)direction.m_122431_() * 0.15f);
        } else {
            poseStack.m_252880_(0.5f - (float)direction.m_122429_() * 0.25f, 0.25f, 0.5f - (float)direction.m_122431_() * 0.25f);
        }
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        if (context != null) {
            if (type == MobHeadBlock.Types.GHOUL && context == ItemDisplayContext.GUI) {
                poseStack.m_85841_(0.85f, 0.85f, 0.85f);
                poseStack.m_252880_(0.0f, 0.0f, 0.125f);
            }
            if (type == MobHeadBlock.Types.QUAKE && context == ItemDisplayContext.GUI) {
                poseStack.m_85841_(0.9f, 0.9f, 0.9f);
            }
            if (type == MobHeadBlock.Types.WICKED && (context == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || context == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND)) {
                poseStack.m_252880_(0.0f, -0.2f, 0.0f);
            }
            if (type == MobHeadBlock.Types.BEWEREAGER && context == ItemDisplayContext.GUI) {
                poseStack.m_85841_(0.9f, 0.9f, 0.9f);
            }
        }
        if (isLayer) {
            if (type == MobHeadBlock.Types.WICKED) {
                poseStack.m_85841_(1.15f, 1.3f, 1.15f);
            }
            if (type == MobHeadBlock.Types.GHOUL) {
                poseStack.m_85841_(1.0f, 1.15f, 1.0f);
            }
            if (type == MobHeadBlock.Types.QUAKE) {
                poseStack.m_85841_(1.0f, 1.15f, 1.0f);
            }
        }
        VertexConsumer vertexconsumer = multiBufferSource.m_6299_(renderType);
        modelBase.setupAnim(v1, v, 0.0f);
        modelBase.m_7695_(poseStack, vertexconsumer, i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    public static RenderType getRenderType(MobHeadBlock.Type type) {
        return RenderType.m_110464_((ResourceLocation)SKIN_BY_TYPE.get(type));
    }
}

