/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.options;

import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.widgets.options.OptionEntry;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.GuiIcons;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class OptionEntryHeader
extends DLButton {
    public static final int DEFAULT_HEIGHT = 20;
    private final OptionEntry<?> parent;
    private boolean customMouseSelected;

    public OptionEntryHeader(OptionEntry<?> parent, int pX, int pY, int pWidth, Component pMessage, Consumer<OptionEntryHeader> pOnPress) {
        super(pX, pY, pWidth, 20, pMessage, pOnPress);
        this.parent = parent;
        this.setRenderStyle(DynamicGuiRenderer.AreaStyle.FLAT);
        this.setBackColor(0);
    }

    void setCustomMouseSelected(boolean b) {
        this.customMouseSelected = b;
    }

    boolean isSelected() {
        return this.isMouseSelected() || this.customMouseSelected;
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTick) {
        CreateDynamicWidgets.renderSingleShadeWidget(graphics, this.x(), this.y(), this.width(), this.height(), CreateDynamicWidgets.ColorShade.LIGHT);
        CreateDynamicWidgets.renderSingleShadeWidget(graphics, this.x(), this.y(), this.width(), 20, CreateDynamicWidgets.ColorShade.DARK);
        DynamicGuiRenderer.renderArea((Graphics)graphics, (int)this.x(), (int)this.y(), (int)this.f_93618_, (int)this.f_93619_, (int)this.getBackColor(), (DynamicGuiRenderer.AreaStyle)this.style, (DynamicGuiRenderer.ButtonState)(this.m_142518_() ? (this.m_93696_() || this.isSelected() ? DynamicGuiRenderer.ButtonState.SELECTED : DynamicGuiRenderer.ButtonState.BUTTON) : DynamicGuiRenderer.ButtonState.DISABLED));
        int j = this.f_93623_ ? (this.isSelected() ? -96 : -1) : -6381922;
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.x() + 5), (int)(this.y() + 6), (FormattedText)this.m_6035_(), (int)j, (EAlignment)EAlignment.LEFT, (boolean)false);
        if (this.parent.isExpanded()) {
            GuiIcons.ARROW_UP.render(graphics, this.x() + this.width() - 2 - 16, this.y() + 2);
        } else if (this.parent.getContentContainer() == null) {
            GuiIcons.ARROW_RIGHT.render(graphics, this.x() + this.width() - 2 - 16, this.y() + 2);
        } else {
            GuiIcons.ARROW_DOWN.render(graphics, this.x() + this.width() - 2 - 16, this.y() + 2);
        }
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
        if (this.isMouseSelected()) {
            GuiUtils.renderTooltip((Screen)this.parent.getParentScreen(), (AbstractWidget)this, this.parent.getTooltips(), (int)this.parent.getParentScreen().f_96543_, (Graphics)graphics, (int)mouseX, (int)mouseY);
        }
    }

    protected void renderDescriptionTooltip(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        DLUtils.doIfNotNull(this.parent.getTooltips(), t -> {
            float scale = 0.75f;
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_252880_((float)mouseX, (float)mouseY, 0.0f);
            graphics.poseStack().m_85841_(0.75f, 0.75f, 1.0f);
            int maxLineWidth = t.stream().mapToInt(x -> this.font.m_92852_(x)).max().orElse(0);
            Objects.requireNonNull(this.font);
            GuiUtils.fill((Graphics)graphics, (int)8, (int)12, (int)(maxLineWidth + 6), (int)((9 + 2) * t.size() + 4), (int)-1442840576);
            for (int i = 0; i < t.size(); ++i) {
                FormattedText line = (FormattedText)t.get(i);
                Objects.requireNonNull(this.font);
                GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)12, (int)(16 + (9 + 2) * i), (FormattedText)line, (int)-1, (EAlignment)EAlignment.LEFT, (boolean)false);
            }
            graphics.poseStack().m_85849_();
        });
    }
}

