/*
 * Decompiled with CFR 0.152.
 */
package fuzs.resourcepackoverrides.client.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuzs.resourcepackoverrides.ResourcePackOverrides;
import fuzs.resourcepackoverrides.client.data.JsonConfigFileUtil;
import fuzs.resourcepackoverrides.client.data.PackSelectionOverride;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.util.GsonHelper;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public class ResourceOverridesManager {
    private static final String FILE_NAME = "resourcepackoverrides.json";
    private static final String SCHEMA_VERSION = String.valueOf(2);
    private static final String GROUP_PREFIX = "$$";
    private static Map<String, PackSelectionOverride> overridesById = Maps.newHashMap();
    private static List<String> defaultResourcePacks;
    private static PackSelectionOverride defaultOverride;
    private static int failedReloads;

    public static PackSelectionOverride getOverride(String id) {
        if (defaultOverride == null) {
            ResourceOverridesManager.load();
        }
        return overridesById.getOrDefault(id, defaultOverride);
    }

    public static List<String> getDefaultResourcePacks(boolean failed) {
        if (defaultResourcePacks == null) {
            ResourceOverridesManager.load();
        }
        if (failed && --failedReloads < 0) {
            return ImmutableList.of();
        }
        return defaultResourcePacks;
    }

    public static void load() {
        defaultResourcePacks = ImmutableList.of();
        defaultOverride = PackSelectionOverride.EMPTY;
        JsonConfigFileUtil.getAndLoad(FILE_NAME, file -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("schema_version", SCHEMA_VERSION);
            JsonConfigFileUtil.saveToFile(file, (JsonElement)jsonObject);
        }, ResourceOverridesManager::deserializeAllOverrides);
    }

    private static void deserializeAllOverrides(FileReader reader) {
        JsonElement jsonElement = (JsonElement)JsonConfigFileUtil.GSON.fromJson((Reader)reader, JsonElement.class);
        JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"resource pack override");
        String schemaVersion = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"schema_version", (String)"1");
        if (!schemaVersion.equals(SCHEMA_VERSION)) {
            ResourcePackOverrides.LOGGER.warn("Outdated config schema! Config might not work correctly. Current schema is {}.", (Object)SCHEMA_VERSION);
        }
        failedReloads = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"failed_reloads_per_session", (int)5);
        if (jsonObject.has("default_packs")) {
            JsonArray resourcePacks = jsonObject.getAsJsonArray("default_packs");
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object resourcePack : resourcePacks) {
                builder.add((Object)resourcePack.getAsString());
            }
            defaultResourcePacks = builder.build();
        }
        if (jsonObject.has("default_overrides")) {
            defaultOverride = ResourceOverridesManager.deserializeOverrideEntry(jsonObject.get("default_overrides"));
        }
        if (!jsonObject.has("pack_overrides")) {
            return;
        }
        HashMap packOverrides = Maps.newHashMap();
        HashMap overrideGroups = Maps.newHashMap();
        JsonObject overrides = jsonObject.getAsJsonObject("pack_overrides");
        for (Map.Entry entry : overrides.entrySet()) {
            JsonElement packOverride = (JsonElement)entry.getValue();
            if (packOverride.isJsonObject()) {
                packOverrides.put((String)entry.getKey(), ResourceOverridesManager.deserializeOverrideEntry(packOverride));
                continue;
            }
            if (!packOverride.isJsonArray()) continue;
            JsonArray jsonArray = GsonHelper.m_13924_((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
            List groupIds = overrideGroups.computeIfAbsent((String)entry.getKey(), id -> Lists.newArrayList());
            for (JsonElement groupValue : jsonArray) {
                groupIds.add(groupValue.getAsString());
            }
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String prefix = schemaVersion.equals("1") ? "$" : GROUP_PREFIX;
        for (Map.Entry entry : packOverrides.entrySet()) {
            String id2 = (String)entry.getKey();
            if (id2.startsWith(prefix)) {
                List groupIds = (List)overrideGroups.get(id2.substring(prefix.length()));
                if (groupIds == null) {
                    throw new IllegalArgumentException("Unknown group id %s".formatted(id2));
                }
                for (String groupId : groupIds) {
                    builder.put((Object)groupId, (Object)((PackSelectionOverride)entry.getValue()));
                }
                continue;
            }
            builder.put((Object)id2, (Object)((PackSelectionOverride)entry.getValue()));
        }
        overridesById = builder.build();
    }

    private static PackSelectionOverride deserializeOverrideEntry(JsonElement jsonElement) {
        JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"resource pack override");
        Component title = (Component)ResourceOverridesManager.getOptionalString(jsonObject, "title", Component.Serializer::m_130701_);
        Component description = (Component)ResourceOverridesManager.getOptionalString(jsonObject, "description", Component.Serializer::m_130701_);
        Pack.Position defaultPosition = ResourceOverridesManager.getOptionalString(jsonObject, "default_position", s -> {
            try {
                return Pack.Position.valueOf((String)s.toUpperCase(Locale.ROOT));
            }
            catch (Exception ignored) {
                return null;
            }
        });
        PackCompatibility compatible = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"force_compatible", (boolean)false) ? PackCompatibility.COMPATIBLE : null;
        Boolean fixedPosition = ResourceOverridesManager.getOptionalFlag(jsonObject, "fixed_position");
        Boolean required = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"required", (boolean)false) ? Boolean.valueOf(true) : null;
        Boolean hidden = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"hidden", (boolean)false) ? Boolean.valueOf(true) : null;
        return new PackSelectionOverride(title, description, defaultPosition, compatible, fixedPosition, required, hidden);
    }

    @Nullable
    private static <T> T getOptionalString(JsonObject jsonObject, String memberName, Function<String, T> converter) {
        return jsonObject.has(memberName) ? (T)converter.apply(GsonHelper.m_13906_((JsonObject)jsonObject, (String)memberName)) : null;
    }

    @Nullable
    private static Boolean getOptionalFlag(JsonObject jsonObject, String memberName) {
        return jsonObject.has(memberName) ? Boolean.valueOf(jsonObject.get(memberName).getAsBoolean()) : null;
    }
}

